/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.barcode.ui;

import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.item.barcode.model.BarcodeContentType;
import org.eclipse.birt.report.item.barcode.model.BarcodeData;
import org.eclipse.birt.report.item.barcode.model.BarcodeItem;
import org.eclipse.birt.report.item.barcode.model.BarcodeType;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BarcodeEditorTrayDialog
extends TrayDialog {
    protected BarcodeItem barcodeItem;
    private ComboViewer barcodeTypeComboViewer;
    private ComboViewer correctionComboViewer;
    private Text contentText;

    protected BarcodeEditorTrayDialog(Shell shell, BarcodeItem item) {
        super(shell);
        this.barcodeItem = item;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(400, 400);
        newShell.setText("Barcode Settings");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(container, 0);
        label.setText("Barcode Type:");
        this.barcodeTypeComboViewer = new ComboViewer(container, 0);
        this.barcodeTypeComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.barcodeTypeComboViewer.setInput((Object)BarcodeType.getFormatNames());
        this.barcodeTypeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                BarcodeEditorTrayDialog.this.validate();
            }
        });
        Combo combo = this.barcodeTypeComboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(container, 0);
        label = new Label(container, 0);
        label.setText("Correction:");
        this.correctionComboViewer = new ComboViewer(container, 0);
        this.correctionComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.correctionComboViewer.setInput((Object)BarcodeType.getCorrectionNames());
        this.correctionComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                BarcodeEditorTrayDialog.this.validate();
            }
        });
        combo = this.correctionComboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(container, 0);
        label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        label.setText("Content:");
        this.contentText = new Text(container, 2818);
        this.contentText.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.contentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                BarcodeEditorTrayDialog.this.validate();
            }
        });
        ExpressionButton expressionButton = ExpressionButtonUtil.createExpressionButton((Composite)container, (Control)this.contentText, (IExpressionProvider)new ExpressionProvider((DesignElementHandle)this.barcodeItem.getModelHandle()), (Object)this.barcodeItem.getModelHandle(), (boolean)true, (int)8);
        this.setContent(expressionButton);
        return container;
    }

    private void setContent(ExpressionButton expressionButton) {
        BarcodeData data = new BarcodeData(this.barcodeItem);
        System.err.println(data.getBarcodeType());
        this.barcodeTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)data.getBarcodeType().name()));
        System.err.println(data.getCorrection());
        this.correctionComboViewer.setSelection((ISelection)new StructuredSelection((Object)data.getCorrection().name()));
        System.err.println((Object)((Object)data.getContentType()) + ":" + data.getContent());
        this.contentText.setText(data.getContent());
        this.contentText.setData("exprType", (Object)(data.getContentType() == BarcodeContentType.SCRIPT ? "javascript" : "constant"));
        expressionButton.refresh();
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.validate();
        return control;
    }

    protected void okPressed() {
        try {
            StructuredSelection selection = (StructuredSelection)this.barcodeTypeComboViewer.getSelection();
            this.barcodeItem.setBarcodeType(new Expression(selection.getFirstElement(), "constant"));
            selection = (StructuredSelection)this.correctionComboViewer.getSelection();
            this.barcodeItem.setCorrection(new Expression(selection.getFirstElement(), "constant"));
            this.barcodeItem.setContent(new Expression((Object)this.contentText.getText(), (String)this.contentText.getData("exprType")));
        }
        catch (SemanticException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    private void validate() {
        Button button = this.getButton(0);
        if (button == null) {
            return;
        }
        button.setEnabled(!this.barcodeTypeComboViewer.getSelection().isEmpty() && !this.correctionComboViewer.getSelection().isEmpty() && !this.contentText.getText().trim().isEmpty());
    }
}

