/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.barcode.model;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BarcodeType {
    private static Map<String, BarcodeFormat> cachedFormats = new HashMap<String, BarcodeFormat>();

    static {
        BarcodeFormat[] barcodeFormatArray = BarcodeFormat.values();
        int n = barcodeFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            BarcodeFormat value = barcodeFormatArray[n2];
            if (BarcodeType.isSupportedBarcodeFormat(value)) {
                cachedFormats.put(value.name().toUpperCase(Locale.ENGLISH), value);
            }
            ++n2;
        }
    }

    private static boolean isSupportedBarcodeFormat(BarcodeFormat format) {
        return format == BarcodeFormat.CODABAR || format == BarcodeFormat.CODE_39 || format == BarcodeFormat.CODE_128 || format == BarcodeFormat.EAN_8 || format == BarcodeFormat.EAN_13 || format == BarcodeFormat.ITF || format == BarcodeFormat.PDF_417 || format == BarcodeFormat.QR_CODE || format == BarcodeFormat.UPC_A;
    }

    public static String[] getFormatNames() {
        Set<String> values = cachedFormats.keySet();
        String[] array = new String[values.size()];
        int i = 0;
        for (String value : values) {
            array[i++] = value;
        }
        return array;
    }

    public static String[] getCorrectionNames() {
        String[] array = new String[ErrorCorrectionLevel.values().length];
        int i = 0;
        ErrorCorrectionLevel[] errorCorrectionLevelArray = ErrorCorrectionLevel.values();
        int n = errorCorrectionLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorCorrectionLevel value = errorCorrectionLevelArray[n2];
            array[i++] = value.name();
            ++n2;
        }
        return array;
    }

    public static String getDefaultEncoding() {
        return "UTF-8";
    }
}

