/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.CacheResultIterator;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.NamingRelationUtil;

public class CachedQueryResults
implements IQueryResults {
    private String queryResultID;
    private IResultIterator resultIterator;
    private IPreparedQuery pQuery;
    private String name;
    private DataEngineSession session;
    private boolean existCachedFile = true;
    private static Logger logger = Logger.getLogger(CachedQueryResults.class.getName());

    public CachedQueryResults(DataEngineSession session, String queryResultID, IPreparedQuery preparedQuery, Map appContext) throws DataException {
        this.session = session;
        String tempDir = session.getTempDir();
        Object[] params = new Object[]{tempDir, queryResultID};
        logger.entering(CachedQueryResults.class.getName(), "CachedQueryResults", params);
        this.queryResultID = queryResultID;
        this.pQuery = preparedQuery;
        this.resultIterator = new CacheResultIterator(session, tempDir, this, appContext);
        this.existCachedFile = ((CacheResultIterator)this.resultIterator).existCachedFile();
        logger.exiting(CachedQueryResults.class.getName(), "CachedQueryResults");
    }

    public IPreparedQuery getPreparedQuery() {
        return this.pQuery;
    }

    public IResultIterator getResultIterator() throws BirtException {
        return this.resultIterator;
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        return this.resultIterator.getResultMetaData();
    }

    public void close() throws BirtException {
        if (this.resultIterator != null) {
            this.resultIterator.close();
        }
        NamingRelationUtil.merge(this.session, this.getPreparedQuery().getReportQueryDefn(), this);
    }

    public String getID() {
        return this.queryResultID;
    }

    public void cancel() {
    }

    public boolean existCachedFile() {
        return this.existCachedFile;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

