/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.formattedtext;

import org.eclipse.nebula.widgets.formattedtext.AbstractFormatter;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class IPAddressFormatter
extends AbstractFormatter {
    private StringBuffer inputCache = new StringBuffer();
    private int begin = 0;
    private int end = 0;
    protected Listener keyListener;

    public IPAddressFormatter() {
        int i = 1;
        while (i <= 12) {
            this.inputCache.append(' ');
            if (i != 12 && i % 3 == 0) {
                this.inputCache.append('.');
            }
            ++i;
        }
        this.keyListener = new Listener(){

            public void handleEvent(Event e) {
                int currPos = IPAddressFormatter.this.text.getCaretPosition();
                int nextBegin = 4 * (currPos / 4 + 1);
                int nextEnd = nextBegin + 3;
                if (nextBegin > 12 || e.character != ' ') {
                    return;
                }
                IPAddressFormatter.this.text.setSelection(nextBegin, nextEnd);
                e.doit = false;
            }
        };
    }

    private void locateCurrentArea() {
        int pos;
        this.end = pos = this.text.getCaretPosition();
        while (this.end < 15 && this.inputCache.charAt(this.end) != '.') {
            ++this.end;
        }
        this.begin = this.end - 4;
    }

    private boolean isValidPart(String ipp) {
        int num = 0;
        char[] cArray = ipp.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int n3 = c - 48;
            if (n3 < 0 || n3 > 9) {
                return false;
            }
            num = 10 * num + n3;
            ++n2;
        }
        return num >= 0 && num <= 255;
    }

    private int delClear(int b, int e) {
        int pos = b;
        while (pos < e) {
            if (this.inputCache.charAt(pos) != '.') {
                this.inputCache.setCharAt(pos, ' ');
            }
            ++pos;
        }
        this.adjustInputCache();
        this.locateCurrentArea();
        if (e > 0 && this.inputCache.charAt(e - 1) == ' ' && e < 15 && this.inputCache.charAt(e) == '.' || e == 15 && this.inputCache.charAt(e - 1) == ' ') {
            return this.begin;
        }
        return e;
    }

    private int bspaceClear(int b, int e) {
        int pos = b;
        while (pos < e) {
            if (this.inputCache.charAt(pos) != '.') {
                this.inputCache.setCharAt(pos, ' ');
            }
            ++pos;
        }
        this.adjustInputCache();
        this.locateCurrentArea();
        String currPart = this.inputCache.substring(this.begin + 1, this.end);
        int p = 0;
        while (p < 3 && currPart.charAt(p) == ' ') {
            ++p;
        }
        if (e < 15 && this.inputCache.charAt(e) == ' ') {
            return this.begin + p + 1;
        }
        if (e < 15 && this.inputCache.charAt(e) == '.') {
            return this.end + 1;
        }
        return e;
    }

    private void adjustInputCache() {
        String[] parts = this.inputCache.toString().split("[.]");
        int i = 1;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            part = part.trim();
            StringBuffer temp = new StringBuffer(part);
            int j = 0;
            while (j < temp.length()) {
                if (temp.charAt(j) == ' ') {
                    temp.deleteCharAt(j);
                }
                ++j;
            }
            int spaceLength = 3 - temp.length();
            while (spaceLength-- > 0) {
                temp.insert(0, ' ');
            }
            part = temp.toString();
            this.inputCache.replace(4 * (i - 1), 4 * i - 1, part);
            ++i;
            ++n2;
        }
    }

    private int insert(String txt, int pos) {
        this.locateCurrentArea();
        String currPart = this.inputCache.substring(this.begin + 1, this.end);
        if (txt.length() > 3) {
            return this.end;
        }
        if (txt.length() + currPart.trim().length() > 3) {
            return this.end;
        }
        int currPos = this.text.getCaretPosition();
        if (this.isValidPart(currPart.trim()) && currPart.trim().length() == 3 && currPos == this.end) {
            return this.end + 2;
        }
        StringBuffer currEdit = new StringBuffer(currPart);
        int b = 0;
        while (b < 3 && currEdit.charAt(b) == ' ') {
            ++b;
        }
        int relativeInsertPos = pos - this.begin - 1;
        if (relativeInsertPos > this.end || relativeInsertPos < b) {
            relativeInsertPos = b;
        }
        currEdit.insert(relativeInsertPos, txt);
        if (!this.isValidPart(currEdit.toString().trim())) {
            this.beep();
            return this.end;
        }
        int currLength = currEdit.length();
        currEdit.delete(0, currLength - 3);
        this.inputCache.replace(this.begin + 1, this.end, currEdit.toString());
        currLength = currEdit.toString().trim().length();
        if (currLength == 3) {
            if (pos == this.end) {
                return this.end + 1;
            }
            return this.end;
        }
        if (pos > 0 && pos < 15 && this.inputCache.charAt(pos - 1) != ' ' && this.inputCache.charAt(pos) != ' ') {
            return pos;
        }
        if (pos < 15 && this.inputCache.charAt(pos) == ' ') {
            return this.begin + b + 1;
        }
        return this.end;
    }

    @Override
    public void detach() {
        this.text.removeListener(1, this.keyListener);
    }

    @Override
    public void setText(Text text) {
        super.setText(text);
        text.addListener(1, this.keyListener);
    }

    @Override
    public String getDisplayString() {
        return this.inputCache.toString();
    }

    @Override
    public String getEditString() {
        return this.inputCache.toString();
    }

    @Override
    public Object getValue() {
        if (this.isValid()) {
            StringBuffer value = new StringBuffer(this.inputCache);
            int i = 0;
            i = 0;
            while (i < value.length()) {
                if (value.charAt(i) == ' ') {
                    value.deleteCharAt(i);
                }
                ++i;
            }
            return value.toString();
        }
        return null;
    }

    @Override
    public boolean isValid() {
        String[] parts;
        String[] stringArray = parts = this.inputCache.toString().split("[.]");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!this.isValidPart(part = part.trim())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            String ip = value.toString();
            String[] parts = ip.split("[.]");
            int i = 1;
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (!this.isValidPart(part)) {
                    throw new IllegalArgumentException("Invalid ip address");
                }
                this.inputCache.replace(4 * i - 1 - part.length(), 4 * i - 1, part);
                ++i;
                ++n2;
            }
        } else if (value == null) {
            this.delClear(0, 15);
        } else {
            throw new IllegalArgumentException("Invalid ip address");
        }
    }

    public void verifyText(VerifyEvent e) {
        if (this.ignore) {
            return;
        }
        e.doit = false;
        e.start = e.keyCode == 8 ? this.bspaceClear(e.start, e.end) : (e.keyCode == 127 ? this.delClear(e.start, e.end) : this.insert(e.text, e.start));
        this.updateText(this.inputCache.toString(), e.start);
    }

    public Class<String> getValueType() {
        return String.class;
    }

    @Override
    public boolean isEmpty() {
        return !this.isValid();
    }
}

