/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.render;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.extension.render.Line;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;

public class Scatter
extends Line {
    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        Marker m;
        double[] faY;
        double[] faX;
        DataPointHints[] dpha;
        SeriesRenderingHints srh;
        AbstractScriptHandler sh;
        ScatterSeries ss;
        block53: {
            Fill fPaletteEntry;
            int iThisSeriesIndex;
            boolean bPaletteByCategory;
            EList elPalette;
            block58: {
                boolean bConnectMissing;
                LineRenderEvent lre;
                LineAttributes lia;
                block54: {
                    ChartWithAxes cwa;
                    block52: {
                        cwa = (ChartWithAxes)this.getModel();
                        if (cwa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.scatter.dimension", new Object[]{cwa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                        logger.log(1, Messages.getString("info.render.series", new Object[]{((Object)((Object)this)).getClass().getName(), this.iSeriesIndex + 1, this.iSeriesCount}, this.getRunTimeContext().getULocale()));
                        ss = (ScatterSeries)this.getSeries();
                        if (!ss.isVisible()) {
                            this.restoreClipping(ipr);
                            return;
                        }
                        sh = this.getRunTimeContext().getScriptHandler();
                        srh = (SeriesRenderingHints)isrh;
                        dpha = srh.getDataPoints();
                        lia = ss.getLineAttributes();
                        faX = new double[dpha.length];
                        faY = new double[dpha.length];
                        SeriesDefinition sd = this.getSeriesDefinition();
                        elPalette = sd.getSeriesPalette().getEntries();
                        if (elPalette.isEmpty()) {
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{ss}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                        bPaletteByCategory = this.isPaletteByCategory();
                        if (bPaletteByCategory && ss.eContainer() instanceof SeriesDefinition) {
                            sd = (SeriesDefinition)ss.eContainer();
                        }
                        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ss)) < 0) {
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ss, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                        m = null;
                        if (ss.getMarkers().size() > 0) {
                            m = (Marker)ss.getMarkers().get(iThisSeriesIndex % ss.getMarkers().size());
                        }
                        fPaletteEntry = null;
                        if (!bPaletteByCategory) {
                            fPaletteEntry = FillUtil.getPaletteFill((EList)elPalette, (int)iThisSeriesIndex);
                        } else if (this.iSeriesIndex > 0) {
                            fPaletteEntry = FillUtil.getPaletteFill((EList)elPalette, (int)(this.iSeriesIndex - 1));
                        }
                        this.updateTranslucency(fPaletteEntry, (Series)ss);
                        boolean isCategoryAxis = srh.isCategoryScale();
                        int i = 0;
                        while (i < dpha.length) {
                            double unitSize = dpha[i].getSize();
                            Location lo = dpha[i].getLocation();
                            if (cwa.isTransposed()) {
                                faX[i] = lo.getX();
                                faY[i] = lo.getY() + (isCategoryAxis ? unitSize / 2.0 : 0.0);
                            } else {
                                faX[i] = lo.getX() + (isCategoryAxis ? unitSize / 2.0 : 0.0);
                                faY[i] = lo.getY();
                            }
                            ++i;
                        }
                        this.handleOutsideDataPoints(ipr, srh, faX, faY, false);
                        if (!ss.isCurve()) break block52;
                        CurveRenderer cr = new CurveRenderer(cwa, (BaseRenderer)this, ss.getLineAttributes(), goFactory.createLocations(faX, faY), false, -1.0, false, true, fPaletteEntry, ss.isPaletteLineColor(), true);
                        cr.draw(ipr);
                        this.renderShadowAsCurve(ipr, lia, (ISeriesRenderingHints)srh, goFactory.createLocations(faX, faY), false, -1.0);
                        if (m != null) {
                            int i2 = 0;
                            while (i2 < dpha.length) {
                                if (!dpha[i2].isOutside()) {
                                    fPaletteEntry = bPaletteByCategory ? FillUtil.getPaletteFill((EList)elPalette, (int)i2) : FillUtil.getPaletteFill((EList)elPalette, (int)iThisSeriesIndex);
                                    this.updateTranslucency(fPaletteEntry, (Series)ss);
                                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i2], (Object)fPaletteEntry);
                                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i2], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                                    this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i2]);
                                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i2]);
                                    this.renderMarker(ss, ipr, m, goFactory.createLocation(faX[i2], faY[i2]), ss.getLineAttributes(), fPaletteEntry, dpha[i2], null, true, true);
                                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i2], (Object)fPaletteEntry);
                                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i2], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                                    this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i2]);
                                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i2]);
                                }
                                ++i2;
                            }
                        }
                        break block53;
                    }
                    Location positionDelta = cwa.isTransposed() ? goFactory.createLocation(-3.0 * this.getDeviceScale(), 0.0) : goFactory.createLocation(0.0, 3.0 * this.getDeviceScale());
                    Location[] loaShadow = null;
                    lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)ss), LineRenderEvent.class);
                    ColorDefinition cLineShadow = ss.getShadowColor();
                    bConnectMissing = ss.isConnectMissingValue();
                    if (ChartUtil.isColorTransparent((ColorDefinition)cLineShadow)) break block54;
                    int i = 1;
                    while (i < dpha.length) {
                        block57: {
                            int pindex;
                            block56: {
                                block55: {
                                    pindex = -1;
                                    if (!bConnectMissing) break block55;
                                    if (!Scatter.isNaN((Object)dpha[i].getOrthogonalValue()) && (pindex = this.getPreviousNonNullIndex(i, dpha)) != -1) break block56;
                                    break block57;
                                }
                                if (Scatter.isNaN((Object)dpha[i].getOrthogonalValue()) || i > 0 && Scatter.isNaN((Object)dpha[i - 1].getOrthogonalValue())) break block57;
                                pindex = i - 1;
                            }
                            if (loaShadow == null) {
                                loaShadow = new Location[]{goFactory.createLocation(faX[pindex] + positionDelta.getX(), faY[pindex] + positionDelta.getY()), goFactory.createLocation(faX[i] + positionDelta.getX(), faY[i] + positionDelta.getY())};
                            } else {
                                loaShadow[0].set(faX[pindex] + positionDelta.getX(), faY[pindex] + positionDelta.getY());
                                loaShadow[1].set(faX[i] + positionDelta.getX(), faY[i] + positionDelta.getY());
                            }
                            lre.setStart(loaShadow[0]);
                            lre.setEnd(loaShadow[1]);
                            LineAttributes liaShadow = goFactory.copyOf(lia);
                            liaShadow.setColor(cLineShadow);
                            lre.setLineAttributes(liaShadow);
                            ipr.drawLine(lre);
                        }
                        ++i;
                    }
                }
                if (!lia.isVisible()) break block58;
                Location[] loa = new Location[2];
                int i = 1;
                while (i < dpha.length) {
                    block61: {
                        int pindex;
                        block60: {
                            block59: {
                                pindex = -1;
                                if (!bConnectMissing) break block59;
                                if (!Scatter.isNaN((Object)dpha[i].getOrthogonalValue()) && (pindex = this.getPreviousNonNullIndex(i, dpha)) != -1) break block60;
                                break block61;
                            }
                            if (Scatter.isNaN((Object)dpha[i].getOrthogonalValue()) || i > 0 && Scatter.isNaN((Object)dpha[i - 1].getOrthogonalValue())) break block61;
                            pindex = i - 1;
                        }
                        loa[0] = goFactory.createLocation(faX[pindex], faY[pindex]);
                        loa[1] = goFactory.createLocation(faX[i], faY[i]);
                        lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)ss), LineRenderEvent.class);
                        if (ss.isPaletteLineColor()) {
                            LineAttributes newLia = goFactory.copyOf(lia);
                            newLia.setColor(FillUtil.getColor((Fill)fPaletteEntry));
                            lre.setLineAttributes(newLia);
                        } else {
                            lre.setLineAttributes(lia);
                        }
                        lre.setStart(loa[0]);
                        lre.setEnd(loa[1]);
                        ipr.drawLine(lre);
                    }
                    ++i;
                }
            }
            if (m != null) {
                int i = 0;
                while (i < dpha.length) {
                    if (!dpha[i].isOutside()) {
                        fPaletteEntry = bPaletteByCategory ? FillUtil.getPaletteFill((EList)elPalette, (int)i) : FillUtil.getPaletteFill((EList)elPalette, (int)iThisSeriesIndex);
                        this.updateTranslucency(fPaletteEntry, (Series)ss);
                        ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                        ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i]);
                        this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
                        this.renderMarker(ss, ipr, m, goFactory.createLocation(faX[i], faY[i]), ss.getLineAttributes(), fPaletteEntry, dpha[i], null, true, true);
                        ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
                        ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i]);
                        this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
                    }
                    ++i;
                }
            }
        }
        Label laDataPoint = null;
        Position pDataPoint = null;
        Location loDataPoint = null;
        try {
            laDataPoint = srh.getLabelAttributes((Series)ss);
            pDataPoint = srh.getLabelPosition((Series)ss);
            loDataPoint = goFactory.createLocation(0.0, 0.0);
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
        }
        if (laDataPoint.isVisible()) {
            double dSize = m == null ? 0 : m.getSize();
            int i = 0;
            while (i < dpha.length) {
                if (!Scatter.isNaN((Object)dpha[i].getOrthogonalValue()) && !dpha[i].isOutside()) {
                    laDataPoint = srh.getLabelAttributes((Series)ss);
                    laDataPoint.getCaption().setValue(dpha[i].getDisplayValue());
                    switch (pDataPoint.getValue()) {
                        case 0: {
                            loDataPoint.set(faX[i], faY[i] - dSize - (double)p.getVerticalSpacing());
                            break;
                        }
                        case 1: {
                            loDataPoint.set(faX[i], faY[i] + dSize + (double)p.getVerticalSpacing());
                            break;
                        }
                        case 2: {
                            loDataPoint.set(faX[i] - dSize - (double)p.getHorizontalSpacing(), faY[i]);
                            break;
                        }
                        case 3: {
                            loDataPoint.set(faX[i] + dSize + (double)p.getHorizontalSpacing(), faY[i]);
                            break;
                        }
                        default: {
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.invalid.data.point.position.scatter", new Object[]{pDataPoint}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                    }
                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)dpha[i]);
                    if (laDataPoint.isVisible()) {
                        this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)ss, (DataPointHints)dpha[i]), 2, laDataPoint, pDataPoint, loDataPoint, null);
                    }
                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)dpha[i]);
                }
                ++i;
            }
        }
        if (this.getSeries().getCurveFitting() != null) {
            Location[] larray = new Location[faX.length];
            int i = 0;
            while (i < larray.length) {
                larray[i] = goFactory.createLocation(faX[i], faY[i]);
                ++i;
            }
            larray = Scatter.filterNull((Location[])larray, (DataPointHints[])isrh.getDataPoints());
            this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), false, true);
        }
        this.restoreClipping(ipr);
    }
}

