/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.GetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.impl.SelectionChoiceComparator;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;

public class ParameterHelper {
    private static final String VALUE_PREFIX = "__VALUE__";
    private static final String LABEL_PREFIX = "__LABEL__";
    private boolean distinct;
    private Comparator comparator;
    private String labelColumnName;
    private String valueColumnName;
    private String valueType;
    private boolean fixedOrder;
    private boolean alreadySorted;
    private ReportParameterConverter converter;
    private int parameterType;
    static final int SCALAR_PARAMETER = 1;
    static final int FILTER_PARAMETER = 2;
    private String pattern = null;

    public ParameterHelper(AbstractScalarParameterHandle param, ULocale ulocale, TimeZone timezone) {
        this.labelColumnName = ParameterHelper.getLabelColumnName(param);
        this.valueColumnName = ParameterHelper.getValueColumnName(param);
        this.valueType = param.getDataType();
        this.alreadySorted = param.getSortByColumn() != null;
        this.distinct = param.distinct();
        String sortDirection = param.getSortDirection();
        boolean sortByLabel = "label".equalsIgnoreCase(param.getSortBy());
        if (param instanceof ScalarParameterHandle) {
            this.parameterType = 1;
            ScalarParameterHandle parameter = (ScalarParameterHandle)param;
            this.fixedOrder = parameter.isFixedOrder();
            if (param.getLabelExpr() == null) {
                this.pattern = parameter.getPattern();
            }
        } else {
            this.parameterType = 2;
        }
        if (!(this.parameterType == 1 && this.fixedOrder || this.alreadySorted || sortDirection == null)) {
            boolean sortDirectionValue = "asc".equalsIgnoreCase(sortDirection);
            SelectionChoiceComparator choiceComparator = new SelectionChoiceComparator(sortByLabel, this.pattern, sortDirectionValue, ulocale);
            this.comparator = new DistinctComparatorDecorator(choiceComparator, this.distinct);
        }
        this.converter = new ReportParameterConverter(this.pattern, ulocale, timezone);
    }

    public GetParameterDefinitionTask.CascadingParameterSelectionChoice createCascadingParameterSelectionChoice(IResultIterator iterator) throws BirtException {
        String label = this.getLabel(iterator);
        Object value = this.getValue(iterator);
        return new GetParameterDefinitionTask.CascadingParameterSelectionChoice(label, value);
    }

    public GetParameterDefinitionTask.CascadingParameterSelectionChoice createCascadingParameterSelectionChoice(IParameterSelectionChoice choice) {
        String label = choice.getLabel();
        Object value = choice.getValue();
        return new GetParameterDefinitionTask.CascadingParameterSelectionChoice(label, value);
    }

    public GetParameterDefinitionTask.CascadingParameterSelectionChoice createCascadingParameterSelectionChoice(String label, Object value) {
        return new GetParameterDefinitionTask.CascadingParameterSelectionChoice(label, value);
    }

    public Collection createSelectionCollection() {
        if (this.parameterType == 1 && this.fixedOrder || this.alreadySorted || this.comparator == null) {
            if (!this.distinct) {
                return new ArrayList();
            }
            return new ArrayList(){
                private static final long serialVersionUID = 1L;
                private Set values = new HashSet();

                public boolean add(Object arg0) {
                    if (!this.values.contains(arg0)) {
                        this.values.add(arg0);
                        return super.add(arg0);
                    }
                    return false;
                }
            };
        }
        return new TreeSet(this.comparator);
    }

    public String getLabel(IResultIterator resultIterator) throws BirtException {
        if (this.labelColumnName == null && this.pattern == null) {
            return null;
        }
        if (this.labelColumnName == null) {
            Object value = this.getValue(resultIterator);
            return this.converter.format(value);
        }
        String name = this.labelColumnName;
        Object value = resultIterator.getValue(name);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public Object getValue(IResultIterator resultIterator) throws BirtException {
        Object value = resultIterator.getValue(this.valueColumnName);
        return EngineTask.convertParameterType(value, this.valueType);
    }

    public static void addParameterBinding(QueryDefinition queryDefn, AbstractScalarParameterHandle parameter, IModelAdapter adapter) throws DataException {
        Expression mexpr;
        String labelColumnName = ParameterHelper.getLabelColumnName(parameter);
        String valueColumnName = ParameterHelper.getValueColumnName(parameter);
        if (labelColumnName != null) {
            mexpr = (Expression)parameter.getExpressionProperty("labelExpr").getValue();
            ScriptExpression dexpr = adapter.adaptExpression(mexpr);
            ParameterHelper.addBinding(queryDefn, labelColumnName, dexpr);
        }
        mexpr = (Expression)parameter.getExpressionProperty("valueExpr").getValue();
        String dataType = parameter.getDataType();
        if ("string".equals(dataType)) {
            dataType = "javaObject";
        }
        ScriptExpression dexpr = adapter.adaptExpression(mexpr, dataType);
        ParameterHelper.addBinding(queryDefn, valueColumnName, dexpr);
    }

    public static void addBinding(QueryDefinition queryDefinition, String columnName, ScriptExpression expr) throws DataException {
        Binding binding = new Binding(columnName, (IBaseExpression)expr);
        queryDefinition.addBinding((IBinding)binding);
    }

    public static void addParameterSortBy(QueryDefinition queryDefn, AbstractScalarParameterHandle parameter, IModelAdapter adapter) {
        String sortDirection;
        String sortBy = parameter.getSortByColumn();
        if (sortBy != null && (sortDirection = parameter.getSortDirection()) != null) {
            Expression mexpr = (Expression)parameter.getExpressionProperty("sortByColumn").getValue();
            ScriptExpression dexpr = adapter.adaptExpression(mexpr);
            SortDefinition sort = new SortDefinition();
            sort.setExpression((IScriptExpression)dexpr);
            boolean direction = "asc".equalsIgnoreCase(sortDirection);
            sort.setSortDirection(direction ? 0 : 1);
            queryDefn.addSort(sort);
        }
    }

    public static String getValueColumnName(AbstractScalarParameterHandle parameter) {
        return "__VALUE___" + parameter.getName();
    }

    public static String getLabelColumnName(AbstractScalarParameterHandle parameter) {
        if (parameter.getLabelExpr() == null) {
            return null;
        }
        return "__LABEL___" + parameter.getName();
    }

    static class DistinctComparatorDecorator
    implements Comparator {
        private boolean distinct;
        private Comparator comparator;

        public DistinctComparatorDecorator(Comparator comparator, boolean distinct) {
            this.comparator = comparator;
            this.distinct = distinct;
        }

        public int compare(Object obj1, Object obj2) {
            int result = this.comparator.compare(obj1, obj2);
            if (result == 0 && !this.distinct) {
                result = 1;
            }
            return result;
        }
    }
}

