/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.engine.api.DataExtractionOption;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IDataExtractionOption;
import org.eclipse.birt.report.engine.api.IDatasetPreviewTask;
import org.eclipse.birt.report.engine.api.IExtractionOption;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IRunnable;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ExtractionResults;
import org.eclipse.birt.report.engine.api.impl.ParameterValidationException;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.extension.IDataExtractionExtension;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.script.internal.ReportScriptExecutor;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class DatasetPreviewTask
extends EngineTask
implements IDatasetPreviewTask {
    protected IRunnable runnable;
    protected DataSetHandle dataset;
    protected int maxRow = -1;
    protected int startRow = 0;
    protected IFilterDefinition[] filterExpressions = null;
    protected ISortDefinition[] sortExpressions = null;
    protected String[] selectedColumns;

    protected DatasetPreviewTask(ReportEngine engine) {
        super(engine, 5);
    }

    public IExtractionResults execute() throws EngineException {
        if (this.dataset == null) {
            throw new IllegalArgumentException("dataset can not be null");
        }
        return this.runDataset();
    }

    public IExtractionResults extract() throws EngineException {
        return this.execute();
    }

    public void extract(IExtractionOption options) throws BirtException {
        DataExtractionOption option = null;
        option = options == null ? new DataExtractionOption() : new DataExtractionOption(options.getOptions());
        IDataExtractionOption extractOption = this.setupExtractOption(option);
        IDataExtractionExtension dataExtraction = this.getDataExtractionExtension(extractOption);
        try {
            dataExtraction.initialize(this.executionContext.getReportContext(), extractOption);
            IExtractionResults results = this.execute();
            if (this.executionContext.isCanceled()) {
                return;
            }
            dataExtraction.output(results);
        }
        finally {
            dataExtraction.release();
        }
    }

    private IDataExtractionOption setupExtractOption(IExtractionOption options) {
        IRenderOption defaultHtmlOptions;
        HashMap allOptions = new HashMap();
        HashMap configs = this.engine.getConfig().getEmitterConfigs();
        IRenderOption defaultOptions = (IRenderOption)configs.get("org.eclipse.birt.report.engine.api.EngineConfig.defaultRenderOption");
        if (defaultOptions != null) {
            allOptions.putAll(defaultOptions.getOptions());
        }
        if ((defaultHtmlOptions = (IRenderOption)configs.get("html")) != null) {
            allOptions.putAll(defaultHtmlOptions.getOptions());
        }
        allOptions.putAll(options.getOptions());
        Map appContext = this.executionContext.getAppContext();
        Object renderContext = appContext.get("HTML_RENDER_CONTEXT");
        if (renderContext == null) {
            HTMLRenderContext htmlContext = new HTMLRenderContext();
            HTMLRenderOption htmlOptions = new HTMLRenderOption(allOptions);
            htmlContext.setBaseImageURL(htmlOptions.getBaseImageURL());
            htmlContext.setBaseURL(htmlOptions.getBaseURL());
            htmlContext.setImageDirectory(htmlOptions.getImageDirectory());
            htmlContext.setSupportedImageFormats(htmlOptions.getSupportedImageFormats());
            htmlContext.setRenderOption(htmlOptions);
            appContext.put("HTML_RENDER_CONTEXT", htmlContext);
        }
        DataExtractionOption extractOption = new DataExtractionOption(allOptions);
        return extractOption;
    }

    private IDataExtractionExtension getDataExtractionExtension(IDataExtractionOption option) throws EngineException {
        IDataExtractionExtension dataExtraction = null;
        String extension = option.getExtension();
        ExtensionManager extensionManager = ExtensionManager.getInstance();
        if (extension != null) {
            dataExtraction = extensionManager.createDataExtractionExtensionById(extension);
        }
        String format = null;
        if (dataExtraction == null && (format = option.getOutputFormat()) != null) {
            dataExtraction = extensionManager.createDataExtractionExtensionByFormat(format);
        }
        if (dataExtraction == null) {
            throw new EngineException("Error.InvalidExtensionError", new Object[]{extension, format});
        }
        return dataExtraction;
    }

    public void setMaxRow(int maxRow) {
        this.maxRow = maxRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    protected void checkRequiredParamenter(String paramName, String value) throws ParameterValidationException {
    }

    public void setDataSet(DataSetHandle dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("dataset can not be null!");
        }
        this.dataset = dataset;
        ModuleHandle mh = dataset.getModuleHandle();
        this.runnable = new ReportRunnable((IReportEngine)this.engine, mh);
        this.setReportRunnable((ReportRunnable)this.runnable);
    }

    public void setRunnable(IRunnable runnable) {
        this.runnable = runnable;
        this.setReportRunnable((ReportRunnable)runnable);
    }

    public void selectColumns(String[] columnNames) {
        this.selectedColumns = columnNames;
    }

    public void setFilters(IFilterDefinition[] simpleFilterExpression) {
        this.filterExpressions = simpleFilterExpression;
    }

    public void setSorts(ISortDefinition[] simpleSortExpression) {
        this.sortExpressions = simpleSortExpression;
    }

    protected ModuleHandle getHandle() {
        return ((ReportRunnable)this.runnable).getModuleHandle();
    }

    protected IExtractionResults runDataset() throws EngineException {
        IExtractionResults resultset = null;
        try {
            this.switchToOsgiClassLoader();
            this.changeStatusToRunning();
            if (this.runnable == null) {
                throw new EngineException("Error.ReportRunnableNotSet");
            }
            resultset = this.doRun();
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
        }
        return resultset;
    }

    protected IExtractionResults doRun() throws EngineException {
        IExtractionResults result = null;
        this.usingParameterValues();
        this.initReportVariable();
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        try {
            try {
                this.executionContext.openDataEngine();
                result = this.extractQuery(this.dataset);
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "An error happened while extracting data the report. Cause:", ex);
                throw new EngineException("Error.ReportRunError", ex);
            }
            catch (OutOfMemoryError err) {
                this.log.log(Level.SEVERE, "There is insufficient memory to extract data from this report.");
                throw err;
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Error happened while running the report.", t);
                throw new EngineException("Error.ReportRunError", t);
            }
        }
        finally {
            this.closeFactory();
        }
        return result;
    }

    protected IExtractionResults extractQuery(DataSetHandle dataset) throws BirtException {
        QueryDefinition newQuery = this.constructQuery(dataset);
        DataRequestSession session = this.executionContext.getDataEngine().getDTESession();
        ModelDteApiAdapter apiAdapter = new ModelDteApiAdapter(this.executionContext);
        apiAdapter.defineDataSet(dataset, session);
        session.registerQueries((IDataQueryDefinition[])new IQueryDefinition[]{newQuery});
        IPreparedQuery preparedQuery = session.prepare((IQueryDefinition)newQuery);
        IQueryResults result = (IQueryResults)session.execute((IBasePreparedQuery)preparedQuery, null, this.executionContext.getScriptContext());
        ResultMetaData metadata = new ResultMetaData(result.getResultMetaData());
        if (this.selectedColumns != null) {
            metadata = new ResultMetaData(metadata, this.selectedColumns);
        }
        return new ExtractionResults(result, metadata, null, 0, -1, null);
    }

    protected ModuleHandle getModuleHandle() {
        return this.dataset.getModuleHandle();
    }

    protected QueryDefinition constructQuery(DataSetHandle dataset) throws DataException {
        int i;
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataset.getQualifiedName());
        query.setAutoBinding(true);
        if (this.maxRow >= 0) {
            query.setMaxRows(this.maxRow);
        }
        if (this.startRow > 0) {
            query.setStartingRow(this.startRow);
        }
        if (this.filterExpressions != null) {
            i = 0;
            while (i < this.filterExpressions.length) {
                query.getFilters().add(this.filterExpressions[i]);
                ++i;
            }
            this.filterExpressions = null;
        }
        if (this.sortExpressions != null) {
            i = 0;
            while (i < this.sortExpressions.length) {
                query.getSorts().add(this.sortExpressions[i]);
                ++i;
            }
            this.sortExpressions = null;
        }
        return query;
    }

    protected void validateStringParameter(String paramName, Object paramValue, AbstractScalarParameterHandle paramHandle) throws ParameterValidationException {
    }

    protected void loadDesign() {
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable != null) {
            ReportDesignHandle reportDesign = this.executionContext.getReportDesign();
            if (reportDesign != null) {
                Iterator iter = reportDesign.includeLibraryScriptsIterator();
                this.loadScript(iter);
                iter = reportDesign.includeScriptsIterator();
                this.loadScript(iter);
                ReportScriptExecutor.handleInitialize((ModuleHandle)reportDesign, this.executionContext);
            } else if (this.dataset != null) {
                ModuleHandle moduleHandle = this.dataset.getModuleHandle();
                Iterator iter = moduleHandle.includeScriptsIterator();
                this.loadScript(iter);
                ReportScriptExecutor.handleInitialize(moduleHandle, this.executionContext);
            }
        }
    }
}

