/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.expressions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.expressions.DefaultExpressionContext;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionContext;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionContextFactory;
import org.eclipse.birt.report.designer.internal.ui.script.JSExpressionContext;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.expressions.IExpressionFilterSupport;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionContextFactoryImpl
implements IExpressionContextFactory {
    private Map<String, IExpressionContext> contexts;
    private List<ExpressionFilter> filters;
    private Map<String, Object> extras = new HashMap<String, Object>();
    private IExpressionProvider provider;

    public ExpressionContextFactoryImpl(Object contextObj, IExpressionProvider javaScriptExpressionProvider) {
        this.contexts = new HashMap<String, IExpressionContext>();
        this.contexts.put("javascript", new JSExpressionContext(javaScriptExpressionProvider, contextObj));
        this.provider = javaScriptExpressionProvider;
        if (javaScriptExpressionProvider instanceof IExpressionFilterSupport) {
            this.filters = ((IExpressionFilterSupport)((Object)javaScriptExpressionProvider)).getFilters();
        }
    }

    public ExpressionContextFactoryImpl(Object contextObj, IExpressionProvider javaScriptExpressionProvider, Map<String, Object> extras) {
        this(contextObj, javaScriptExpressionProvider);
        this.extras.putAll(extras);
    }

    public ExpressionContextFactoryImpl(Map<String, IExpressionContext> contexts) {
        IExpressionProvider provider;
        this.contexts = contexts;
        if (contexts != null && contexts.get("javascript") instanceof JSExpressionContext && (provider = ((JSExpressionContext)contexts.get("javascript")).getExpressionProvider()) instanceof IExpressionFilterSupport) {
            this.filters = ((IExpressionFilterSupport)((Object)provider)).getFilters();
        }
    }

    @Override
    public IExpressionContext getContext(String expressionType, Object contextObj) {
        IExpressionContext cxt;
        IExpressionContextFactory factory = (IExpressionContextFactory)ElementAdapterManager.getAdapter(this, IExpressionContextFactory.class);
        if (factory != null && (cxt = factory.getContext(expressionType, contextObj)) != null) {
            if (cxt instanceof IExpressionFilterSupport) {
                ((IExpressionFilterSupport)((Object)cxt)).setFilters(this.filters);
            }
            return cxt;
        }
        cxt = this.contexts.get(expressionType);
        if (cxt == null) {
            DefaultExpressionContext defaultCxt = new DefaultExpressionContext(contextObj);
            defaultCxt.setFilters(this.filters);
            defaultCxt.putExtra("ExpressionProvider", this.provider);
            for (String key : this.extras.keySet()) {
                defaultCxt.putExtra(key, this.extras.get(key));
            }
            return defaultCxt;
        }
        return cxt;
    }
}

