/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventFilter;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;

public abstract class AbstractModelEventProcessor
implements IModelEventProcessor {
    private List<IModelEventInfo> infoList = new ArrayList<IModelEventInfo>();
    private IModelEventFactory factory;
    private IModelEventFilter filter;
    private IModelEventInfoFactory eventInfoFactory = this.createModelEventInfoFactory();

    public AbstractModelEventProcessor(IModelEventFactory factory) {
        this.factory = factory;
    }

    public IModelEventFactory getFactory() {
        return this.factory;
    }

    public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
        boolean isAccept = false;
        ArrayList<IModelEventInfo> temp = new ArrayList<IModelEventInfo>(this.infoList);
        int size = temp.size();
        IModelEventInfo newInfo = this.eventInfoFactory.createModelEventInfo(focus, ev);
        int i = 0;
        while (i < size) {
            IModelEventInfo info = (IModelEventInfo)temp.get(i);
            if (info.canAcceptModelEvent(newInfo)) {
                info.addModelEvent(newInfo);
                isAccept = true;
                break;
            }
            if (newInfo.canAcceptModelEvent(info)) {
                newInfo.addModelEvent(info);
                this.infoList.remove(info);
            }
            ++i;
        }
        if (!isAccept) {
            this.infoList.add(newInfo);
        }
    }

    public void clear() {
        this.infoList.clear();
    }

    public void postElementEvent() {
        int size = this.infoList.size();
        int i = 0;
        while (i < size) {
            IModelEventInfo info = this.infoList.get(i);
            Runnable run = this.factory.createModelEventRunnable(info.getTarget(), info.getType(), info.getOtherInfo());
            if (run != null) {
                run.run();
            }
            ++i;
        }
        this.infoList.clear();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IModelEventFilter.class) {
            if (this.filter == null) {
                this.filter = new IModelEventFilter(){

                    public boolean filterModelEvent(DesignElementHandle focus, NotificationEvent ev) {
                        return !AbstractModelEventProcessor.this.includeEventType(ev.getEventType());
                    }
                };
            }
            return this.filter;
        }
        return null;
    }

    protected boolean includeEventType(int type) {
        return true;
    }

    protected abstract IModelEventInfoFactory createModelEventInfoFactory();

    public static interface IModelEventFactory {
        public Runnable createModelEventRunnable(Object var1, int var2, Map var3);

        public boolean isDispose();
    }

    public static interface IModelEventInfo {
        public int getType();

        public DesignElementHandle getTarget();

        public Map getOtherInfo();

        public boolean canAcceptModelEvent(IModelEventInfo var1);

        public void addModelEvent(IModelEventInfo var1);
    }

    public static interface IModelEventInfoFactory {
        public IModelEventInfo createModelEventInfo(DesignElementHandle var1, NotificationEvent var2);
    }

    protected static class ModelEventInfo
    implements IModelEventInfo {
        private DesignElementHandle target;
        private int type;
        private Map otherInfo = new HashMap();

        public ModelEventInfo(DesignElementHandle focus, NotificationEvent ev) {
            this.setTarget(focus);
            this.setType(ev.getEventType());
        }

        public boolean canAcceptModelEvent(IModelEventInfo info) {
            return this.getTarget().equals(info.getTarget()) && info.getType() == this.getType();
        }

        public void addModelEvent(IModelEventInfo info) {
        }

        public DesignElementHandle getTarget() {
            return this.target;
        }

        public void setTarget(DesignElementHandle target) {
            this.target = target;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public Map getOtherInfo() {
            return this.otherInfo;
        }
    }
}

