/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Display;

public class SelectionBorder
extends AbstractBorder {
    private static boolean ENABLE_ANIMATION = false;
    private static boolean ENABLE_GRADIENT = false;
    private static final int DELAY = 100;
    private int offsetX = 0;
    private int offsetY = 0;
    private int lineWidth;
    private boolean painting = true;

    public SelectionBorder() {
        this(1);
    }

    public SelectionBorder(int lineWidth) {
        this.lineWidth = lineWidth < 1 ? 1 : lineWidth;
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(this.lineWidth, this.lineWidth, this.lineWidth, this.lineWidth);
    }

    private void setGradientColor(Graphics g, boolean direction) {
        if (direction) {
            g.setForegroundColor(ReportColorConstants.ReportBackground);
            g.setBackgroundColor(ReportColorConstants.SelctionFillColor);
        } else {
            g.setForegroundColor(ReportColorConstants.SelctionFillColor);
            g.setBackgroundColor(ReportColorConstants.ReportBackground);
        }
    }

    private void paintRegular(IFigure figure, Graphics graphics, Insets insets) {
        Rectangle bounds = figure.getBounds().getCopy();
        graphics.translate(bounds.getLocation());
        graphics.setBackgroundColor(ReportColorConstants.SelctionFillColor);
        graphics.fillRectangle(0, 0, bounds.width, this.lineWidth);
        graphics.fillRectangle(bounds.width - this.lineWidth, 0, this.lineWidth, bounds.height);
        graphics.fillRectangle(0, bounds.height - this.lineWidth, bounds.width, this.lineWidth);
        graphics.fillRectangle(0, 0, this.lineWidth, bounds.height);
        graphics.translate(bounds.getLocation().getNegated());
    }

    private void paintGradient(IFigure figure, Graphics graphics, Insets insets) {
        Rectangle bounds = figure.getBounds().getCopy();
        graphics.translate(bounds.getLocation());
        int halfW = bounds.width / 2 + 1;
        this.setGradientColor(graphics, false);
        graphics.fillGradient(0, 0, halfW, this.lineWidth, false);
        graphics.fillGradient(bounds.width, 0, -halfW, this.lineWidth, false);
        graphics.fillGradient(0, bounds.height - this.lineWidth, halfW, this.lineWidth, false);
        graphics.fillGradient(bounds.width, bounds.height - this.lineWidth, -halfW, this.lineWidth, false);
        int halfH = bounds.height / 2 + 1;
        graphics.fillGradient(0, 0, this.lineWidth, halfH, true);
        graphics.fillGradient(0, bounds.height, this.lineWidth, -halfH, true);
        graphics.fillGradient(bounds.width - this.lineWidth, 0, this.lineWidth, halfH, true);
        graphics.fillGradient(bounds.width - this.lineWidth, bounds.height, this.lineWidth, -halfH, true);
        graphics.translate(bounds.getLocation().getNegated());
    }

    private void paintAnimated(IFigure figure, Graphics graphics, Insets insets) {
        Rectangle bounds = figure.getBounds().getCopy();
        graphics.translate(bounds.getLocation());
        int halfW = bounds.width / 2 + 1;
        if (halfW < 32) {
            this.setGradientColor(graphics, false);
            graphics.fillGradient(0, 0, halfW, this.lineWidth, false);
            graphics.fillGradient(bounds.width, 0, -halfW, this.lineWidth, false);
            graphics.fillGradient(0, bounds.height - this.lineWidth, halfW, this.lineWidth, false);
            graphics.fillGradient(bounds.width, bounds.height - this.lineWidth, -halfW, this.lineWidth, false);
        } else {
            int x1;
            boolean changed = false;
            if (this.offsetX < halfW) {
                x1 = this.offsetX;
            } else {
                x1 = this.offsetX - halfW;
                changed = true;
            }
            this.setGradientColor(graphics, !changed);
            graphics.fillGradient(x1 - halfW, 0, halfW + 1, this.lineWidth, false);
            this.setGradientColor(graphics, changed);
            graphics.fillGradient(x1, 0, halfW + 1, this.lineWidth, false);
            this.setGradientColor(graphics, !changed);
            graphics.fillGradient(x1 + halfW, 0, halfW, this.lineWidth, false);
            this.setGradientColor(graphics, changed);
            graphics.fillGradient(bounds.width - x1, bounds.height - this.lineWidth, halfW, this.lineWidth, false);
            this.setGradientColor(graphics, !changed);
            graphics.fillGradient(bounds.width - x1 - halfW, bounds.height - this.lineWidth, halfW + 1, this.lineWidth, false);
            this.setGradientColor(graphics, changed);
            graphics.fillGradient(bounds.width - x1 - 2 * halfW, bounds.height - this.lineWidth, halfW + 1, this.lineWidth, false);
        }
        int halfH = bounds.height / 2 + 1;
        if (halfH < 32) {
            this.setGradientColor(graphics, false);
            graphics.fillGradient(0, 0, this.lineWidth, halfH, true);
            graphics.fillGradient(0, bounds.height, this.lineWidth, -halfH, true);
            graphics.fillGradient(bounds.width - this.lineWidth, 0, this.lineWidth, halfH, true);
            graphics.fillGradient(bounds.width - this.lineWidth, bounds.height, this.lineWidth, -halfH, true);
        } else {
            int y1;
            boolean changed = false;
            if (this.offsetY < halfH) {
                y1 = this.offsetY;
            } else {
                y1 = this.offsetY - halfH;
                changed = true;
            }
            this.setGradientColor(graphics, !changed);
            graphics.fillGradient(bounds.width - this.lineWidth, y1 - halfH, this.lineWidth, halfH + 1, true);
            this.setGradientColor(graphics, changed);
            graphics.fillGradient(bounds.width - this.lineWidth, y1, this.lineWidth, halfH + 1, true);
            this.setGradientColor(graphics, !changed);
            graphics.fillGradient(bounds.width - this.lineWidth, y1 + halfH, this.lineWidth, halfH, true);
            this.setGradientColor(graphics, changed);
            graphics.fillGradient(0, bounds.height - y1, this.lineWidth, halfH, true);
            this.setGradientColor(graphics, !changed);
            graphics.fillGradient(0, bounds.height - y1 - halfH, this.lineWidth, halfH + 1, true);
            this.setGradientColor(graphics, changed);
            graphics.fillGradient(0, bounds.height - y1 - 2 * halfH, this.lineWidth, halfH + 1, true);
        }
        graphics.translate(bounds.getLocation().getNegated());
    }

    public void paint(final IFigure figure, Graphics graphics, Insets insets) {
        if (ENABLE_ANIMATION) {
            this.paintAnimated(figure, graphics, insets);
            if (this.painting) {
                Display.getCurrent().timerExec(100, new Runnable(){

                    public void run() {
                        SelectionBorder selectionBorder = SelectionBorder.this;
                        selectionBorder.offsetX = selectionBorder.offsetX + 8;
                        SelectionBorder selectionBorder2 = SelectionBorder.this;
                        selectionBorder2.offsetY = selectionBorder2.offsetY + 8;
                        if (SelectionBorder.this.offsetX > figure.getBounds().width) {
                            SelectionBorder.this.offsetX = 0;
                        }
                        if (SelectionBorder.this.offsetY > figure.getBounds().height) {
                            SelectionBorder.this.offsetY = 0;
                        }
                        SelectionBorder.this.painting = true;
                        figure.repaint();
                    }
                });
            }
            this.painting = false;
        } else if (ENABLE_GRADIENT) {
            this.paintGradient(figure, graphics, insets);
        } else {
            this.paintRegular(figure, graphics, insets);
        }
    }

    public static void enableGradient(boolean value) {
        ENABLE_GRADIENT = value;
    }

    public static void enableAnimation(boolean value) {
        ENABLE_ANIMATION = value;
    }
}

