/*
 * Decompiled with CFR 0.152.
 */
package org.dma.xml.beans;

import java.io.File;
import java.math.BigDecimal;
import java.util.Calendar;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlOptions;
import org.dma.java.io.CustomFile;
import org.dma.java.io.FileParameters;
import org.dma.java.util.TimeDateUtils;
import org.dma.xml.IXMLExport;
import stockFilePT201.ProductCategoryDocument;
import stockFilePT201.StockDocument;
import stockFilePT201.StockFileDocument;
import stockFilePT201.StockHeaderDocument;

public class Stocks201Export
implements IXMLExport {
    public static final String VERSAO = "2_01";
    public static final String NIF = "999999990";
    private final StockFileDocument stockFileDocument = StockFileDocument.Factory.newInstance();
    private final StockFileDocument.StockFile stockFile = this.stockFileDocument.addNewStockFile();
    private final StockHeaderDocument.StockHeader header = this.stockFile.addNewStockHeader();
    private final Calendar endDate;

    public Stocks201Export(Calendar endDate) {
        this.endDate = endDate;
    }

    public FileParameters getFileParameters(File folder) {
        String prefix = "999999990_STOCKS_" + TimeDateUtils.getDateFormatted((Calendar)this.endDate, (String)"yyyy-MM-dd");
        return new FileParameters(prefix, "xml", folder);
    }

    @Override
    public boolean save(File file) {
        if (!file.isDirectory()) {
            try {
                XmlOptions options = new XmlOptions();
                options.setSavePrettyPrint();
                options.setUseDefaultNamespace();
                options.setCharacterEncoding(CustomFile.UTF8_CHARSET.name());
                this.stockFileDocument.save(file, options);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return this.save((File)this.getFileParameters(file).toFile());
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.stockFile.getStockList().isEmpty();
    }

    @Override
    public boolean isValid() {
        return this.stockFile.validate();
    }

    public void process() {
        XmlCursor cursor = this.stockFile.newCursor();
        cursor.toFirstContentToken();
        cursor.insertNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        cursor.dispose();
        this.createHeader();
        this.createStock();
    }

    private void createHeader() {
        this.header.setFileVersion(VERSAO);
        this.header.setTaxRegistrationNumber(Integer.valueOf(NIF));
        this.header.setFiscalYear(TimeDateUtils.getYear((Calendar)this.endDate));
        this.header.setEndDate(TimeDateUtils.getCalendarWithoutTimezone((Calendar)this.endDate));
        this.header.setNoStock(false);
    }

    private void createStock() {
        StockDocument.Stock stock = this.stockFile.addNewStock();
        stock.setProductCategory(ProductCategoryDocument.ProductCategory.M);
        stock.setProductCode("Desconhecido");
        stock.setProductDescription("Desconhecido");
        stock.setProductNumberCode("0");
        stock.setUnitOfMeasure("UN");
        stock.setClosingStockQuantity(BigDecimal.ONE);
        stock.setClosingStockValue(BigDecimal.ONE);
    }
}

