/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartInsets;
import org.eclipse.birt.chart.ui.swt.ChartSpinner;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierPreview;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LegendTextSheet
extends AbstractPopupSheet
implements Listener {
    protected transient Composite cmpContent = null;
    private transient FontDefinitionComposite fdcFont = null;
    private transient LineAttributesComposite lineSeparator;
    private transient FillChooserComposite fccBackground;
    private transient FillChooserComposite fccShadow;
    private transient LineAttributesComposite outlineText;
    private transient AbstractChartInsets icText;
    protected transient FormatSpecifierPreview fsp;
    protected transient Button btnFormatSpecifier;
    private ChartSpinner spnEllipsis;
    private boolean isByCategory = this.getChart().getLegend().getItemType() != LegendItemType.SERIES_LITERAL;
    private boolean containsYOG = ChartUtil.containsYOptionalGrouping((Chart)this.getChart());

    public LegendTextSheet(String title, ChartWizardContext context) {
        super(title, context, true);
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.LegendBlock_ID");
        this.cmpContent = new Composite(parent, 0);
        GridLayout glMain = new GridLayout();
        glMain.horizontalSpacing = 5;
        glMain.verticalSpacing = 5;
        glMain.marginHeight = 7;
        glMain.marginWidth = 7;
        this.cmpContent.setLayout((Layout)glMain);
        Group grpTxtArea = new Group(this.cmpContent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        grpTxtArea.setLayout((Layout)layout);
        grpTxtArea.setLayoutData((Object)new GridData(1808));
        grpTxtArea.setText(Messages.getString("MoreOptionsChartLegendSheet.Label.TextArea"));
        Label lblFormat = new Label((Composite)grpTxtArea, 0);
        lblFormat.setText(Messages.getString("DialLabelSheet.Label.Format"));
        Composite cmpFormat = new Composite((Composite)grpTxtArea, 2048);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 0;
        cmpFormat.setLayout((Layout)layout2);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        cmpFormat.setLayoutData((Object)gd);
        cmpFormat.setBackground(cmpFormat.getDisplay().getSystemColor(1));
        this.fsp = new FormatSpecifierPreview(cmpFormat, 0, false);
        GridData gd2 = new GridData();
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalAlignment = 0x1000000;
        this.fsp.setLayoutData(gd2);
        this.fsp.updatePreview(this.getChart().getLegend().getFormatSpecifier());
        this.btnFormatSpecifier = new Button(cmpFormat, 8);
        gd2 = new GridData();
        this.btnFormatSpecifier.setLayoutData((Object)gd2);
        this.btnFormatSpecifier.setToolTipText(Messages.getString("BaseDataDefinitionComponent.Text.EditFormat"));
        this.btnFormatSpecifier.setText(Messages.getString("Format.Button.Lbl&"));
        this.btnFormatSpecifier.addListener(13, (Listener)this);
        new Label((Composite)grpTxtArea, 0).setText(Messages.getString("LegendTextSheet.Label.Font"));
        this.fdcFont = new FontDefinitionComposite((Composite)grpTxtArea, 0, this.getContext(), this.getLegend().getText().getFont(), this.getLegend().getText().getColor(), false);
        GridData gdFDCFont = new GridData(768);
        gdFDCFont.widthHint = this.fdcFont.getPreferredSize().x;
        gdFDCFont.grabExcessVerticalSpace = false;
        gdFDCFont.horizontalSpan = 2;
        this.fdcFont.setLayoutData(gdFDCFont);
        this.fdcFont.addListener(this);
        new Label((Composite)grpTxtArea, 0).setText(Messages.getString("LegendTextSheet.Label.Ellipsis"));
        this.spnEllipsis = this.getContext().getUIFactory().createChartSpinner((Composite)grpTxtArea, 2048, (EObject)this.getLegend(), "ellipsis", true);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.spnEllipsis.setLayoutData((Object)gd);
        this.spnEllipsis.getWidget().setMinimum(0);
        this.spnEllipsis.getWidget().setSelection(this.getLegend().getEllipsis());
        this.spnEllipsis.setToolTipText(Messages.getString("LegendTextSheet.Tooltip.Ellipsis"));
        Label lblShadow = new Label((Composite)grpTxtArea, 0);
        GridData gdLBLShadow = new GridData();
        lblShadow.setLayoutData((Object)gdLBLShadow);
        lblShadow.setText(Messages.getString("ClientAreaAttributeComposite.Lbl.Shadow"));
        int fillStyles = 152;
        this.fccShadow = new FillChooserComposite((Composite)grpTxtArea, 0, fillStyles |= this.getContext().getUIFactory().supportAutoUI() ? 4 : fillStyles, this.getContext(), (Fill)this.getLegend().getClientArea().getShadowColor());
        GridData gdFCCShadow = new GridData(768);
        gdFCCShadow.horizontalSpan = 2;
        this.fccShadow.setLayoutData(gdFCCShadow);
        this.fccShadow.addListener(this);
        Label lblBackground = new Label((Composite)grpTxtArea, 0);
        lblBackground.setText(Messages.getString("Shared.mne.Background_K"));
        fillStyles = 27;
        this.fccBackground = new FillChooserComposite((Composite)grpTxtArea, 12, fillStyles |= this.getContext().getUIFactory().supportAutoUI() ? 4 : fillStyles, this.getContext(), this.getChart().getLegend().getClientArea().getBackground());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fccBackground.setLayoutData(gridData);
        this.fccBackground.addListener(this);
        Group grpOutline = new Group((Composite)grpTxtArea, 0);
        GridData gdGRPOutline = new GridData(768);
        gdGRPOutline.horizontalSpan = 3;
        grpOutline.setLayoutData((Object)gdGRPOutline);
        grpOutline.setLayout((Layout)new FillLayout());
        grpOutline.setText(Messages.getString("MoreOptionsChartLegendSheet.Label.Outline"));
        Legend defLegend = ChartDefaultValueUtil.getDefaultLegend((Chart)this.getChart());
        int lineStyles = 15;
        this.outlineText = new LineAttributesComposite((Composite)grpOutline, 0, lineStyles |= this.getContext().getUIFactory().supportAutoUI() ? 16 : lineStyles, this.getContext(), this.getLegend().getClientArea().getOutline(), defLegend.getClientArea().getOutline());
        this.outlineText.addListener(this);
        this.outlineText.setAttributesEnabled(true);
        this.icText = this.getContext().getUIFactory().createChartInsetsComposite((Composite)grpTxtArea, 0, 2, this.getLegend().getClientArea().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider(), this.getContext(), ChartDefaultValueUtil.getDefaultLegend((Chart)this.getChart()).getClientArea().getInsets());
        GridData gdInsets = new GridData(768);
        gdInsets.horizontalSpan = 3;
        this.icText.setLayoutData((Object)gdInsets);
        Group grpSeparator = new Group(this.cmpContent, 0);
        GridLayout layout3 = new GridLayout();
        layout3.marginHeight = 0;
        layout3.marginWidth = 5;
        grpSeparator.setLayout((Layout)layout3);
        grpSeparator.setLayoutData((Object)new GridData(768));
        grpSeparator.setText(Messages.getString("LegendTextSheet.Label.Separator"));
        this.lineSeparator = new LineAttributesComposite((Composite)grpSeparator, 0, lineStyles, this.getContext(), this.getLegend().getSeparator(), defLegend.getSeparator());
        this.lineSeparator.setLayoutData(new GridData(768));
        this.lineSeparator.addListener(this);
        this.lineSeparator.setAttributesEnabled(true);
        return this.cmpContent;
    }

    public void handleEvent(Event event) {
        boolean isUnset;
        boolean bl = isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
        if (event.widget.equals((Object)this.fdcFont)) {
            this.getLegend().getText().setFont((FontDefinition)((Object[])event.data)[0]);
            this.getLegend().getText().setColor((ColorDefinition)((Object[])event.data)[1]);
        } else if (event.widget.equals((Object)this.fccShadow)) {
            this.getLegend().getClientArea().setShadowColor((ColorDefinition)event.data);
        } else if (event.widget.equals((Object)this.fccBackground)) {
            this.getLegend().getClientArea().setBackground((Fill)event.data);
        } else if (event.widget.equals(this.icText)) {
            this.getLegend().getClientArea().setInsets((Insets)event.data);
        } else if (event.widget.equals((Object)this.outlineText)) {
            switch (event.type) {
                case 1: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getLegend().getClientArea().getOutline(), (String)"style", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 2: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getLegend().getClientArea().getOutline(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
                    break;
                }
                case 3: {
                    this.getLegend().getClientArea().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getLegend().getClientArea().getOutline(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                }
            }
        } else if (event.widget.equals((Object)this.lineSeparator)) {
            switch (event.type) {
                case 1: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getLegend().getSeparator(), (String)"style", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 2: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getLegend().getSeparator(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
                    break;
                }
                case 3: {
                    this.getLegend().getSeparator().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getLegend().getSeparator(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                }
            }
        } else if (event.widget.equals(this.btnFormatSpecifier)) {
            this.handleFormatBtnSelected();
        }
    }

    protected void handleFormatBtnSelected() {
        FormatSpecifier fs = this.getContext().getUIServiceProvider().getFormatSpecifierHandler().handleFormatSpecifier(this.cmpContent.getShell(), Messages.getString("BaseDataDefinitionComponent.Text.EditFormat"), new AxisType[]{this.getEntryType()}, this.getChart().getLegend().getFormatSpecifier(), (EObject)this.getChart().getLegend(), "formatSpecifier", this.getContext());
        this.fsp.updatePreview(fs);
    }

    private Legend getLegend() {
        return this.getChart().getLegend();
    }

    protected AxisType getEntryType() {
        DataType type = DataType.TEXT_LITERAL;
        if (this.isByCategory) {
            type = this.getCategoryQueryType();
        } else if (this.containsYOG) {
            type = this.getContext().getDataServiceProvider().getDataType(ChartUtil.getYOptoinalExpressions((Chart)this.getChart())[0]);
        }
        if (type == DataType.NUMERIC_LITERAL) {
            return AxisType.LINEAR_LITERAL;
        }
        if (type == DataType.DATE_TIME_LITERAL) {
            return AxisType.DATE_TIME_LITERAL;
        }
        return AxisType.TEXT_LITERAL;
    }

    private DataType getCategoryQueryType() {
        String query = ChartUIUtil.getDataQuery((SeriesDefinition)((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.getChart()).get(0)), (int)0).getDefinition();
        return this.getContext().getDataServiceProvider().getDataType(query);
    }
}

