/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.chart;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.LegendBehaviorType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.LegendLayoutSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.LegendTextSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.LegendTitleSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ChartLegendSheetImpl
extends SubtaskSheetImpl
implements Listener,
SelectionListener {
    protected ChartCheckbox btnVisible;
    protected ExternalizedTextEditorComposite txtTitle;
    protected ChartCheckbox btnTitleVisible;
    protected ChartCheckbox btnShowValue;
    protected org.eclipse.swt.widgets.Label lblTitle;
    protected org.eclipse.swt.widgets.Label lblShowValue;
    protected org.eclipse.swt.widgets.Label lblLegendBehavior;
    protected ChartCombo cmbLegendBehavior;

    public void createControl(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartLegend_ID");
        this.init();
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(2, false);
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Group cmpBasic = new Group(this.cmpContent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        cmpBasic.setLayout((Layout)layout);
        GridData gd2 = new GridData(768);
        cmpBasic.setLayoutData((Object)gd2);
        cmpBasic.setText(Messages.getString("ChartLegendSheetImpl.Label.Legend"));
        Legend defLegend = ChartDefaultValueUtil.getDefaultValueChart((Chart)this.getChart()).getLegend();
        this.btnVisible = this.getContext().getUIFactory().createChartCheckbox((Composite)cmpBasic, 0, defLegend.isVisible());
        GridData gdBTNVisible = new GridData();
        gdBTNVisible.horizontalSpan = 4;
        this.btnVisible.setLayoutData((Object)gdBTNVisible);
        this.btnVisible.setText(Messages.getString("Shared.mne.Visibile_v"));
        this.createTitleComposite(cmpBasic, defLegend);
        this.lblLegendBehavior = new org.eclipse.swt.widgets.Label((Composite)cmpBasic, 0);
        this.lblLegendBehavior.setText(Messages.getString("ChartLegendSheetImpl.Label.LegendBehaviorType"));
        this.cmbLegendBehavior = this.getContext().getUIFactory().createChartCombo((Composite)cmpBasic, 12, (EObject)this.getChart().getInteractivity(), "legendBehavior", ChartDefaultValueUtil.getDefaultValueChart((Chart)this.getChart()).getInteractivity().getLegendBehavior().getName());
        GridData gridData = new GridData();
        gridData.widthHint = 180;
        gridData.horizontalSpan = 2;
        this.cmbLegendBehavior.setLayoutData((Object)gridData);
        this.cmbLegendBehavior.addSelectionListener((SelectionListener)this);
        this.cmbLegendBehavior.setEnabled(this.getChart().getInteractivity().isEnable());
        new org.eclipse.swt.widgets.Label((Composite)cmpBasic, 0);
        if (this.isShowValueEnabled()) {
            this.lblShowValue = new org.eclipse.swt.widgets.Label((Composite)cmpBasic, 0);
            this.lblShowValue.setText(Messages.getString("ChartLegendSheetImpl.Label.Value"));
            this.btnShowValue = this.getContext().getUIFactory().createChartCheckbox((Composite)cmpBasic, 0, defLegend.isShowValue());
            gdBTNVisible = new GridData();
            gdBTNVisible.horizontalSpan = 2;
            this.btnShowValue.setLayoutData((Object)gdBTNVisible);
            this.btnShowValue.setText(Messages.getString("ChartLegendSheetImpl.Label.ShowValue"));
            this.btnShowValue.setToolTipText(Messages.getString("ChartLegendSheetImpl.Tooltip.ShowDataPointValue"));
        }
        this.populateLists();
        this.initDataNListeners();
        this.createButtonGroup(this.cmpContent);
        this.setState(!this.getContext().getUIFactory().isSetInvisible((EObject)this.getChart().getLegend()));
    }

    protected void createTitleComposite(Group cmpBasic, Legend defLegend) {
        this.lblTitle = new org.eclipse.swt.widgets.Label((Composite)cmpBasic, 0);
        this.lblTitle.setText(Messages.getString("ChartLegendSheetImpl.Label.Title"));
        List keys = null;
        if (this.getContext().getUIServiceProvider() != null) {
            keys = this.getContext().getUIServiceProvider().getRegisteredKeys();
        }
        this.txtTitle = new ExternalizedTextEditorComposite((Composite)cmpBasic, 2048, -1, -1, keys, this.getContext().getUIServiceProvider(), this.getLegendTitle());
        GridData gd = new GridData();
        gd.widthHint = 180;
        this.txtTitle.setLayoutData(gd);
        this.txtTitle.addListener(this);
        this.btnTitleVisible = this.getContext().getUIFactory().createChartCheckbox((Composite)cmpBasic, 0, defLegend.getTitle().isVisible());
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.btnTitleVisible.setLayoutData((Object)gd);
        this.btnTitleVisible.setText(Messages.getString("Shared.mne.Visibile_s"));
    }

    protected void initDataNListeners() {
        Legend l = this.getChart().getLegend();
        int state = l.isSetVisible() ? (l.isVisible() ? 1 : 2) : 0;
        this.btnVisible.setSelectionState(state);
        this.btnVisible.addSelectionListener((SelectionListener)this);
        state = l.getTitle().isSetVisible() ? (l.getTitle().isVisible() ? 1 : 2) : 0;
        this.btnTitleVisible.setSelectionState(state);
        this.btnTitleVisible.addSelectionListener((SelectionListener)this);
        if (this.isShowValueEnabled()) {
            state = l.isSetShowValue() ? (l.isShowValue() ? 1 : 2) : 0;
            this.btnShowValue.addSelectionListener((SelectionListener)this);
            this.btnShowValue.setSelectionState(state);
        }
    }

    protected void populateLists() {
        NameSet nameSet = LiteralHelper.legendBehaviorTypeSet;
        if (this.isBehaviorSupported()) {
            this.cmbLegendBehavior.setItems(nameSet.getDisplayNames());
            this.cmbLegendBehavior.setItemData(nameSet.getNames());
            this.cmbLegendBehavior.setSelection(this.getChart().getInteractivity().getLegendBehavior().getName());
        } else {
            this.cmbLegendBehavior.setItems(new String[]{nameSet.getDisplayNames()[0]});
            this.cmbLegendBehavior.setItemData(new String[]{nameSet.getNames()[0]});
            this.cmbLegendBehavior.setSelection(this.getChart().getInteractivity().getLegendBehavior().getName());
        }
    }

    protected boolean isBehaviorSupported() {
        return "SVG".equalsIgnoreCase(this.getContext().getOutputFormat());
    }

    protected void setState(boolean enabled) {
        this.lblTitle.setEnabled(enabled);
        this.txtTitle.setEnabled(enabled && this.btnTitleVisible.getSelectionState() != 2);
        this.btnTitleVisible.setEnabled(enabled);
        if (this.isShowValueEnabled()) {
            this.lblShowValue.setEnabled(enabled);
            this.btnShowValue.setEnabled(enabled);
        }
        for (Button toggle : this.getToggleButtons()) {
            toggle.setEnabled(enabled && this.getContext().isEnabled("Chart.Legend" + toggle.getData()));
        }
        this.setToggleButtonEnabled(".Title", this.btnTitleVisible.getSelectionState() != 2 && enabled);
        this.setToggleButtonEnabled(".Interactivity", this.getChart().getInteractivity().isEnable() && enabled);
    }

    protected boolean isShowValueEnabled() {
        return this.getChart().getLegend().getItemType() == LegendItemType.SERIES_LITERAL;
    }

    private void init() {
        if (this.getChart().getLegend().getTitle() == null) {
            Label label = LabelImpl.createDefault();
            label.eAdapters().addAll((Collection)this.getChart().getLegend().eAdapters());
            this.getChart().getLegend().setTitle(label);
        }
    }

    protected void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(5, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        AbstractPopupSheet popup = new LegendTitleSheet(Messages.getString("ChartLegendSheetImpl.Title.LegendTitle"), this.getContext());
        Button btnLegendTitle = this.createToggleButton(cmp, ".Title", Messages.getString("ChartLegendSheetImpl.Label.LegendTitle&"), popup, this.getTitleVisibleSelection());
        btnLegendTitle.addSelectionListener((SelectionListener)this);
        popup = new LegendLayoutSheet(Messages.getString("ChartLegendSheetImpl.Title.LegendLayout"), this.getContext());
        Button btnAreaProp = this.createToggleButton(cmp, ".Layout", Messages.getString("ChartLegendSheetImpl.Label.Layout"), popup);
        btnAreaProp.addSelectionListener((SelectionListener)this);
        this.createLegendEntriesUI(cmp);
        if (this.getContext().isInteractivityEnabled()) {
            popup = new InteractivitySheet(Messages.getString("ChartLegendSheetImpl.Label.Interactivity"), this.getContext(), (EList<Trigger>)this.getChart().getLegend().getTriggers(), (EObject)this.getChart().getLegend(), 16, 23);
            Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup, this.getChart().getInteractivity().isEnable());
            btnInteractivity.addSelectionListener((SelectionListener)this);
        }
    }

    protected void createLegendEntriesUI(Composite cmp) {
        LegendTextSheet popup = new LegendTextSheet(Messages.getString("ChartLegendSheetImpl.Title.LegendEntries"), this.getContext());
        Button btnLegendText = this.createToggleButton(cmp, ".Entries", Messages.getString("ChartLegendSheetImpl.Label.Entries"), popup);
        btnLegendText.addSelectionListener((SelectionListener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.txtTitle)) {
            this.getChart().getLegend().getTitle().getCaption().setValue(this.txtTitle.getText());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.btnVisible)) {
            boolean enabled;
            ChartElementUtil.setEObjectAttribute((EObject)this.getChart().getLegend(), (String)"visible", (Object)(this.btnVisible.getSelectionState() == 1 ? 1 : 0), (this.btnVisible.getSelectionState() == 0 ? 1 : 0) != 0);
            boolean bl = enabled = this.btnVisible.getSelectionState() != 2;
            if (!enabled && this.isButtonSelected()) {
                this.detachPopup();
            }
            this.setState(enabled);
        } else if (e.widget.equals(this.btnTitleVisible)) {
            this.setToggleButtonEnabled(".Title", this.getTitleVisibleSelection());
            int state = this.btnTitleVisible.getSelectionState();
            boolean enabled = state != 2;
            ChartElementUtil.setEObjectAttribute((EObject)this.getChart().getLegend().getTitle(), (String)"visible", (Object)(state == 1 ? 1 : 0), (state == 0 ? 1 : 0) != 0);
            this.txtTitle.setEnabled(enabled);
            Button btnLegendTitle = this.getToggleButton(".Title");
            if (!this.getTitleVisibleSelection() && btnLegendTitle.getSelection()) {
                btnLegendTitle.setSelection(false);
                this.detachPopup();
            } else {
                this.refreshPopupSheet();
            }
        } else if (e.widget.equals(this.cmbLegendBehavior)) {
            String selectedLg = this.cmbLegendBehavior.getSelectedItemData();
            if (selectedLg != null) {
                this.getChart().getInteractivity().setLegendBehavior(LegendBehaviorType.getByName((String)selectedLg));
            }
        } else if (e.widget.equals(this.btnShowValue)) {
            int state = this.btnShowValue.getSelectionState();
            ChartElementUtil.setEObjectAttribute((EObject)this.getChart().getLegend(), (String)"showValue", (Object)(state == 1 ? 1 : 0), (state == 0 ? 1 : 0) != 0);
        }
    }

    protected String getLegendTitle() {
        String value = this.getChart().getLegend().getTitle().getCaption().getValue();
        if (value == null) {
            return "";
        }
        return value;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected boolean getTitleVisibleSelection() {
        return this.getContext().getUIFactory().canEnableUI(this.btnTitleVisible);
    }
}

