/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public final class PaletteEditorComposite
extends Composite
implements PaintListener,
ControlListener,
DisposeListener,
SelectionListener,
MouseListener,
Listener,
KeyListener {
    private final EList<Fill> elPaletteEntries1;
    private int iViewY = 0;
    private int iViewHeight = 0;
    private int iVisibleCount = 0;
    private int iSelectedIndex = 0;
    private static final int ITEM_HEIGHT = 30;
    private final ScrollBar sb;
    private Image imgBuffer = null;
    private GC gc = null;
    private Control coEditor = null;
    private Button btnAdd;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private FillChooserComposite fccNewEntry = null;
    private Composite coPaletteEntries = null;
    private IDeviceRenderer idrSWT = null;
    private ChartWizardContext wizardContext;
    private SeriesDefinition[] vSeriesDefns = null;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.composites");
    private final int iFillChooserStyle;

    public PaletteEditorComposite(Composite coParent, ChartWizardContext wizardContext, Palette pa1, SeriesDefinition[] vSeriesDefns, int iFillChooserStyle) {
        this(coParent, wizardContext, pa1, vSeriesDefns, iFillChooserStyle, 0);
    }

    public PaletteEditorComposite(Composite coParent, ChartWizardContext wizardContext, Palette pa1, SeriesDefinition[] vSeriesDefns, int iFillChooserStyle, int styles) {
        super(coParent, styles);
        this.wizardContext = wizardContext;
        this.vSeriesDefns = vSeriesDefns;
        this.iFillChooserStyle = iFillChooserStyle;
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.makeColumnsEqualWidth = true;
        this.setLayout((Layout)gl);
        this.coPaletteEntries = new Composite((Composite)this, 512);
        GridData gd = new GridData(1808);
        this.coPaletteEntries.setLayoutData((Object)gd);
        this.elPaletteEntries1 = pa1.getEntries();
        this.sb = this.coPaletteEntries.getVerticalBar();
        this.sb.addSelectionListener((SelectionListener)this);
        Composite coControlPanel = new Composite((Composite)this, 0);
        gd = new GridData(768);
        coControlPanel.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.numColumns = 5;
        coControlPanel.setLayout((Layout)gl);
        this.btnAdd = new Button(coControlPanel, 8);
        gd = new GridData();
        this.btnAdd.setLayoutData((Object)gd);
        this.btnAdd.setText(Messages.getString("PaletteEditorComposite.Lbl.Add"));
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.fccNewEntry = new FillChooserComposite(coControlPanel, 0, iFillChooserStyle, wizardContext, (Fill)ColorDefinitionImpl.WHITE());
        gd = new GridData(768);
        this.fccNewEntry.setLayoutData(gd);
        this.btnRemove = new Button(coControlPanel, 8);
        gd = new GridData();
        this.btnRemove.setLayoutData((Object)gd);
        this.btnRemove.setText(Messages.getString("PaletteEditorComposite.Lbl.Remove"));
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnRemove.setEnabled(this.elPaletteEntries1.size() > 1);
        this.btnUp = new Button(coControlPanel, 132);
        gd = new GridData();
        this.btnUp.setLayoutData((Object)gd);
        this.btnUp.setToolTipText(Messages.getString("PaletteEditorComposite.Lbl.Up"));
        this.btnUp.addSelectionListener((SelectionListener)this);
        this.btnUp.setEnabled(this.elPaletteEntries1.size() > 1);
        this.btnDown = new Button(coControlPanel, 1028);
        gd = new GridData();
        this.btnDown.setLayoutData((Object)gd);
        this.btnDown.setToolTipText(Messages.getString("PaletteEditorComposite.Lbl.Down"));
        this.btnDown.addSelectionListener((SelectionListener)this);
        this.btnDown.setEnabled(this.elPaletteEntries1.size() > 1);
        this.addControlListener(this);
        this.addDisposeListener(this);
        this.coPaletteEntries.addPaintListener((PaintListener)this);
        this.coPaletteEntries.addMouseListener((MouseListener)this);
        this.coPaletteEntries.addKeyListener((KeyListener)this);
        try {
            this.idrSWT = ChartEngine.instance().getRenderer("dv.SWT");
        }
        catch (ChartException pex) {
            logger.log((Exception)((Object)pex));
            return;
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PaletteEditorComposite.this.idrSWT != null) {
                    PaletteEditorComposite.this.idrSWT.dispose();
                    PaletteEditorComposite.this.idrSWT = null;
                }
            }
        });
    }

    public final void paintControl(PaintEvent pev) {
        Composite co = (Composite)pev.getSource();
        GC gcComposite = pev.gc;
        Display d = pev.display;
        Rectangle rCA = this.coPaletteEntries.getClientArea();
        if (this.coEditor == null) {
            this.coEditor = new FillChooserComposite(co, 0, this.iFillChooserStyle, this.wizardContext, null);
            this.coEditor.setBounds(3, 3, rCA.width - 6, 24);
            ((FillChooserComposite)this.coEditor).addListener(this);
        }
        if (this.imgBuffer == null) {
            this.imgBuffer = new Image((Device)d, rCA.width, rCA.height);
            this.gc = new GC((Drawable)this.imgBuffer);
            this.idrSWT.setProperty("device.output.context", (Object)this.gc);
        }
        this.gc.setBackground(this.getBackground());
        this.gc.fillRectangle(rCA);
        this.iViewHeight = rCA.height;
        int iStartIndex = this.iViewY / 30;
        if (iStartIndex < 0) {
            iStartIndex = 0;
        }
        this.iVisibleCount = this.iViewHeight / 30 + 2;
        int iAvailableItems = Math.min(this.iVisibleCount, this.elPaletteEntries1.size() - iStartIndex);
        int iY = -(this.iViewY % 30);
        this.gc.setForeground(d.getSystemColor(15));
        RectangleRenderEvent rre = (RectangleRenderEvent)((EventObjectCache)this.idrSWT).getEventObject((Object)this, RectangleRenderEvent.class);
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)0.0, (double)0.0);
        rre.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        rre.setBounds(bo);
        int i = iStartIndex;
        while (i < iStartIndex + iAvailableItems) {
            Fill fi = (Fill)this.elPaletteEntries1.get(i);
            if (!super.isEnabled() && fi instanceof ColorDefinition) {
                ((ColorDefinitionImpl)fi).setTransparency(128);
            }
            if (fi instanceof MultipleFill) {
                rre.setBackground((Fill)((MultipleFill)fi).getFills().get(0));
                bo.set(3.0, (double)(iY + 3), (double)(rCA.width - 6) / 2.0, 24.0);
                try {
                    this.idrSWT.fillRectangle(rre);
                }
                catch (ChartException rex) {
                    logger.log((Exception)((Object)rex));
                }
                bo.set((double)rCA.width / 2.0, (double)(iY + 3), (double)(rCA.width - 6) / 2.0, 24.0);
                rre.setBackground((Fill)((MultipleFill)fi).getFills().get(1));
                try {
                    this.idrSWT.fillRectangle(rre);
                }
                catch (ChartException rex) {
                    logger.log((Exception)((Object)rex));
                }
                bo.set(3.0, (double)(iY + 3), (double)(rCA.width - 6), 24.0);
                try {
                    this.idrSWT.drawRectangle(rre);
                }
                catch (ChartException rex) {
                    logger.log((Exception)((Object)rex));
                }
            } else {
                rre.setBackground(fi);
                bo.set(3.0, (double)(iY + 3), (double)(rCA.width - 6), 24.0);
                try {
                    if (!super.isEnabled()) {
                        rre.getLineAttributes().getColor().set(171, 173, 179);
                    }
                    this.idrSWT.fillRectangle(rre);
                    this.idrSWT.drawRectangle(rre);
                    if (!super.isEnabled()) {
                        rre.getLineAttributes().getColor().set(255, 255, 255);
                        Insets ins = GObjectFactory.instance().createInsets(1.0, 1.0, 1.0, 1.0);
                        rre.getBounds().adjust(ins);
                        this.idrSWT.drawRectangle(rre);
                    }
                }
                catch (ChartException rex) {
                    logger.log((Exception)((Object)rex));
                }
            }
            if (i == this.iSelectedIndex && super.isEnabled()) {
                if (!this.coEditor.isVisible()) {
                    this.coEditor.setVisible(true);
                }
                this.coEditor.setLocation(3, iY + 3);
                ((FillChooserComposite)this.coEditor).setFill(fi);
            }
            iY += 30;
            ++i;
        }
        if ((this.iSelectedIndex < iStartIndex || this.iSelectedIndex >= iStartIndex + iAvailableItems || !super.isEnabled()) && this.coEditor.isVisible()) {
            this.coEditor.setVisible(false);
        }
        gcComposite.drawImage(this.imgBuffer, rCA.x, rCA.y);
    }

    private final void updateScrollBar() {
        this.sb.setPageIncrement(this.iViewHeight);
        this.sb.setMaximum(30 * this.elPaletteEntries1.size() - this.iViewHeight);
        this.sb.setSelection(this.iViewY);
    }

    private final void scrollToView(int iIndex) {
        if (iIndex == -1) {
            return;
        }
        int iStartIndex = this.iViewY / 30;
        if (iStartIndex < 0) {
            iStartIndex = 0;
        }
        if (iIndex > iStartIndex && iIndex < iStartIndex + this.iVisibleCount - 1) {
            this.iViewY = iIndex * 30 - this.iViewHeight + 30;
            if (this.iViewY < 0) {
                this.iViewY = 0;
            }
        } else if (iIndex <= iStartIndex) {
            int iMoveUpTo = iIndex - this.iVisibleCount;
            if (iMoveUpTo < 0) {
                iMoveUpTo = 0;
            }
            this.iViewY = iMoveUpTo * 30;
        } else {
            int iY = (iIndex - iStartIndex) * 30 - this.iViewY % 30;
            if (iY + 30 > this.iViewHeight) {
                this.iViewY += iY + 30 - this.iViewHeight;
            }
        }
        this.updateScrollBar();
    }

    public void controlResized(ControlEvent arg0) {
        this.updateScrollBar();
        if (this.imgBuffer != null) {
            this.gc.dispose();
            this.imgBuffer.dispose();
            this.gc = null;
            this.imgBuffer = null;
        }
        if (this.coEditor != null) {
            Rectangle rCA = this.coPaletteEntries.getClientArea();
            this.coEditor.setSize(rCA.width - 6, 24);
        }
    }

    public void widgetDisposed(DisposeEvent arg0) {
        if (this.imgBuffer != null) {
            this.gc.dispose();
            this.imgBuffer.dispose();
            this.gc = null;
            this.imgBuffer = null;
        }
    }

    public void widgetSelected(SelectionEvent sev) {
        if (sev.getSource() == this.sb) {
            int iSelection;
            this.iViewY = iSelection = this.sb.getSelection();
            this.coPaletteEntries.redraw();
        } else {
            Button btn = (Button)sev.getSource();
            if (btn == this.btnAdd) {
                if (this.fccNewEntry.getFill() != null) {
                    this.append(this.fccNewEntry.getFill().copyInstance());
                } else {
                    this.append((Fill)ColorDefinitionImpl.TRANSPARENT());
                }
            } else if (btn == this.btnRemove) {
                this.remove(this.iSelectedIndex);
            } else if ((btn.getStyle() & 0x80) == 128) {
                if (this.iSelectedIndex > 0) {
                    this.swap(this.iSelectedIndex, this.iSelectedIndex - 1);
                }
            } else if ((btn.getStyle() & 0x400) == 1024 && this.iSelectedIndex < this.elPaletteEntries1.size() - 1) {
                this.swap(this.iSelectedIndex, this.iSelectedIndex + 1);
            }
        }
    }

    public void mouseDown(MouseEvent mev) {
        int iY;
        int iClickedIndex;
        int iClickedY = mev.y;
        int iStartIndex = this.iViewY / 30;
        if (iStartIndex < 0) {
            iStartIndex = 0;
        }
        if ((iClickedIndex = iStartIndex + (iClickedY - (iY = -(this.iViewY % 30))) / 30) < 0 || iClickedIndex > this.elPaletteEntries1.size()) {
            return;
        }
        this.iSelectedIndex = iClickedIndex;
        this.coPaletteEntries.redraw();
    }

    public final int getSelectedIndex() {
        return this.iSelectedIndex;
    }

    public final ColorDefinitionImpl getSelectedFill() {
        return (ColorDefinitionImpl)this.elPaletteEntries1.get(this.iSelectedIndex);
    }

    public final void remove(int iIndex) {
        if (iIndex < 0 || iIndex >= this.elPaletteEntries1.size()) {
            return;
        }
        int size = this.elPaletteEntries1.size();
        this.elPaletteEntries1.remove(iIndex);
        if (this.vSeriesDefns != null) {
            int i = 0;
            while (i < this.vSeriesDefns.length) {
                EList el = this.vSeriesDefns[i].getSeriesPalette().getEntries();
                if (iIndex - i >= 0) {
                    el.remove(iIndex - i);
                } else {
                    int index = size - i + iIndex;
                    while (index < 0) {
                        index += size;
                    }
                    el.remove(index);
                    if (el.size() > 1) {
                        Fill o = (Fill)el.get(0);
                        el.remove(0);
                        el.add((Object)o);
                    }
                }
                ++i;
            }
        }
        if (iIndex < this.iSelectedIndex) {
            --this.iSelectedIndex;
        } else if (iIndex == this.iSelectedIndex && this.iSelectedIndex > this.elPaletteEntries1.size() - 1) {
            --this.iSelectedIndex;
        }
        if (this.elPaletteEntries1.size() <= 1) {
            this.btnRemove.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
        }
        this.scrollToView(this.iSelectedIndex);
        this.coPaletteEntries.redraw();
    }

    public final void updateSelectionFill(Fill f) {
        if (this.iSelectedIndex == -1) {
            return;
        }
        this.elPaletteEntries1.set(this.iSelectedIndex, (Object)f);
        if (this.vSeriesDefns != null) {
            int size = this.elPaletteEntries1.size();
            int i = 0;
            while (i < this.vSeriesDefns.length) {
                if (this.iSelectedIndex - i >= 0) {
                    this.vSeriesDefns[i].getSeriesPalette().getEntries().set(this.iSelectedIndex - i, (Object)f.copyInstance());
                } else {
                    int index = size - i + this.iSelectedIndex;
                    while (index < 0) {
                        index += size;
                    }
                    if (index < this.vSeriesDefns[i].getSeriesPalette().getEntries().size()) {
                        this.vSeriesDefns[i].getSeriesPalette().getEntries().set(index, (Object)f.copyInstance());
                    }
                }
                ++i;
            }
        }
        this.coPaletteEntries.redraw();
    }

    public final void append(Fill fi) {
        this.elPaletteEntries1.add((Object)fi);
        this.iSelectedIndex = this.elPaletteEntries1.size() - 1;
        if (this.vSeriesDefns != null) {
            int size = this.elPaletteEntries1.size();
            int i = 0;
            while (i < this.vSeriesDefns.length) {
                if (i < size) {
                    this.vSeriesDefns[i].getSeriesPalette().getEntries().add(size - i - 1, (Object)fi.copyInstance());
                } else {
                    EList el = this.vSeriesDefns[i - size].getSeriesPalette().getEntries();
                    int j = 0;
                    while (j < el.size()) {
                        this.vSeriesDefns[i].getSeriesPalette().getEntries().add(j, (Object)((Fill)el.get(j)).copyInstance());
                        ++j;
                    }
                    j = el.size();
                    while (j < this.vSeriesDefns[i].getSeriesPalette().getEntries().size()) {
                        this.vSeriesDefns[i].getSeriesPalette().getEntries().remove(j);
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (!this.btnRemove.isEnabled()) {
            this.btnRemove.setEnabled(true);
            this.btnUp.setEnabled(true);
            this.btnDown.setEnabled(true);
        }
        this.scrollToView(this.iSelectedIndex);
        this.coPaletteEntries.redraw();
    }

    private final void swap(int iIndex1, int iIndex2) {
        block8: {
            int index2;
            int index1;
            block9: {
                int max;
                int min;
                block10: {
                    Fill o1 = (Fill)this.elPaletteEntries1.get(iIndex1);
                    Fill o2 = (Fill)this.elPaletteEntries1.get(iIndex2);
                    if (iIndex1 < iIndex2) {
                        this.elPaletteEntries1.remove(iIndex2);
                        this.elPaletteEntries1.add(iIndex1, (Object)o2);
                        this.elPaletteEntries1.remove(iIndex2);
                        this.elPaletteEntries1.add(iIndex2, (Object)o1);
                    } else {
                        this.elPaletteEntries1.remove(iIndex1);
                        this.elPaletteEntries1.add(iIndex2, (Object)o1);
                        this.elPaletteEntries1.remove(iIndex1);
                        this.elPaletteEntries1.add(iIndex1, (Object)o2);
                    }
                    if (this.iSelectedIndex == iIndex1) {
                        this.iSelectedIndex = iIndex2;
                    } else if (this.iSelectedIndex == iIndex2) {
                        this.iSelectedIndex = iIndex1;
                    }
                    if (this.vSeriesDefns == null) break block8;
                    index1 = iIndex1;
                    index2 = iIndex2;
                    if (!this.isMultiAxes() || this.wizardContext.getModel().getLegend().getItemType().getValue() != 0) break block9;
                    min = Math.min(index1, index2);
                    max = Math.max(index1, index2);
                    if (this.vSeriesDefns.length - 1 < min) break block8;
                    if (min > this.vSeriesDefns.length - 1 || this.vSeriesDefns.length - 1 >= max) break block10;
                    this.vSeriesDefns[min].getSeriesPalette().getEntries().set(0, (Object)((Fill)this.elPaletteEntries1.get(min)).copyInstance());
                    break block8;
                }
                if (this.vSeriesDefns.length - 1 < max) break block8;
                this.vSeriesDefns[min].getSeriesPalette().getEntries().set(0, (Object)((Fill)this.elPaletteEntries1.get(min)).copyInstance());
                this.vSeriesDefns[max].getSeriesPalette().getEntries().set(0, (Object)((Fill)this.elPaletteEntries1.get(max)).copyInstance());
                break block8;
            }
            int i = 0;
            while (i < this.vSeriesDefns.length) {
                int size = this.vSeriesDefns[i].getSeriesPalette().getEntries().size();
                index1 = iIndex1 - i >= 0 ? iIndex1 - i : size - i + iIndex1;
                index2 = iIndex2 - i >= 0 ? iIndex2 - i : size - i + iIndex2;
                EList el = this.vSeriesDefns[i].getSeriesPalette().getEntries();
                Fill o3 = (Fill)el.get(index1);
                Fill o4 = (Fill)el.get(index2);
                if (index1 < index2) {
                    el.remove(index2);
                    el.remove(index1);
                    el.add(index1, (Object)o4);
                    el.add(index2, (Object)o3);
                } else {
                    el.remove(index1);
                    el.remove(index2);
                    el.add(index2, (Object)o3);
                    el.add(index1, (Object)o4);
                }
                ++i;
            }
        }
        this.scrollToView(this.iSelectedIndex);
        this.coPaletteEntries.redraw();
    }

    public void handleEvent(Event ev) {
        this.updateSelectionFill((Fill)ev.data);
    }

    public void controlMoved(ControlEvent arg0) {
    }

    public void widgetDefaultSelected(SelectionEvent sev) {
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public void keyPressed(KeyEvent e) {
        switch (e.keyCode) {
            case 0x1000002: {
                if (this.iSelectedIndex >= this.elPaletteEntries1.size() - 1) break;
                ++this.iSelectedIndex;
                this.scrollToView(this.iSelectedIndex);
                this.coPaletteEntries.redraw();
                break;
            }
            case 0x1000001: {
                if (this.iSelectedIndex <= 0) break;
                --this.iSelectedIndex;
                this.scrollToView(this.iSelectedIndex);
                this.coPaletteEntries.redraw();
                break;
            }
            case 13: {
                if (!this.coPaletteEntries.isFocusControl()) break;
                this.coEditor.setFocus();
                break;
            }
            case 0x1000006: {
                this.iSelectedIndex += 8;
                if (this.iSelectedIndex > this.elPaletteEntries1.size()) {
                    this.iSelectedIndex = this.elPaletteEntries1.size() - 1;
                }
                this.scrollToView(this.iSelectedIndex);
                this.sb.setSelection(this.sb.getMaximum() * (this.iSelectedIndex + 1) / this.elPaletteEntries1.size());
                this.coPaletteEntries.redraw();
                break;
            }
            case 0x1000005: {
                this.iSelectedIndex -= 8;
                if (this.iSelectedIndex < 0) {
                    this.iSelectedIndex = 0;
                }
                this.scrollToView(this.iSelectedIndex);
                this.sb.setSelection(this.sb.getMaximum() * this.iSelectedIndex / this.elPaletteEntries1.size());
                this.coPaletteEntries.redraw();
                break;
            }
            case 9: {
                this.btnAdd.setFocus();
                break;
            }
            case 27: {
                this.getShell().close();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private boolean isMultiAxes() {
        return ChartUIUtil.getOrthogonalAxisNumber((Chart)this.wizardContext.getModel()) > 1;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.btnAdd.setEnabled(enabled);
        this.btnRemove.setEnabled(enabled);
        this.btnDown.setEnabled(enabled);
        this.btnUp.setEnabled(enabled);
        if (this.coEditor != null) {
            this.coEditor.setEnabled(enabled);
        }
        if (this.coPaletteEntries != null) {
            this.coPaletteEntries.setEnabled(enabled);
        }
    }
}

