/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartInsets;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LabelAttributesComposite
extends Composite
implements SelectionListener,
Listener {
    private Composite cmpGeneral = null;
    private Composite grpAttributes = null;
    private Group grpOutline = null;
    private ChartCheckbox btnVisible = null;
    private org.eclipse.swt.widgets.Label lblLabel = null;
    private org.eclipse.swt.widgets.Label lblPosition = null;
    private org.eclipse.swt.widgets.Label lblFill = null;
    private org.eclipse.swt.widgets.Label lblShadow = null;
    private org.eclipse.swt.widgets.Label lblFont = null;
    private ChartCombo cmbPosition = null;
    private FontDefinitionComposite fdcFont = null;
    private FillChooserComposite fccBackground = null;
    private FillChooserComposite fccShadow = null;
    private AbstractChartInsets icInsets = null;
    private String sGroupName = Messages.getString("LabelAttributesComposite.Lbl.Label");
    private Position lpCurrent = null;
    private Fill fBackground = null;
    private ColorDefinition cdShadow = null;
    private FontDefinition fdCurrent = null;
    private ColorDefinition cdFont = null;
    private LineAttributes laCurrent = null;
    private Label lblCurrent = null;
    private Insets insets = null;
    private String sUnits = null;
    private LineAttributesComposite liacOutline = null;
    private ExternalizedTextEditorComposite txtLabel = null;
    private Vector<Listener> vListeners = null;
    public static final int VISIBILITY_CHANGED_EVENT = 1;
    public static final int POSITION_CHANGED_EVENT = 2;
    public static final int FONT_CHANGED_EVENT = 3;
    public static final int BACKGROUND_CHANGED_EVENT = 4;
    public static final int SHADOW_CHANGED_EVENT = 5;
    public static final int OUTLINE_STYLE_CHANGED_EVENT = 6;
    public static final int OUTLINE_WIDTH_CHANGED_EVENT = 7;
    public static final int OUTLINE_COLOR_CHANGED_EVENT = 8;
    public static final int OUTLINE_VISIBILITY_CHANGED_EVENT = 9;
    public static final int INSETS_CHANGED_EVENT = 10;
    public static final int LABEL_CHANGED_EVENT = 11;
    public static final int ALLOW_ALL_POSITION = 63;
    public static final int ALLOW_VERTICAL_POSITION = 3;
    public static final int ALLOW_HORIZONTAL_POSITION = 12;
    public static final int ALLOW_INOUT_POSITION = 48;
    private boolean bEnabled = true;
    private int positionScope = 0;
    private ChartWizardContext wizardContext;
    private LabelAttributesContext attributesContext;
    private Label defLabel;
    private EObject eParent;
    private String sPositionProperty;

    public LabelAttributesComposite(Composite parent, int style, ChartWizardContext wizardContext, LabelAttributesContext attributesContext, String sGroupName, Position lpCurrent, Label lblCurrent, String sUnits, Label defaultLabel) {
        this(parent, style, wizardContext, attributesContext, sGroupName, lpCurrent, lblCurrent, sUnits, 63, defaultLabel);
    }

    public LabelAttributesComposite(Composite parent, int style, ChartWizardContext wizardContext, LabelAttributesContext attributesContext, String sGroupName, Position lpCurrent, Label lblCurrent, String sUnits, int positionScope, Label defaultLabel) {
        super(parent, style);
        this.wizardContext = wizardContext;
        this.attributesContext = attributesContext;
        this.sGroupName = sGroupName;
        this.lpCurrent = lpCurrent;
        this.lblCurrent = lblCurrent;
        this.sUnits = sUnits;
        this.fdCurrent = lblCurrent.getCaption().getFont();
        this.cdFont = lblCurrent.getCaption().getColor();
        this.fBackground = lblCurrent.getBackground();
        this.cdShadow = lblCurrent.getShadowColor();
        this.laCurrent = lblCurrent.getOutline();
        this.insets = lblCurrent.getInsets();
        this.positionScope = positionScope;
        this.defLabel = defaultLabel;
        this.init();
        this.placeComponents();
    }

    public LabelAttributesComposite(Composite parent, int style, ChartWizardContext wizardContext, LabelAttributesContext attributesContext, String sGroupName, EObject eParent, String positionProperty, String labelProperty, EObject eDefParent, String sUnits, int positionScope) {
        super(parent, style);
        this.wizardContext = wizardContext;
        this.attributesContext = attributesContext;
        this.sGroupName = sGroupName;
        this.eParent = eParent;
        this.sPositionProperty = positionProperty;
        if (eParent != null) {
            if (positionProperty != null) {
                this.lpCurrent = (Position)ChartElementUtil.getEObjectAttributeValue((EObject)eParent, (String)positionProperty);
            }
            if (labelProperty != null) {
                this.lblCurrent = (Label)ChartElementUtil.getEObjectAttributeValue((EObject)eParent, (String)labelProperty);
            }
        }
        if (eDefParent != null && labelProperty != null) {
            this.defLabel = (Label)ChartElementUtil.getEObjectAttributeValue((EObject)eDefParent, (String)labelProperty);
        }
        if (this.lblCurrent == null) {
            this.lblCurrent = LabelImpl.createDefault();
        }
        this.fdCurrent = this.lblCurrent.getCaption().getFont();
        this.cdFont = this.lblCurrent.getCaption().getColor();
        this.fBackground = this.lblCurrent.getBackground();
        this.cdShadow = this.lblCurrent.getShadowColor();
        this.laCurrent = this.lblCurrent.getOutline();
        this.insets = this.lblCurrent.getInsets();
        this.sUnits = sUnits;
        this.positionScope = positionScope;
        this.init();
        this.placeComponents();
    }

    public LabelAttributesComposite(Composite parent, int style, ChartWizardContext wizardContext, LabelAttributesContext attributesContext, String sGroupName, EObject eParent, String positionProperty, String labelProperty, EObject eDefParent, String sUnits) {
        this(parent, style, wizardContext, attributesContext, sGroupName, eParent, positionProperty, labelProperty, eDefParent, sUnits, 63);
    }

    public LabelAttributesComposite(Composite parent, int style, String sGroupName, Position lpCurrent, Label lblCurrent, String sUnits, boolean bPositionEnabled, boolean bVisibilityEnabled, ChartWizardContext wizardContext, boolean isAlignmentEnabled) {
        this(parent, style, sGroupName, lpCurrent, lblCurrent, sUnits, bPositionEnabled, bVisibilityEnabled, wizardContext, 63, isAlignmentEnabled);
    }

    public LabelAttributesComposite(Composite parent, int style, String sGroupName, Position lpCurrent, Label lblCurrent, String sUnits, boolean bPositionEnabled, boolean bVisibilityEnabled, ChartWizardContext wizardContext, int positionScope, boolean isAlignmentEnabled) {
        super(parent, style);
        this.sGroupName = sGroupName;
        this.lpCurrent = lpCurrent;
        this.lblCurrent = lblCurrent;
        this.sUnits = sUnits;
        this.fdCurrent = lblCurrent.getCaption().getFont();
        this.cdFont = lblCurrent.getCaption().getColor();
        this.fBackground = lblCurrent.getBackground();
        this.cdShadow = lblCurrent.getShadowColor();
        this.laCurrent = lblCurrent.getOutline();
        this.insets = lblCurrent.getInsets();
        this.wizardContext = wizardContext;
        this.positionScope = positionScope;
        this.attributesContext = new LabelAttributesContext();
        this.attributesContext.isPositionEnabled = bPositionEnabled;
        this.attributesContext.isVisibilityEnabled = bVisibilityEnabled;
        this.attributesContext.isFontAlignmentEnabled = isAlignmentEnabled;
        this.init();
        this.placeComponents();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        boolean bEnableUI;
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        GridLayout glAttributes = new GridLayout();
        glAttributes.horizontalSpacing = 5;
        glAttributes.verticalSpacing = 5;
        glAttributes.marginHeight = 7;
        glAttributes.marginWidth = 7;
        GridLayout glGeneral = new GridLayout();
        glGeneral.numColumns = 2;
        glGeneral.horizontalSpacing = 5;
        glGeneral.verticalSpacing = 5;
        FillLayout flOutline = new FillLayout();
        this.setLayout((Layout)flMain);
        if (this.sGroupName == null || this.sGroupName.length() == 0) {
            this.grpAttributes = new Composite((Composite)this, 0);
        } else {
            this.grpAttributes = new Group((Composite)this, 0);
            ((Group)this.grpAttributes).setText(this.sGroupName);
        }
        this.grpAttributes.setLayout((Layout)glAttributes);
        this.cmpGeneral = new Composite(this.grpAttributes, 0);
        GridData gdCMPGeneral = new GridData(768);
        this.cmpGeneral.setLayoutData((Object)gdCMPGeneral);
        this.cmpGeneral.setLayout((Layout)glGeneral);
        boolean bl = bEnableUI = this.bEnabled && !this.wizardContext.getUIFactory().isSetInvisible((EObject)this.lblCurrent);
        if (this.attributesContext.isVisibilityEnabled) {
            this.btnVisible = this.wizardContext.getUIFactory().createChartCheckbox(this.cmpGeneral, 0, this.defLabel.isVisible());
            this.btnVisible.setText(Messages.getString("LabelAttributesComposite.Lbl.IsVisible"));
            GridData gdCBVisible = new GridData(768);
            gdCBVisible.horizontalSpan = 2;
            this.btnVisible.setLayoutData((Object)gdCBVisible);
            this.btnVisible.setSelectionState(this.lblCurrent.isSetVisible() ? (this.lblCurrent.isVisible() ? 1 : 2) : 0);
            this.btnVisible.addSelectionListener((SelectionListener)this);
            if (this.bEnabled) {
                bEnableUI = this.wizardContext.getUIFactory().canEnableUI(this.btnVisible);
            }
        }
        if (this.attributesContext.isLabelEnabled) {
            this.lblLabel = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
            GridData gd = new GridData();
            this.lblLabel.setLayoutData((Object)gd);
            this.lblLabel.setText(Messages.getString("AxisMarkersSheet.Label.Label"));
            this.txtLabel = new ExternalizedTextEditorComposite(this.cmpGeneral, 2052, -1, -1, this.wizardContext.getUIServiceProvider().getRegisteredKeys(), this.wizardContext.getUIServiceProvider(), "");
            gd = new GridData(1808);
            this.txtLabel.setLayoutData(gd);
            this.txtLabel.addListener(this);
        }
        if (this.attributesContext.isPositionEnabled) {
            this.lblPosition = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
            GridData gdLBLPosition = new GridData();
            this.lblPosition.setLayoutData((Object)gdLBLPosition);
            this.lblPosition.setText(Messages.getString("LabelAttributesComposite.Lbl.Position"));
            this.lblPosition.setEnabled(bEnableUI);
            this.cmbPosition = this.wizardContext.getUIFactory().createChartCombo(this.cmpGeneral, 12, this.eParent, this.sPositionProperty, ((Position)ChartElementUtil.getEObjectAttributeValue((EObject)this.eParent, (String)this.sPositionProperty)).getName());
            GridData gdCMBPosition = new GridData(1808);
            this.cmbPosition.setLayoutData((Object)gdCMBPosition);
            this.cmbPosition.addSelectionListener((SelectionListener)this);
            this.cmbPosition.setEnabled(bEnableUI);
        }
        if (this.attributesContext.isFontEnabled) {
            this.lblFont = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
            GridData gdLFont = new GridData();
            this.lblFont.setLayoutData((Object)gdLFont);
            this.lblFont.setText(Messages.getString("LabelAttributesComposite.Lbl.Font"));
            this.lblFont.setEnabled(bEnableUI);
            this.fdcFont = new FontDefinitionComposite(this.cmpGeneral, 0, this.wizardContext, this.fdCurrent, this.cdFont, this.attributesContext.isFontAlignmentEnabled);
            GridData gdFDCFont = new GridData(1808);
            gdFDCFont.widthHint = this.fdcFont.getPreferredSize().x;
            gdFDCFont.grabExcessVerticalSpace = false;
            this.fdcFont.setLayoutData(gdFDCFont);
            this.fdcFont.addListener(this);
            this.fdcFont.setEnabled(bEnableUI);
        }
        if (this.attributesContext.isBackgroundEnabled) {
            this.lblFill = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
            GridData gdLFill = new GridData();
            this.lblFill.setLayoutData((Object)gdLFill);
            this.lblFill.setText(Messages.getString("LabelAttributesComposite.Lbl.Background"));
            this.lblFill.setEnabled(bEnableUI);
            int iFillOption = 152;
            this.fccBackground = new FillChooserComposite(this.cmpGeneral, 0, iFillOption |= this.wizardContext.getUIFactory().supportAutoUI() ? 4 : iFillOption, this.wizardContext, this.fBackground);
            GridData gdFCCBackground = new GridData(1808);
            this.fccBackground.setLayoutData(gdFCCBackground);
            this.fccBackground.addListener(this);
            this.fccBackground.setEnabled(bEnableUI);
        }
        if (this.attributesContext.isShadowEnabled) {
            this.lblShadow = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
            GridData gdLBLShadow = new GridData();
            this.lblShadow.setLayoutData((Object)gdLBLShadow);
            this.lblShadow.setText(Messages.getString("LabelAttributesComposite.Lbl.Shadow"));
            this.lblShadow.setEnabled(bEnableUI);
            int iFillOption = 152;
            this.fccShadow = new FillChooserComposite(this.cmpGeneral, 12, iFillOption |= this.wizardContext.getUIFactory().supportAutoUI() ? 4 : iFillOption, this.wizardContext, (Fill)this.cdShadow);
            GridData gdFCCShadow = new GridData(1808);
            this.fccShadow.setLayoutData(gdFCCShadow);
            this.fccShadow.addListener(this);
            this.fccShadow.setEnabled(bEnableUI);
        }
        if (this.attributesContext.isOutlineEnabled) {
            this.grpOutline = new Group(this.grpAttributes, 0);
            GridData gdGOutline = new GridData(768);
            this.grpOutline.setLayoutData((Object)gdGOutline);
            this.grpOutline.setText(Messages.getString("LabelAttributesComposite.Lbl.Outline"));
            this.grpOutline.setLayout((Layout)flOutline);
            this.grpOutline.setEnabled(bEnableUI);
            int optionalStyles = 15;
            this.liacOutline = new LineAttributesComposite((Composite)this.grpOutline, 0, optionalStyles |= this.wizardContext.getUIFactory().supportAutoUI() ? 16 : optionalStyles, this.wizardContext, this.laCurrent, this.defLabel.getOutline());
            this.liacOutline.addListener(this);
            this.liacOutline.setAttributesEnabled(bEnableUI);
        }
        if (this.attributesContext.isInsetsEnabled) {
            this.icInsets = this.wizardContext.getUIFactory().createChartInsetsComposite(this.grpAttributes, 0, 2, this.insets, this.sUnits, this.wizardContext.getUIServiceProvider(), this.wizardContext, this.defLabel.getInsets());
            GridData gdICInsets = new GridData(768);
            gdICInsets.grabExcessVerticalSpace = false;
            this.icInsets.setLayoutData((Object)gdICInsets);
            this.icInsets.setEnabled(bEnableUI);
        }
        if (!(this.cmpGeneral.getChildren() != null && this.cmpGeneral.getChildren().length != 0 || this.grpAttributes.getChildren() != null && this.grpAttributes.getChildren().length > 1)) {
            glAttributes = new GridLayout();
            glAttributes.horizontalSpacing = 0;
            glAttributes.verticalSpacing = 0;
            glAttributes.marginHeight = 0;
            glAttributes.marginWidth = 0;
            this.grpAttributes.setLayout((Layout)glAttributes);
        }
        this.populateLists();
    }

    public void setEnabled(boolean bState) {
        boolean bEnableUI = true;
        if (this.attributesContext.isVisibilityEnabled) {
            bEnableUI = this.wizardContext.getUIFactory().canEnableUI(this.btnVisible);
            this.btnVisible.setEnabled(bState);
        }
        this.setVisibleState(bState & bEnableUI);
        this.grpAttributes.setEnabled(bState);
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    private void populateLists() {
        if (this.attributesContext.isPositionEnabled) {
            boolean isFlipped = (this.isAxisAttribute() || this.isSeriesAttribute()) && this.isFlippedAxes();
            String[] names = ChartUIUtil.getPositionDisplayNames((int)this.positionScope, (boolean)isFlipped);
            this.cmbPosition.setItems(names);
            this.cmbPosition.setItemData(ChartUIUtil.getPositionNames((int)this.positionScope, (boolean)isFlipped));
            if (this.lpCurrent != null) {
                String positionName = ChartUIUtil.getFlippedPosition((Position)this.lpCurrent, (boolean)isFlipped).getName();
                this.cmbPosition.setSelection(positionName);
            } else {
                this.cmbPosition.select(0);
            }
        }
    }

    public void setLabel(Label lbl, String sUnits, EObject parent) {
        this.lblCurrent = lbl;
        this.sUnits = sUnits;
        this.eParent = parent;
        if (this.attributesContext.isBackgroundEnabled) {
            this.fBackground = this.lblCurrent.getBackground();
            this.fccBackground.setFill(this.fBackground);
        }
        if (this.attributesContext.isOutlineEnabled) {
            this.laCurrent = this.lblCurrent.getOutline();
            this.liacOutline.setLineAttributes(this.laCurrent);
        }
        if (this.attributesContext.isVisibilityEnabled) {
            this.btnVisible.setSelectionState(this.lblCurrent.isSetVisible() ? (this.lblCurrent.isVisible() ? 1 : 2) : 0);
            this.setVisibleState(this.wizardContext.getUIFactory().canEnableUI(this.btnVisible) && this.btnVisible.isEnabled());
        }
        if (this.attributesContext.isLabelEnabled) {
            this.txtLabel.setText(this.getLabelText(lbl));
        }
        if (this.attributesContext.isInsetsEnabled) {
            this.insets = this.lblCurrent.getInsets();
            this.icInsets.setInsets(this.insets, this.sUnits);
        }
        if (this.attributesContext.isShadowEnabled) {
            this.cdShadow = this.lblCurrent.getShadowColor();
            this.fccShadow.setFill((Fill)this.cdShadow);
        }
        if (this.attributesContext.isFontEnabled) {
            this.fdCurrent = this.lblCurrent.getCaption().getFont();
            this.cdFont = this.lblCurrent.getCaption().getColor();
            this.fdcFont.setFontDefinition(this.fdCurrent);
            this.fdcFont.setFontColor(this.cdFont);
        }
        this.redraw();
    }

    protected String getLabelText(Label lbl) {
        if (lbl.getCaption().getValue() == null) {
            return "";
        }
        return lbl.getCaption().getValue();
    }

    public void setLabelPosition(Position pos) {
        this.lpCurrent = pos;
        if (this.attributesContext.isPositionEnabled) {
            if (this.lpCurrent == null) {
                this.cmbPosition.select(0);
            } else if (this.isAxisAttribute() || this.isSeriesAttribute()) {
                this.cmbPosition.setText(LiteralHelper.fullPositionSet.getDisplayNameByName(ChartUIUtil.getFlippedPosition((Position)this.lpCurrent, (boolean)this.isFlippedAxes()).getName()));
            } else {
                this.cmbPosition.setText(LiteralHelper.fullPositionSet.getDisplayNameByName(this.lpCurrent.getName()));
            }
        }
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    private void fireEvent(Event e) {
        int iL = 0;
        while (iL < this.vListeners.size()) {
            this.vListeners.get(iL).handleEvent(e);
            ++iL;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Event eLabel = new Event();
        eLabel.widget = this;
        if (e.getSource().equals(this.cmbPosition)) {
            String selectedPosition = this.cmbPosition.getSelectedItemData();
            eLabel.data = this.isAxisAttribute() || this.isSeriesAttribute() ? ChartUIUtil.getFlippedPosition((Position)Position.getByName((String)selectedPosition), (boolean)this.isFlippedAxes()) : Position.getByName((String)selectedPosition);
            eLabel.type = 2;
            eLabel.detail = selectedPosition == null ? ChartUIExtensionUtil.PROPERTY_UNSET : ChartUIExtensionUtil.PROPERTY_UPDATE;
        } else if (e.widget == this.btnVisible) {
            eLabel.type = 1;
            eLabel.data = this.btnVisible.getSelectionState() == 1;
            eLabel.detail = this.btnVisible.getSelectionState() == 0 ? ChartUIExtensionUtil.PROPERTY_UNSET : ChartUIExtensionUtil.PROPERTY_UPDATE;
            this.setVisibleState(this.wizardContext.getUIFactory().canEnableUI(this.btnVisible));
        }
        this.fireEvent(eLabel);
    }

    private void setVisibleState(boolean isVisible) {
        if (this.attributesContext.isLabelEnabled) {
            this.lblLabel.setEnabled(isVisible);
            this.txtLabel.setEnabled(isVisible);
        }
        if (this.attributesContext.isPositionEnabled) {
            this.lblPosition.setEnabled(isVisible);
            this.cmbPosition.setEnabled(isVisible);
        }
        if (this.attributesContext.isFontEnabled) {
            this.lblFont.setEnabled(isVisible);
            this.fdcFont.setEnabled(isVisible);
        }
        if (this.attributesContext.isBackgroundEnabled) {
            this.lblFill.setEnabled(isVisible);
            this.fccBackground.setEnabled(isVisible);
        }
        if (this.attributesContext.isShadowEnabled) {
            this.lblShadow.setEnabled(isVisible);
            this.fccShadow.setEnabled(isVisible);
        }
        if (this.attributesContext.isInsetsEnabled) {
            this.icInsets.setEnabled(isVisible);
        }
        if (this.attributesContext.isOutlineEnabled) {
            this.grpOutline.setEnabled(isVisible);
            this.liacOutline.setAttributesEnabled(isVisible);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Point getPreferredSize() {
        Point ptSize = new Point(300, 130);
        if (this.attributesContext.isVisibilityEnabled) {
            ptSize.y += 30;
        }
        if (this.attributesContext.isPositionEnabled) {
            ptSize.y += 30;
        }
        return ptSize;
    }

    public void handleEvent(Event event) {
        Event eLabel = new Event();
        eLabel.widget = this;
        if (event.widget.equals((Object)this.fdcFont)) {
            eLabel.type = 3;
        } else if (event.widget.equals((Object)this.liacOutline)) {
            switch (event.type) {
                case 1: {
                    eLabel.type = 6;
                    break;
                }
                case 2: {
                    eLabel.type = 7;
                    break;
                }
                case 3: {
                    eLabel.type = 8;
                    break;
                }
                case 4: {
                    eLabel.type = 9;
                }
            }
        } else if (event.widget.equals((Object)this.fccBackground)) {
            eLabel.type = 4;
        } else if (event.widget.equals((Object)this.fccShadow)) {
            eLabel.type = 5;
        } else if (event.widget.equals(this.icInsets)) {
            eLabel.type = 10;
        } else if (event.widget.equals((Object)this.txtLabel)) {
            eLabel.type = 11;
        }
        eLabel.data = event.data;
        eLabel.detail = event.detail;
        this.fireEvent(eLabel);
    }

    private boolean isFlippedAxes() {
        return this.wizardContext.getModel() instanceof ChartWithAxes && ((ChartWithAxes)this.wizardContext.getModel()).getOrientation().equals((Object)Orientation.HORIZONTAL_LITERAL);
    }

    private boolean isAxisAttribute() {
        return this.lblCurrent.eContainer() instanceof Axis;
    }

    private boolean isSeriesAttribute() {
        return this.wizardContext.getModel() instanceof ChartWithAxes && this.lblCurrent.eContainer() instanceof Series;
    }

    public void setDefaultLabelValue(Label label) {
        this.defLabel = label;
        if (this.attributesContext.isInsetsEnabled) {
            this.icInsets.setDefaultInsets(this.defLabel.getInsets());
        }
    }

    public static class LabelAttributesContext {
        public boolean isLabelEnabled = false;
        public boolean isPositionEnabled = true;
        public boolean isVisibilityEnabled = true;
        public boolean isFontAlignmentEnabled = true;
        public boolean isFontEnabled = true;
        public boolean isBackgroundEnabled = true;
        public boolean isShadowEnabled = true;
        public boolean isOutlineEnabled = true;
        public boolean isInsetsEnabled = true;
    }
}

