/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.asm;

import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.asm.ASMClassEnhancer;
import org.datanucleus.enhancer.asm.method.InitClass;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.util.Localiser;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;

public class JdoMethodAdapter
extends MethodAdapter {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    protected ASMClassEnhancer enhancer;
    protected String methodName;
    protected String methodDescriptor;

    public JdoMethodAdapter(MethodVisitor mv, ASMClassEnhancer enhancer, String methodName, String methodDesc) {
        super(mv);
        this.enhancer = enhancer;
        this.methodName = methodName;
        this.methodDescriptor = methodDesc;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        String ownerName = owner.replace('/', '.');
        if (this.enhancer.isPersistenceCapable(ownerName)) {
            ClassMetaData cmd = null;
            boolean fieldInThisClass = true;
            if (this.enhancer.getClassMetaData().getFullClassName().equals(ownerName)) {
                cmd = this.enhancer.getClassMetaData();
            } else {
                fieldInThisClass = false;
                cmd = this.enhancer.getMetaDataManager().getMetaDataForClass(ownerName, this.enhancer.getClassLoaderResolver());
            }
            if (!fieldInThisClass || !this.methodName.equals("<init>")) {
                AbstractMemberMetaData fmd = cmd.getMetaDataForMember(name);
                if (fmd != null && !fmd.isStatic() && !fmd.isFinal() && fmd.getPersistenceModifier() != FieldPersistenceModifier.NONE && fmd.getPersistenceFlags() != 0 && fmd instanceof FieldMetaData) {
                    String fieldOwner = fmd.getClassName(true).replace('.', '/');
                    if (opcode == 180) {
                        this.mv.visitMethodInsn(184, fieldOwner, "jdoGet" + name, "(L" + fieldOwner + ";)" + desc);
                        if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
                            DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.EnhanceOriginalMethodField", (Object)(this.enhancer.className + "." + this.methodName), (Object)(fmd.getClassName(true) + "." + name), (Object)("jdoGet" + name + "()")));
                        }
                        return;
                    }
                    if (opcode == 181) {
                        this.mv.visitMethodInsn(184, fieldOwner, "jdoSet" + name, "(L" + fieldOwner + ";" + desc + ")V");
                        if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
                            DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.EnhanceOriginalMethodField", (Object)(this.enhancer.className + "." + this.methodName), (Object)(fmd.getClassName(true) + "." + name), (Object)("jdoSet" + name + "()")));
                        }
                        return;
                    }
                }
            } else {
                DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.EnhanceOriginalMethodFieldOmit", (Object)(this.enhancer.className + "." + this.methodName), (Object)(opcode == 180 ? "get" : "set"), (Object)(ownerName + "." + name)));
            }
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.methodName.equals("clone") && this.methodDescriptor.equals("()Ljava/lang/Object;") && this.enhancer.getClassMetaData().getPersistenceCapableSuperclass() == null && opcode == 183 && name.equals("clone") && desc.equals("()Ljava/lang/Object;")) {
            this.mv.visitMethodInsn(183, this.enhancer.getASMClassName(), "jdoSuperClone", "()Ljava/lang/Object;");
            return;
        }
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitInsn(int opcode) {
        if (this.enhancer.getClassMetaData().getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE && this.methodName.equals("<clinit>") && this.methodDescriptor.equals("()V") && opcode == 177) {
            InitClass initMethod = InitClass.getInstance(this.enhancer);
            initMethod.addInitialiseInstructions(this.mv);
            this.mv.visitInsn(177);
            return;
        }
        super.visitInsn(opcode);
    }
}

