/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AbstractCrosstabCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class ChangeMeasureOrderCommand
extends AbstractCrosstabCommand {
    private static final String NAME = Messages.getString("ChangeMeasureOrderCommand.TransName");
    private Object after = null;
    MeasureViewHandle parentVewHandle;
    MeasureViewHandle childViewHandle;

    public ChangeMeasureOrderCommand(DesignElementHandle parent, DesignElementHandle child, Object after) {
        super(child);
        this.after = after;
        this.parentVewHandle = CrosstabAdaptUtil.getMeasureViewHandle(CrosstabAdaptUtil.getExtendedItemHandle(parent));
        this.childViewHandle = CrosstabAdaptUtil.getMeasureViewHandle(CrosstabAdaptUtil.getExtendedItemHandle(child));
        this.setLabel(NAME);
    }

    public boolean canExecute() {
        return !DEUtil.isReferenceElement((DesignElementHandle)this.childViewHandle.getCrosstab().getCrosstabHandle());
    }

    public void execute() {
        this.transStart(NAME);
        CrosstabReportItemHandle reportHandle = this.childViewHandle.getCrosstab();
        try {
            reportHandle.pivotMeasure(this.childViewHandle.getModelHandle().getIndex(), this.findPosition());
        }
        catch (SemanticException e) {
            this.rollBack();
            ExceptionUtil.handle((Throwable)e);
        }
        this.transEnd();
    }

    private int findPosition() {
        int index;
        int ori = this.childViewHandle.getModelHandle().getIndex();
        int base = this.parentVewHandle.getModelHandle().getIndex();
        int value = 0;
        if (ori < base) {
            value = -1;
        }
        if (this.after instanceof DesignElementHandle && (index = ((DesignElementHandle)this.after).getIndex()) == 0) {
            return base + value;
        }
        return base + 1 + value;
    }
}

