/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.stocks;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.TreeMap;
import org.dma.java.math.BusinessRules;
import org.dma.java.math.SIGNUM;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;

public class StocksMap
extends TreeMap<String, Artigos> {
    private static final long serialVersionUID = 1L;

    public StocksMap(DatabaseManager manager, Calendar endDate) {
        QueryDefinition query = new QueryDefinition(TABLES.artigosmovimentos, QueryOrdering.DIRECTION.ASCENDING).addOrdering(new TableFieldKey(FIELDS.artigosmovimentos_datadocumento)).addFetchplan(new TableFieldKey(FIELDS.artigosmovimentos_artigo, FIELDS.artigos_codigo), new TableFieldKey(FIELDS.artigosmovimentos_saidas), new TableFieldKey(FIELDS.artigosmovimentos_entradas), new TableFieldKey(FIELDS.artigosmovimentos_tipostock), new TableFieldKey(FIELDS.artigosmovimentos_preco), new TableFieldKey(FIELDS.artigosmovimentos_factor), new TableFieldKey(FIELDS.artigosmovimentos_quantidade), new TableFieldKey(FIELDS.artigosmovimentos_percdesconto), new TableFieldKey(FIELDS.artigosmovimentos_percdesconto2));
        query.addRule(new FilterMapRule(FIELDS.artigosmovimentos_datadocumento).smallerEqual(endDate)).addRule(new FilterMapRule(FIELDS.artigosmovimentos_tipostock).equal(0)).addRule(new FilterMapRule(FIELDS.artigosmovimentos_artigo, FIELDS.artigos_tipo).equal(0)).addRule(new FilterMapRule(FIELDS.artigosmovimentos_artigo, FIELDS.artigos_estado).equal(1));
        for (Artigosmovimentos movimento : manager.getArtigosmovimentosCollection(query)) {
            Artigos artigo = (Artigos)this.get(movimento.getArtigo().getCodigo());
            if (artigo == null) {
                artigo = manager.loadArtigos(movimento.getArtigo().getCodigo(), false).cleanCopy();
                this.put(movimento.getArtigo().getCodigo(), artigo);
            }
            artigo.setPrecopcm(BusinessRules.averagePrice((BigDecimal)artigo.getStockreal(), (BigDecimal)artigo.getPrecopcm(), (BigDecimal)movimento.getEntradas(), (BigDecimal)movimento.getPrecobaseliquido()));
            artigo.addAcumulados(movimento.getSaidas(), movimento.getEntradas(), movimento.getTipostock(), SIGNUM.ONE);
        }
    }
}

