/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.stocks;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.dma.java.io.FileParameters;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringList;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.xml.IXMLExport;
import org.projectocolibri.xml.beans.stocks.IStocksTables;
import org.projectocolibri.xml.beans.stocks.x102.Stocks102Tables;
import org.projectocolibri.xml.beans.stocks.x201.Stocks201Tables;

public interface IStocksExport
extends IXMLExport {
    public FileParameters getFileParameters(File var1);

    public MessageList export(File var1);

    public void process() throws Exception;

    public static enum STOCKS_VERSIONS {
        x102(new Stocks102Tables()),
        x201(new Stocks201Tables());

        public static final STOCKS_VERSIONS DEFAULT;
        public static final String[] ITEMS;
        public final IStocksTables tables;
        public final Calendar expiration;

        static {
            DEFAULT = STOCKS_VERSIONS.getDefault();
            ITEMS = new String[STOCKS_VERSIONS.values().length];
            int index = 0;
            STOCKS_VERSIONS[] sTOCKS_VERSIONSArray = STOCKS_VERSIONS.values();
            int n = sTOCKS_VERSIONSArray.length;
            int n2 = 0;
            while (n2 < n) {
                STOCKS_VERSIONS value = sTOCKS_VERSIONSArray[n2];
                MessageLine line = new MessageLine((Object)value);
                STOCKS_VERSIONS.ITEMS[index++] = value.expiration == null ? line.toString() : line.brackets((Object)TimeDateUtils.getDateFormatted((Date)value.expiration.getTime())).toString();
                ++n2;
            }
        }

        private static STOCKS_VERSIONS getDefault() {
            return STOCKS_VERSIONS.values()[STOCKS_VERSIONS.values().length - 1];
        }

        private STOCKS_VERSIONS(IStocksTables tables) {
            this(tables, null);
        }

        private STOCKS_VERSIONS(IStocksTables tables, Calendar expiration) {
            this.tables = tables;
            this.expiration = expiration;
        }

        public boolean isExpired() {
            return this.isExpired(TimeDateUtils.getCalendar());
        }

        public boolean isExpired(Calendar calendar) {
            return this.expiration != null && TimeDateUtils.getCalendarWithoutTime((Calendar)calendar).after(this.expiration);
        }

        public FileParameters getFileParameters(File folder, int nif, Calendar endDate) {
            return new FileParameters(new StringList(new String[]{String.valueOf(nif), "STOCKS", this.name(), TimeDateUtils.getDateFormatted((Calendar)endDate, (String)"yyyy-MM-dd")}).concat("_"), "xml", folder);
        }
    }
}

