/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.saft.x0401;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import javax.jdo.PersistenceManager;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.dma.java.io.CustomFile;
import org.dma.java.math.BusinessRules;
import org.dma.java.time.CalendarPeriod;
import org.dma.java.util.Debug;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Empresa;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentosentregas;
import org.projectocolibri.api.database.model.Entidadesdocumentosivas;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;
import org.projectocolibri.xml.beans.saft.AbstractSAFTExport;
import org.projectocolibri.xml.beans.saft.ISAFTExport;
import org.projectocolibri.xml.beans.saft.SAFTEntidade;
import org.projectocolibri.xml.beans.saft.x0401.SAFTx0401Tables;
import x0401.oecdStandardAuditFileTaxPT1.AddressStructure;
import x0401.oecdStandardAuditFileTaxPT1.AddressStructurePT;
import x0401.oecdStandardAuditFileTaxPT1.AuditFileDocument;
import x0401.oecdStandardAuditFileTaxPT1.CountryDocument;
import x0401.oecdStandardAuditFileTaxPT1.Currency;
import x0401.oecdStandardAuditFileTaxPT1.CurrencyCodeDocument;
import x0401.oecdStandardAuditFileTaxPT1.CustomerDocument;
import x0401.oecdStandardAuditFileTaxPT1.CustomsInformation;
import x0401.oecdStandardAuditFileTaxPT1.HeaderDocument;
import x0401.oecdStandardAuditFileTaxPT1.InvoiceStatusDocument;
import x0401.oecdStandardAuditFileTaxPT1.MovementTax;
import x0401.oecdStandardAuditFileTaxPT1.OrderReferences;
import x0401.oecdStandardAuditFileTaxPT1.PaymentMethod;
import x0401.oecdStandardAuditFileTaxPT1.PaymentStatusDocument;
import x0401.oecdStandardAuditFileTaxPT1.PaymentTax;
import x0401.oecdStandardAuditFileTaxPT1.ProductDocument;
import x0401.oecdStandardAuditFileTaxPT1.ProductSerialNumber;
import x0401.oecdStandardAuditFileTaxPT1.References;
import x0401.oecdStandardAuditFileTaxPT1.SAFTPTPaymentType;
import x0401.oecdStandardAuditFileTaxPT1.Settlement;
import x0401.oecdStandardAuditFileTaxPT1.ShippingPointStructure;
import x0401.oecdStandardAuditFileTaxPT1.SourceDocumentsDocument;
import x0401.oecdStandardAuditFileTaxPT1.SpecialRegimes;
import x0401.oecdStandardAuditFileTaxPT1.SupplierAddressStructure;
import x0401.oecdStandardAuditFileTaxPT1.SupplierDocument;
import x0401.oecdStandardAuditFileTaxPT1.Tax;
import x0401.oecdStandardAuditFileTaxPT1.TaxAccountingBasisDocument;
import x0401.oecdStandardAuditFileTaxPT1.TaxTableDocument;
import x0401.oecdStandardAuditFileTaxPT1.TaxTableEntryDocument;
import x0401.oecdStandardAuditFileTaxPT1.WithholdingTax;
import x0401.oecdStandardAuditFileTaxPT1.WithholdingTaxTypeDocument;
import x0401.oecdStandardAuditFileTaxPT1.WorkStatusDocument;

public class SAFTx0401Export
extends AbstractSAFTExport {
    private final SAFTx0401Tables tables = new SAFTx0401Tables();
    private final AuditFileDocument auditFileDocument = AuditFileDocument.Factory.newInstance();
    private final AuditFileDocument.AuditFile auditFile = this.auditFileDocument.addNewAuditFile();
    private final HeaderDocument.Header header = this.auditFile.addNewHeader();
    private final AuditFileDocument.AuditFile.MasterFiles masterFiles = this.auditFile.addNewMasterFiles();
    private final Collection<String> customers = new LinkedHashSet<String>();
    private final Collection<String> suppliers = new LinkedHashSet<String>();
    private final Collection<String> products = new LinkedHashSet<String>();
    private final Collection<String> taxes = new TreeSet<String>();
    private final SourceDocumentsDocument.SourceDocuments sourceDocuments = this.auditFile.addNewSourceDocuments();

    public SAFTx0401Export(DatabaseManager manager, CalendarPeriod period) {
        super(ISAFTExport.SAFT_VERSIONS.x0401, manager, period);
    }

    @Override
    public void process(ISAFTExport.SAFT_TYPE type) throws Exception {
        XmlCursor cursor = this.auditFile.newCursor();
        cursor.toFirstContentToken();
        cursor.insertNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        cursor.dispose();
        this.createHeader();
        this.createSourceDocuments(type);
    }

    public boolean save(OutputStream stream) {
        if (stream != null) {
            try {
                XmlOptions options = new XmlOptions();
                options.setSavePrettyPrint();
                options.setUseDefaultNamespace();
                options.setCharacterEncoding(CustomFile.WIN1252_CHARSET.name());
                this.auditFileDocument.save(stream, options);
                stream.close();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.auditFile.validate();
    }

    public boolean isEmpty() {
        return !(this.sourceDocuments.getSalesInvoices() != null && !this.sourceDocuments.getSalesInvoices().getInvoiceList().isEmpty() || this.sourceDocuments.getMovementOfGoods() != null && !this.sourceDocuments.getMovementOfGoods().getStockMovementList().isEmpty() || this.sourceDocuments.getWorkingDocuments() != null && !this.sourceDocuments.getWorkingDocuments().getWorkDocumentList().isEmpty() || this.sourceDocuments.getPayments() != null && !this.sourceDocuments.getPayments().getPaymentList().isEmpty());
    }

    private void createHeader() {
        Empresa empresa = this.manager.getEmpresa();
        this.header.setAuditFileVersion(this.parseText(this.tables.getFileVersion(), 10));
        this.header.setCompanyID(this.parseText(this.createCompanyID(empresa), 50));
        this.header.setTaxRegistrationNumber(empresa.getNifToInteger().intValue());
        this.header.setTaxAccountingBasis(TaxAccountingBasisDocument.TaxAccountingBasis.F);
        this.header.setCompanyName(this.parseText(empresa.getNomeToText(), 100));
        this.header.setCompanyAddress(this.createAdressStructurePT(this.parseText(empresa.getMoradaToText(), 210), this.parseText(empresa.getLocalidadeToText(), 50), this.parseText(empresa.getCodigopostal(), 8, ""), empresa.getPais().getCodigo()));
        this.header.setFiscalYear(TimeDateUtils.getYear((Calendar)this.period.getStartDate()));
        this.header.setStartDate(TimeDateUtils.getCalendarWithoutTimezone((Calendar)this.period.getStartDate()));
        this.header.setEndDate(TimeDateUtils.getCalendarWithoutTimezone((Calendar)this.period.getEndDate()));
        CurrencyCodeDocument.CurrencyCode currencyCode = CurrencyCodeDocument.CurrencyCode.Factory.newInstance();
        currencyCode.setStringValue("EUR");
        this.header.setCurrencyCode((XmlObject)currencyCode);
        this.header.setDateCreated(TimeDateUtils.getCalendarWithoutTimezone());
        this.header.setTaxEntity(this.parseText(this.isEmpty(empresa.getEstabelecimentoToText()) ? "Global" : this.removeAll(empresa.getEstabelecimentoToText(), "&"), 20));
        this.header.setProductCompanyTaxID(String.valueOf(Colibri.AUTOR_LEGAL.nif));
        this.header.setSoftwareCertificateNumber(BigInteger.valueOf(38L));
        this.header.setProductID(this.parseText(String.valueOf(Colibri.PROJECTO_NOME) + "/" + Colibri.AUTOR_LEGAL.nome, 255));
        this.header.setProductVersion(this.parseText(Colibri.PROJECTO_VERSAO, 30));
        if (!this.isEmpty(empresa.getTelefoneToText())) {
            this.header.setTelephone(this.parseText(empresa.getTelefoneToText(), 20));
        }
        if (!this.isEmpty(empresa.getFaxToText())) {
            this.header.setFax(this.parseText(empresa.getFaxToText(), 20));
        }
        if (!this.isEmpty(empresa.getEmailToText())) {
            this.header.setEmail(this.parseText(empresa.getEmailToText(), 60));
        }
        if (!this.isEmpty(empresa.getUrlToText())) {
            this.header.setWebsite(this.parseText(empresa.getUrlToText(), 60));
        }
    }

    private String createCompanyID(Empresa empresa) {
        String conservatoria = StringUtils.letters((String)empresa.getConservatoriaToText());
        String registo = StringUtils.numbers((String)empresa.getRegistocomercialToText());
        return this.isEmpty(conservatoria) || this.isEmpty(registo) ? empresa.getNifToNumbers() : String.valueOf(conservatoria) + " " + registo;
    }

    private AddressStructurePT createAdressStructurePT(String addressDetail, String city, String postalCode, String countryCode) {
        AddressStructurePT addressStructure = AddressStructurePT.Factory.newInstance();
        addressStructure.setAddressDetail(this.isEmpty(addressDetail) ? "Desconhecido" : addressDetail);
        addressStructure.setCity(this.isEmpty(city) ? "Desconhecido" : city);
        addressStructure.setPostalCode(this.isEmpty(postalCode) ? "Desconhecido" : postalCode);
        CountryDocument.Country country = CountryDocument.Country.Factory.newInstance();
        country.setStringValue(this.tables.countryCode(countryCode));
        addressStructure.setCountry((XmlObject)country);
        return addressStructure;
    }

    private void addCustomer(Entidades entidade) {
        if (this.customers.add(entidade.getKey())) {
            Debug.out((Object)entidade);
            CustomerDocument.Customer customer = this.masterFiles.addNewCustomer();
            customer.setCustomerID(this.parseText(entidade.getKey(), 30));
            customer.setAccountID(this.parseText("Desconhecido", 30));
            String customerTaxID = entidade.getNifParsed();
            customer.setCustomerTaxID(this.isEmpty(customerTaxID) ? "999999990" : this.parseText(customerTaxID, 30));
            customer.setCompanyName(this.isEmpty(entidade.getNomeToText()) ? "Desconhecido" : this.parseText(entidade.getNomeToText(), 100));
            if (!this.isEmpty(entidade.getResponsavelToText())) {
                customer.setContact(this.parseText(entidade.getResponsavelToText(), 50));
            }
            customer.setBillingAddress(this.createAdressStructure(this.parseText(entidade.getMoradaToText(), 210), this.parseText(entidade.getLocalidadeToText(), 50), this.parseText(entidade.getCodigopostal(), 20), entidade.getPais().getCodigo()));
            if (!this.isEmpty(entidade.getTelefoneToText())) {
                customer.setTelephone(this.parseText(entidade.getTelefoneToText(), 20));
            }
            if (!this.isEmpty(entidade.getFaxToText())) {
                customer.setFax(this.parseText(entidade.getFaxToText(), 20));
            }
            if (!this.isEmpty(entidade.getEmailToText())) {
                customer.setEmail(this.parseText(entidade.getEmailToText(), 60));
            }
            if (!this.isEmpty(entidade.getUrlToText())) {
                customer.setWebsite(this.parseText(entidade.getUrlToText(), 60));
            }
            customer.setSelfBillingIndicator(0);
        }
    }

    private AddressStructure createAdressStructure(String addressDetail, String city, String postalCode, String countryCode) {
        AddressStructure addressStructure = AddressStructure.Factory.newInstance();
        addressStructure.setAddressDetail(this.isEmpty(addressDetail) ? "Desconhecido" : addressDetail);
        addressStructure.setCity(this.isEmpty(city) ? "Desconhecido" : city);
        addressStructure.setPostalCode(this.isEmpty(postalCode) ? "Desconhecido" : postalCode);
        addressStructure.setCountry(this.tables.countryCode(countryCode));
        return addressStructure;
    }

    private void addSupplier(Entidades entidade) {
        if (this.suppliers.add(entidade.getKey())) {
            Debug.out((Object)entidade);
            SupplierDocument.Supplier supplier = this.masterFiles.addNewSupplier();
            supplier.setSupplierID(this.parseText(entidade.getKey(), 30));
            supplier.setAccountID(this.parseText("Desconhecido", 30));
            String supplierTaxID = entidade.getNifParsed();
            supplier.setSupplierTaxID(this.isEmpty(supplierTaxID) ? "999999990" : this.parseText(supplierTaxID, 30));
            supplier.setCompanyName(this.isEmpty(entidade.getNomeToText()) ? "Desconhecido" : this.parseText(entidade.getNomeToText(), 100));
            if (!this.isEmpty(entidade.getResponsavelToText())) {
                supplier.setContact(this.parseText(entidade.getResponsavelToText(), 50));
            }
            supplier.setBillingAddress(this.createSupplierAddressStructure(this.parseText(entidade.getMoradaToText(), 210), this.parseText(entidade.getLocalidadeToText(), 50), this.parseText(entidade.getCodigopostal(), 20), entidade.getPais().getCodigo()));
            if (!this.isEmpty(entidade.getTelefoneToText())) {
                supplier.setTelephone(this.parseText(entidade.getTelefoneToText(), 20));
            }
            if (!this.isEmpty(entidade.getFaxToText())) {
                supplier.setFax(this.parseText(entidade.getFaxToText(), 20));
            }
            if (!this.isEmpty(entidade.getEmailToText())) {
                supplier.setEmail(this.parseText(entidade.getEmailToText(), 60));
            }
            if (!this.isEmpty(entidade.getUrlToText())) {
                supplier.setWebsite(this.parseText(entidade.getUrlToText(), 60));
            }
            supplier.setSelfBillingIndicator(0);
        }
    }

    private SupplierAddressStructure createSupplierAddressStructure(String addressDetail, String city, String postalCode, String countryCode) {
        SupplierAddressStructure addressStructure = SupplierAddressStructure.Factory.newInstance();
        addressStructure.setAddressDetail(this.isEmpty(addressDetail) ? "Desconhecido" : addressDetail);
        addressStructure.setCity(this.isEmpty(city) ? "Desconhecido" : city);
        addressStructure.setPostalCode(this.isEmpty(postalCode) ? "Desconhecido" : postalCode);
        addressStructure.setCountry(this.tables.countryCode(countryCode));
        return addressStructure;
    }

    private Entidades addEntidade(Entidadesdocumentos documento) {
        Entidades entidade = SAFTEntidade.getInstance(documento);
        switch (entidade.getTipoentidade().getTipoentidade()) {
            case 0: {
                this.addCustomer(entidade);
                break;
            }
            case 1: {
                this.addSupplier(entidade);
            }
        }
        return entidade;
    }

    private Artigos addProduct(Entidadesdocumentoslinhas linha) {
        Artigos artigo;
        Artigos artigos = artigo = linha.hasArtigo() ? linha.getArtigo() : new Artigos(this.manager, "GENERICO", "Artigo Generico");
        if (this.products.add(artigo.getCodigo())) {
            Debug.out((Object)artigo);
            ProductDocument.Product product = this.masterFiles.addNewProduct();
            product.setProductType(this.tables.getProductType(artigo));
            product.setProductCode(this.parseCode(artigo.getCodigo(), 60));
            if (!this.isEmpty(artigo.getFamilia().getDescricaoToText())) {
                product.setProductGroup(this.parseText(artigo.getFamilia().getDescricaoToText(), 50));
            }
            product.setProductDescription(this.isEmpty(artigo.getDescricaoToText()) ? "Desconhecido" : this.parseText(artigo.getDescricaoToText(), 2, 200));
            product.setProductNumberCode(artigo.getUnidades().isEmpty() || this.isEmpty(artigo.getUnidades(0).getCodigobarrasToText()) ? this.parseCode(artigo.getCodigo(), 60) : this.parseText(artigo.getUnidades(0).getCodigobarrasToText(), 60));
        }
        return artigo;
    }

    private TaxTableDocument.TaxTable getTaxTable() {
        TaxTableDocument.TaxTable taxTable = this.masterFiles.getTaxTable();
        return taxTable == null ? this.masterFiles.addNewTaxTable() : taxTable;
    }

    private Codigosiva addTaxTableEntry(Codigosiva codigoiva, Paises pais) {
        if (this.taxes.add(codigoiva.getCodigo())) {
            Debug.out((Object)codigoiva);
            TaxTableEntryDocument.TaxTableEntry taxTableEntry = this.getTaxTable().addNewTaxTableEntry();
            taxTableEntry.setTaxType(this.tables.getTaxType(codigoiva));
            taxTableEntry.setTaxCountryRegion(this.tables.getTaxCountryRegion(codigoiva, pais));
            taxTableEntry.setTaxCode(this.tables.getTaxCode(codigoiva));
            taxTableEntry.setDescription(this.parseText(codigoiva.getDescricaoToText(), 255));
            taxTableEntry.setTaxPercentage(codigoiva.hasTaxa() ? codigoiva.getTaxa() : BigDecimal.ZERO);
        }
        return codigoiva;
    }

    private void createSourceDocuments(ISAFTExport.SAFT_TYPE type) {
        switch (type) {
            case GLOBAL: {
                this.createSourceDocuments(ISAFTExport.SAFT_TYPE.FACTURAS);
                this.createSourceDocuments(ISAFTExport.SAFT_TYPE.TRANSPORTES);
                this.createSourceDocuments(ISAFTExport.SAFT_TYPE.CONFERENCIA);
                break;
            }
            case FACTURAS: {
                this.createSalesInvoices(this.sourceDocuments);
                this.createPayments(this.sourceDocuments);
                break;
            }
            case TRANSPORTES: {
                this.createMovementOfGoods(this.sourceDocuments);
                break;
            }
            case CONFERENCIA: {
                this.createWorkingDocuments(this.sourceDocuments);
            }
        }
    }

    private void createSalesInvoices(SourceDocumentsDocument.SourceDocuments sourceDocuments) {
        SourceDocumentsDocument.SourceDocuments.SalesInvoices salesInvoices = sourceDocuments.addNewSalesInvoices();
        PersistenceManager pm = this.manager.getPersistenceManager();
        for (Documentostipos tipodocumento : this.manager.getDocumentostiposCollection()) {
            if (tipodocumento.getSAFTDocumentGroup() != Documentostipos.SAFT_DOCUMENT_GROUP.INVOICE) continue;
            for (Entidadesdocumentos element : this.getEntidadesdocumentosCollection(tipodocumento, ISAFTExport.SAFT_TYPE.FACTURAS)) {
                Entidadesdocumentos documento = (Entidadesdocumentos)TABLES.entidadesdocumentos.getObject(pm, element.getKey());
                this.createInvoice(salesInvoices, documento);
            }
        }
        pm.close();
        BigDecimal totalDebit = BigDecimal.ZERO;
        BigDecimal totalCredit = BigDecimal.ZERO;
        for (SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice invoice : salesInvoices.getInvoiceList()) {
            if (invoice.getDocumentStatus().getInvoiceStatus() == InvoiceStatusDocument.InvoiceStatus.A || invoice.getDocumentStatus().getInvoiceStatus() == InvoiceStatusDocument.InvoiceStatus.F) continue;
            for (SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line line : invoice.getLineList()) {
                totalDebit = totalDebit.add(line.getDebitAmount() == null ? BigDecimal.ZERO : line.getDebitAmount());
                totalCredit = totalCredit.add(line.getCreditAmount() == null ? BigDecimal.ZERO : line.getCreditAmount());
            }
        }
        salesInvoices.setNumberOfEntries(BigInteger.valueOf(salesInvoices.sizeOfInvoiceArray()));
        salesInvoices.setTotalDebit(ATMessageFormatter.getGrossTotal(totalDebit));
        salesInvoices.setTotalCredit(ATMessageFormatter.getGrossTotal(totalCredit));
    }

    private void createInvoice(SourceDocumentsDocument.SourceDocuments.SalesInvoices salesInvoices, Entidadesdocumentos documento) {
        Debug.out((Object)documento);
        SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice invoice = salesInvoices.addNewInvoice();
        invoice.setInvoiceNo(this.parseText(documento.toString(), 60));
        invoice.setATCUD(documento.getATCUD());
        invoice.setDocumentStatus(this.createInvoiceDocumentStatus(documento));
        invoice.setHash(documento.getHashToText());
        if (documento.isAssinado()) {
            invoice.setHashControl(documento.getHashcontrolToText());
        }
        invoice.setPeriod(TimeDateUtils.getMonth((Date)documento.getDatacriacao()) + 1);
        invoice.setInvoiceDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatacriacao()));
        invoice.setInvoiceType(this.tables.getInvoiceType(documento.getTipodocumento()));
        invoice.setSpecialRegimes(this.createSpecialRegimes(documento));
        invoice.setSourceID(documento.getAutor().getUser());
        invoice.setSystemEntryDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatasistemaWithTime()));
        invoice.setCustomerID(this.parseText(this.addEntidade(documento).getKey(), 30));
        invoice.setShipTo(this.createShipToStructure(documento));
        invoice.setShipFrom(this.createShipFromStructure(documento));
        this.createInvoiceLines(invoice, documento);
        invoice.setDocumentTotals(this.createInvoiceDocumentTotals(documento));
        if (documento.getTotalretencoes().signum() != 0) {
            invoice.setWithholdingTaxArray(this.createWithholdingTaxArray(documento));
        }
    }

    private SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.DocumentStatus createInvoiceDocumentStatus(Entidadesdocumentos documento) {
        SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.DocumentStatus documentStatus = SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.DocumentStatus.Factory.newInstance();
        documentStatus.setInvoiceStatus(this.tables.getInvoiceStatus(documento));
        documentStatus.setInvoiceStatusDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatasistemaWithTime()));
        documentStatus.setSourceID(documento.getEditor().getUser());
        documentStatus.setSourceBilling(this.tables.getSourceBilling(documento));
        return documentStatus;
    }

    private SpecialRegimes createSpecialRegimes(Entidadesdocumentos documento) {
        SpecialRegimes specialRegimes = SpecialRegimes.Factory.newInstance();
        specialRegimes.setSelfBillingIndicator(0);
        specialRegimes.setCashVATSchemeIndicator(0);
        specialRegimes.setThirdPartiesBillingIndicator(0);
        return specialRegimes;
    }

    private ShippingPointStructure createShipToStructure(Entidadesdocumentos documento) {
        ShippingPointStructure shippingPoint = ShippingPointStructure.Factory.newInstance();
        shippingPoint.setDeliveryDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatadescarga()));
        shippingPoint.setAddress(this.createAdressStructure(this.parseText(documento.getLocaldescargaToText(), 210), this.parseText(documento.getLocalidadedescargaToText(), 50), this.parseText(documento.getCodigopostaldescarga(), 20), documento.getPaisdescarga().getCodigo()));
        return shippingPoint;
    }

    private ShippingPointStructure createShipFromStructure(Entidadesdocumentos documento) {
        ShippingPointStructure shippingPoint = ShippingPointStructure.Factory.newInstance();
        shippingPoint.setDeliveryDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatacarga()));
        shippingPoint.setAddress(this.createAdressStructure(this.parseText(documento.getLocalcargaToText(), 210), this.parseText(documento.getLocalidadecargaToText(), 50), this.parseText(documento.getCodigopostalcarga(), 20), documento.getPaiscarga().getCodigo()));
        return shippingPoint;
    }

    private void createInvoiceLines(SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice invoice, Entidadesdocumentos documento) {
        for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento$Tipo(1)) {
            this.createInvoiceLine(invoice, linha);
        }
    }

    private void createInvoiceLine(SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice invoice, Entidadesdocumentoslinhas linha) {
        SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.Line line = invoice.addNewLine();
        line.setLineNumber(BigInteger.valueOf(linha.getNumerolinha().intValue()));
        if (linha.getLinhaorigem() != null && !linha.getDocumento().getTipodocumento().isTipodocumento(4)) {
            line.setOrderReferencesArray(this.createOrderReferencesArray(linha.getLinhaorigem()));
        }
        line.setProductCode(this.parseCode(this.addProduct(linha).getCodigo(), 60));
        line.setProductDescription(this.isEmpty(linha.getDescricaoToText()) ? "Desconhecido" : this.parseText(linha.getDescricaoToText(), 2, 200));
        line.setQuantity(linha.getQuantidade().abs());
        line.setUnitOfMeasure(this.parseText(linha.getUnidademedida().getDescricaoToText(), 20));
        BigDecimal valorliquido = BusinessRules.netValue((BigDecimal)linha.getValorliquido(), (BigDecimal)linha.getDocumento().getPercdesconto());
        line.setUnitPrice(valorliquido.divide(linha.getQuantidade(), FIELDS.entidadesdocumentoslinhas_preco.format.getSize().scale, RoundingMode.HALF_EVEN).abs());
        line.setTaxPointDate(line.getOrderReferencesList().isEmpty() ? TimeDateUtils.getCalendarWithoutTimezone((Date)linha.getDocumento().getDatacriacao()) : ((OrderReferences)line.getOrderReferencesList().get(0)).getOrderDate());
        if (linha.getLinhaorigem() != null && linha.getDocumento().getTipodocumento().isTipodocumento(4)) {
            line.setReferencesArray(this.createReferencesArray(linha.getLinhaorigem()));
        }
        line.setDescription(this.isEmpty(linha.getDescricaoToText()) ? "Desconhecido" : this.parseText(linha.getDescricaoToText(), 200));
        if (!linha.getNumeroserie().isEmpty()) {
            line.setProductSerialNumber(this.createProductSerialNumber(linha));
        }
        switch (linha.getDocumento().getTipodocumento().getSAFTMovementClass()) {
            case NONE: {
                break;
            }
            case DEBIT: {
                if (valorliquido.signum() >= 0) {
                    line.setDebitAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido, RoundingMode.HALF_EVEN));
                    break;
                }
                line.setCreditAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido.abs(), RoundingMode.HALF_EVEN));
                break;
            }
            case CREDIT: {
                if (valorliquido.signum() >= 0) {
                    line.setCreditAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido, RoundingMode.HALF_EVEN));
                    break;
                }
                line.setDebitAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido.abs(), RoundingMode.HALF_EVEN));
            }
        }
        line.setTax(this.createTax(linha));
        if (!linha.getCodigoiva().hasTaxa()) {
            line.setTaxExemptionReason(this.isEmpty(linha.getIsencaoiva().getArtigolegalToText()) ? this.parseText(linha.getIsencaoiva().getDescricaoToText(), 60) : this.parseText(linha.getIsencaoiva().getArtigolegalToText(), 60));
        }
        if (!linha.getCodigoiva().hasTaxa()) {
            line.setTaxExemptionCode(linha.getIsencaoiva().getMotivoAT().name());
        }
        line.setSettlementAmount(FIELDS.entidadesdocumentoslinhas_valordesconto.format.setScale(BusinessRules.netValue((BigDecimal)linha.getValordesconto(), (BigDecimal)linha.getDocumento().getPercdesconto()), RoundingMode.HALF_EVEN));
    }

    private OrderReferences[] createOrderReferencesArray(Entidadesdocumentoslinhas linha) {
        OrderReferences orderReferences = OrderReferences.Factory.newInstance();
        orderReferences.setOriginatingON(this.parseText(linha.getDocumento().toString(), 60));
        orderReferences.setOrderDate(TimeDateUtils.getCalendarWithoutTimezone((Date)linha.getDatadocumento()));
        return new OrderReferences[]{orderReferences};
    }

    private References[] createReferencesArray(Entidadesdocumentoslinhas linha) {
        References references = References.Factory.newInstance();
        references.setReference(this.parseText(linha.getDocumento().toString(), 60));
        return new References[]{references};
    }

    private ProductSerialNumber createProductSerialNumber(Entidadesdocumentoslinhas linha) {
        ProductSerialNumber serial = ProductSerialNumber.Factory.newInstance();
        serial.setSerialNumberArray(new String[]{this.parseText(linha.getNumeroserie(), 100)});
        return serial;
    }

    private Tax createTax(Entidadesdocumentoslinhas linha) {
        Tax tax = Tax.Factory.newInstance();
        tax.setTaxType(this.tables.getTaxType(this.addTaxTableEntry(linha.getCodigoiva(), linha.getDocumento().getPais())));
        tax.setTaxCountryRegion(this.tables.getTaxCountryRegion(linha.getCodigoiva(), linha.getDocumento().getPais()));
        tax.setTaxCode(this.tables.getTaxCode(linha.getCodigoiva()));
        tax.setTaxPercentage(linha.getCodigoiva().hasTaxa() ? linha.getCodigoiva().getTaxa() : BigDecimal.ZERO);
        return tax;
    }

    private CustomsInformation createCustomsInformation(Entidadesdocumentos documento) {
        CustomsInformation customsInformation = CustomsInformation.Factory.newInstance();
        return customsInformation;
    }

    private SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.DocumentTotals createInvoiceDocumentTotals(Entidadesdocumentos documento) {
        SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.DocumentTotals documentTotals = SourceDocumentsDocument.SourceDocuments.SalesInvoices.Invoice.DocumentTotals.Factory.newInstance();
        documentTotals.setTaxPayable(ATMessageFormatter.getGrossTotal(documento.getTotaliva().abs()));
        documentTotals.setNetTotal(ATMessageFormatter.getGrossTotal(documento.getTotalliquido().abs()));
        documentTotals.setGrossTotal(ATMessageFormatter.getGrossTotal(documento.getTotalbruto().abs()));
        documentTotals.setPaymentArray(this.createPaymentMethodArray(documento));
        return documentTotals;
    }

    private Currency createCurrency(Entidadesdocumentos documento) {
        Currency currency = Currency.Factory.newInstance();
        currency.setCurrencyCode(this.tables.currencyCode(this.manager.getParametros().getMoeda().getCodigo()));
        currency.setCurrencyAmount(ATMessageFormatter.getGrossTotal(documento.getTotalbruto().abs()));
        currency.setExchangeRate(documento.getCambio().getCambio());
        return currency;
    }

    private Settlement[] createSettlementArray(Entidadesdocumentos documento) {
        Settlement settlement = Settlement.Factory.newInstance();
        return new Settlement[]{settlement};
    }

    private PaymentMethod[] createPaymentMethodArray(Entidadesdocumentos documento) {
        PaymentMethod[] paymentMethod = new PaymentMethod[documento.getEntregaspagamento().size()];
        int index = 0;
        for (Entidadesdocumentosentregas linha : documento.getEntregaspagamento()) {
            PaymentMethod payment = PaymentMethod.Factory.newInstance();
            payment.setPaymentMechanism(this.tables.getPaymentMechanism(linha.getMetodopagamento()));
            payment.setPaymentAmount(ATMessageFormatter.getGrossTotal(linha.getValor().abs()));
            payment.setPaymentDate(TimeDateUtils.getCalendarWithoutTimezone((Date)linha.getDataprocessamento()));
            paymentMethod[index++] = payment;
        }
        return paymentMethod;
    }

    private WithholdingTax[] createWithholdingTaxArray(Entidadesdocumentos documento) {
        WithholdingTax withholdingTax = WithholdingTax.Factory.newInstance();
        withholdingTax.setWithholdingTaxType(WithholdingTaxTypeDocument.WithholdingTaxType.IRS);
        withholdingTax.setWithholdingTaxAmount(documento.getTotalretencoes().abs());
        return new WithholdingTax[]{withholdingTax};
    }

    private void createMovementOfGoods(SourceDocumentsDocument.SourceDocuments sourceDocuments) {
        SourceDocumentsDocument.SourceDocuments.MovementOfGoods movementOfGoods = sourceDocuments.addNewMovementOfGoods();
        PersistenceManager pm = this.manager.getPersistenceManager();
        for (Documentostipos tipodocumento : this.manager.getDocumentostiposCollection()) {
            if (tipodocumento.getSAFTDocumentGroup() != Documentostipos.SAFT_DOCUMENT_GROUP.MOVEMENT) continue;
            for (Entidadesdocumentos element : this.getEntidadesdocumentosCollection(tipodocumento, ISAFTExport.SAFT_TYPE.TRANSPORTES)) {
                Entidadesdocumentos documento = (Entidadesdocumentos)TABLES.entidadesdocumentos.getObject(pm, element.getKey());
                this.createStockMovement(movementOfGoods, documento);
            }
        }
        pm.close();
        BigInteger numberOfMovementLines = BigInteger.valueOf(0L);
        BigDecimal totalQuantityIssued = BigDecimal.ZERO;
        for (SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement stockMovement : movementOfGoods.getStockMovementList()) {
            numberOfMovementLines = numberOfMovementLines.add(BigInteger.valueOf(stockMovement.getLineList().size()));
            for (SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement.Line line : stockMovement.getLineList()) {
                totalQuantityIssued = totalQuantityIssued.add(line.getQuantity());
            }
        }
        movementOfGoods.setNumberOfMovementLines(numberOfMovementLines);
        movementOfGoods.setTotalQuantityIssued(totalQuantityIssued);
    }

    private void createStockMovement(SourceDocumentsDocument.SourceDocuments.MovementOfGoods movementOfGoods, Entidadesdocumentos documento) {
        Debug.out((Object)documento);
        SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement stockMovement = movementOfGoods.addNewStockMovement();
        stockMovement.setDocumentNumber(this.parseText(documento.toString(), 60));
        stockMovement.setATCUD(documento.getATCUD());
        stockMovement.setDocumentStatus(this.createStockMovementStatus(documento));
        stockMovement.setHash(documento.getHashToText());
        if (documento.isAssinado()) {
            stockMovement.setHashControl(documento.getHashcontrolToText());
        }
        stockMovement.setPeriod(TimeDateUtils.getMonth((Date)documento.getDatacriacao()) + 1);
        stockMovement.setMovementDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatacriacao()));
        stockMovement.setMovementType(this.tables.getMovementType(documento.getTipodocumento()));
        stockMovement.setSystemEntryDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatasistemaWithTime()));
        Entidades entidade = this.addEntidade(documento);
        switch (entidade.getTipoentidade().getTipoentidade()) {
            case 0: {
                stockMovement.setCustomerID(this.parseText(entidade.getKey(), 30));
                break;
            }
            case 1: {
                stockMovement.setSupplierID(this.parseText(entidade.getKey(), 30));
            }
        }
        stockMovement.setSourceID(documento.getAutor().getUser());
        if (!this.isEmpty(documento.getLocaldescargaToText())) {
            stockMovement.setShipTo(this.createShipToStructure(documento));
        }
        stockMovement.setShipFrom(this.createShipFromStructure(documento));
        stockMovement.setMovementEndTime(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatadescargaWithTime()));
        stockMovement.setMovementStartTime(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatacargaWithTime()));
        if (documento.hasDocumentcode()) {
            stockMovement.setATDocCodeID(documento.getDocumentcode());
        }
        this.createStockMovementLines(stockMovement, documento);
        stockMovement.setDocumentTotals(this.createStockMovementDocumentTotals(documento));
    }

    private SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement.DocumentStatus createStockMovementStatus(Entidadesdocumentos documento) {
        SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement.DocumentStatus documentStatus = SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement.DocumentStatus.Factory.newInstance();
        documentStatus.setMovementStatus(this.tables.getMovementStatus(documento));
        documentStatus.setMovementStatusDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatasistemaWithTime()));
        documentStatus.setSourceID(documento.getEditor().getUser());
        documentStatus.setSourceBilling(this.tables.getSourceBilling(documento));
        return documentStatus;
    }

    private void createStockMovementLines(SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement stockMovement, Entidadesdocumentos documento) {
        for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento$Tipo(1)) {
            this.createStockMovementLine(stockMovement, linha);
        }
    }

    private void createStockMovementLine(SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement stockMovement, Entidadesdocumentoslinhas linha) {
        SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement.Line line = stockMovement.addNewLine();
        line.setLineNumber(BigInteger.valueOf(linha.getNumerolinha().intValue()));
        if (linha.getLinhaorigem() != null && !linha.getDocumento().getTipodocumento().isTipodocumento(4)) {
            line.setOrderReferencesArray(this.createOrderReferencesArray(linha.getLinhaorigem()));
        }
        line.setProductCode(this.parseCode(this.addProduct(linha).getCodigo(), 60));
        line.setProductDescription(this.isEmpty(linha.getDescricaoToText()) ? "Desconhecido" : this.parseText(linha.getDescricaoToText(), 2, 200));
        line.setQuantity(linha.getQuantidade().abs());
        line.setUnitOfMeasure(this.parseText(linha.getUnidademedida().getDescricaoToText(), 20));
        BigDecimal valorliquido = BusinessRules.netValue((BigDecimal)linha.getValorliquido(), (BigDecimal)linha.getDocumento().getPercdesconto());
        line.setUnitPrice(valorliquido.divide(linha.getQuantidade(), FIELDS.entidadesdocumentoslinhas_preco.format.getSize().scale, RoundingMode.HALF_EVEN).abs());
        line.setDescription(this.isEmpty(linha.getDescricaoToText()) ? "Desconhecido" : this.parseText(linha.getDescricaoToText(), 200));
        if (!linha.getNumeroserie().isEmpty()) {
            line.setProductSerialNumber(this.createProductSerialNumber(linha));
        }
        switch (linha.getDocumento().getTipodocumento().getSAFTMovementClass()) {
            case NONE: {
                break;
            }
            case DEBIT: {
                if (valorliquido.signum() >= 0) {
                    line.setDebitAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido, RoundingMode.HALF_EVEN));
                    break;
                }
                line.setCreditAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido.abs(), RoundingMode.HALF_EVEN));
                break;
            }
            case CREDIT: {
                if (valorliquido.signum() >= 0) {
                    line.setCreditAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido, RoundingMode.HALF_EVEN));
                    break;
                }
                line.setDebitAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido.abs(), RoundingMode.HALF_EVEN));
            }
        }
        line.setTax(this.createMovementTax(linha));
        if (!linha.getCodigoiva().hasTaxa()) {
            line.setTaxExemptionReason(this.isEmpty(linha.getIsencaoiva().getArtigolegalToText()) ? this.parseText(linha.getIsencaoiva().getDescricaoToText(), 60) : this.parseText(linha.getIsencaoiva().getArtigolegalToText(), 60));
        }
        if (!linha.getCodigoiva().hasTaxa()) {
            line.setTaxExemptionCode(linha.getIsencaoiva().getMotivoAT().name());
        }
        line.setSettlementAmount(FIELDS.entidadesdocumentoslinhas_valordesconto.format.setScale(BusinessRules.netValue((BigDecimal)linha.getValordesconto(), (BigDecimal)linha.getDocumento().getPercdesconto()), RoundingMode.HALF_EVEN));
    }

    private MovementTax createMovementTax(Entidadesdocumentoslinhas linha) {
        MovementTax tax = MovementTax.Factory.newInstance();
        tax.setTaxType(this.tables.getSAFTPTMovementTaxType(this.addTaxTableEntry(linha.getCodigoiva(), linha.getDocumento().getPais())));
        tax.setTaxCountryRegion(this.tables.getTaxCountryRegion(linha.getCodigoiva(), linha.getDocumento().getPais()));
        tax.setTaxCode(this.tables.getTaxCode(linha.getCodigoiva()));
        tax.setTaxPercentage(linha.getCodigoiva().hasTaxa() ? linha.getCodigoiva().getTaxa() : BigDecimal.ZERO);
        return tax;
    }

    private SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement.DocumentTotals createStockMovementDocumentTotals(Entidadesdocumentos documento) {
        SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement.DocumentTotals documentTotals = SourceDocumentsDocument.SourceDocuments.MovementOfGoods.StockMovement.DocumentTotals.Factory.newInstance();
        documentTotals.setTaxPayable(ATMessageFormatter.getGrossTotal(documento.getTotaliva().abs()));
        documentTotals.setNetTotal(ATMessageFormatter.getGrossTotal(documento.getTotalliquido().abs()));
        documentTotals.setGrossTotal(ATMessageFormatter.getGrossTotal(documento.getTotalbruto().abs()));
        return documentTotals;
    }

    private void createWorkingDocuments(SourceDocumentsDocument.SourceDocuments sourceDocuments) {
        SourceDocumentsDocument.SourceDocuments.WorkingDocuments workingDocuments = sourceDocuments.addNewWorkingDocuments();
        PersistenceManager pm = this.manager.getPersistenceManager();
        for (Documentostipos tipodocumento : this.manager.getDocumentostiposCollection()) {
            if (tipodocumento.getSAFTDocumentGroup() != Documentostipos.SAFT_DOCUMENT_GROUP.WORKING) continue;
            for (Entidadesdocumentos element : this.getEntidadesdocumentosCollection(tipodocumento, ISAFTExport.SAFT_TYPE.CONFERENCIA)) {
                Entidadesdocumentos documento = (Entidadesdocumentos)TABLES.entidadesdocumentos.getObject(pm, element.getKey());
                this.createWorkDocument(workingDocuments, documento);
            }
        }
        pm.close();
        BigDecimal totalDebit = BigDecimal.ZERO;
        BigDecimal totalCredit = BigDecimal.ZERO;
        for (SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument workDocument : workingDocuments.getWorkDocumentList()) {
            if (workDocument.getDocumentStatus().getWorkStatus() == WorkStatusDocument.WorkStatus.A) continue;
            for (SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument.Line line : workDocument.getLineList()) {
                totalDebit = totalDebit.add(line.getDebitAmount() == null ? BigDecimal.ZERO : line.getDebitAmount());
                totalCredit = totalCredit.add(line.getCreditAmount() == null ? BigDecimal.ZERO : line.getCreditAmount());
            }
        }
        workingDocuments.setNumberOfEntries(BigInteger.valueOf(workingDocuments.sizeOfWorkDocumentArray()));
        workingDocuments.setTotalDebit(ATMessageFormatter.getGrossTotal(totalDebit));
        workingDocuments.setTotalCredit(ATMessageFormatter.getGrossTotal(totalCredit));
    }

    private void createWorkDocument(SourceDocumentsDocument.SourceDocuments.WorkingDocuments workingDocuments, Entidadesdocumentos documento) {
        Debug.out((Object)documento);
        SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument workDocument = workingDocuments.addNewWorkDocument();
        workDocument.setDocumentNumber(this.parseText(documento.toString(), 60));
        workDocument.setATCUD(documento.getATCUD());
        workDocument.setDocumentStatus(this.createWorkDocumentStatus(documento));
        workDocument.setHash(documento.getHashToText());
        if (documento.isAssinado()) {
            workDocument.setHashControl(documento.getHashcontrolToText());
        }
        workDocument.setPeriod(TimeDateUtils.getMonth((Date)documento.getDatacriacao()) + 1);
        workDocument.setWorkDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatacriacao()));
        workDocument.setWorkType(this.tables.getWorkType(documento.getTipodocumento()));
        workDocument.setSourceID(documento.getAutor().getUser());
        workDocument.setSystemEntryDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatasistemaWithTime()));
        workDocument.setCustomerID(this.parseText(this.addEntidade(documento).getKey(), 30));
        this.createWorkDocumentLines(workDocument, documento);
        workDocument.setDocumentTotals(this.createWorkDocumentTotals(documento));
    }

    private SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument.DocumentStatus createWorkDocumentStatus(Entidadesdocumentos documento) {
        SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument.DocumentStatus documentStatus = SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument.DocumentStatus.Factory.newInstance();
        documentStatus.setWorkStatus(this.tables.getWorkStatus(documento));
        documentStatus.setWorkStatusDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatasistemaWithTime()));
        documentStatus.setSourceID(documento.getEditor().getUser());
        documentStatus.setSourceBilling(this.tables.getSourceBilling(documento));
        return documentStatus;
    }

    private void createWorkDocumentLines(SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument workDocument, Entidadesdocumentos documento) {
        for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento$Tipo(1)) {
            this.createWorkDocumentLine(workDocument, linha);
        }
    }

    private void createWorkDocumentLine(SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument workDocument, Entidadesdocumentoslinhas linha) {
        SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument.Line line = workDocument.addNewLine();
        line.setLineNumber(BigInteger.valueOf(linha.getNumerolinha().intValue()));
        if (linha.getLinhaorigem() != null && !linha.getDocumento().getTipodocumento().isTipodocumento(4)) {
            line.setOrderReferencesArray(this.createOrderReferencesArray(linha.getLinhaorigem()));
        }
        line.setProductCode(this.parseCode(this.addProduct(linha).getCodigo(), 60));
        line.setProductDescription(this.isEmpty(linha.getDescricaoToText()) ? "Desconhecido" : this.parseText(linha.getDescricaoToText(), 2, 200));
        line.setQuantity(linha.getQuantidade().abs());
        line.setUnitOfMeasure(this.parseText(linha.getUnidademedida().getDescricaoToText(), 20));
        BigDecimal valorliquido = BusinessRules.netValue((BigDecimal)linha.getValorliquido(), (BigDecimal)linha.getDocumento().getPercdesconto());
        line.setUnitPrice(valorliquido.divide(linha.getQuantidade(), FIELDS.entidadesdocumentoslinhas_preco.format.getSize().scale, RoundingMode.HALF_EVEN).abs());
        line.setTaxPointDate(line.getOrderReferencesList().isEmpty() ? TimeDateUtils.getCalendarWithoutTimezone((Date)linha.getDocumento().getDatacriacao()) : ((OrderReferences)line.getOrderReferencesList().get(0)).getOrderDate());
        if (linha.getLinhaorigem() != null && linha.getDocumento().getTipodocumento().isTipodocumento(4)) {
            line.setReferencesArray(this.createReferencesArray(linha.getLinhaorigem()));
        }
        line.setDescription(this.isEmpty(linha.getDescricaoToText()) ? "Desconhecido" : this.parseText(linha.getDescricaoToText(), 200));
        if (!linha.getNumeroserie().isEmpty()) {
            line.setProductSerialNumber(this.createProductSerialNumber(linha));
        }
        switch (linha.getDocumento().getTipodocumento().getSAFTMovementClass()) {
            case NONE: {
                break;
            }
            case DEBIT: {
                if (valorliquido.signum() >= 0) {
                    line.setDebitAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido, RoundingMode.HALF_EVEN));
                    break;
                }
                line.setCreditAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido.abs(), RoundingMode.HALF_EVEN));
                break;
            }
            case CREDIT: {
                if (valorliquido.signum() >= 0) {
                    line.setCreditAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido, RoundingMode.HALF_EVEN));
                    break;
                }
                line.setDebitAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido.abs(), RoundingMode.HALF_EVEN));
            }
        }
        line.setTax(this.createTax(linha));
        if (!linha.getCodigoiva().hasTaxa()) {
            line.setTaxExemptionReason(this.isEmpty(linha.getIsencaoiva().getArtigolegalToText()) ? this.parseText(linha.getIsencaoiva().getDescricaoToText(), 60) : this.parseText(linha.getIsencaoiva().getArtigolegalToText(), 60));
        }
        if (!linha.getCodigoiva().hasTaxa()) {
            line.setTaxExemptionCode(linha.getIsencaoiva().getMotivoAT().name());
        }
        line.setSettlementAmount(FIELDS.entidadesdocumentoslinhas_valordesconto.format.setScale(BusinessRules.netValue((BigDecimal)linha.getValordesconto(), (BigDecimal)linha.getDocumento().getPercdesconto()), RoundingMode.HALF_EVEN));
    }

    private SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument.DocumentTotals createWorkDocumentTotals(Entidadesdocumentos documento) {
        SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument.DocumentTotals documentTotals = SourceDocumentsDocument.SourceDocuments.WorkingDocuments.WorkDocument.DocumentTotals.Factory.newInstance();
        documentTotals.setTaxPayable(ATMessageFormatter.getGrossTotal(documento.getTotaliva().abs()));
        documentTotals.setNetTotal(ATMessageFormatter.getGrossTotal(documento.getTotalliquido().abs()));
        documentTotals.setGrossTotal(ATMessageFormatter.getGrossTotal(documento.getTotalbruto().abs()));
        return documentTotals;
    }

    private void createPayments(SourceDocumentsDocument.SourceDocuments sourceDocuments) {
        SourceDocumentsDocument.SourceDocuments.Payments payments = sourceDocuments.addNewPayments();
        PersistenceManager pm = this.manager.getPersistenceManager();
        for (Documentostipos tipodocumento : this.manager.getDocumentostiposCollection()) {
            if (tipodocumento.getSAFTDocumentGroup() != Documentostipos.SAFT_DOCUMENT_GROUP.PAYMENT) continue;
            for (Entidadesdocumentos element : this.getEntidadesdocumentosCollection(tipodocumento, ISAFTExport.SAFT_TYPE.FACTURAS)) {
                Entidadesdocumentos documento = (Entidadesdocumentos)TABLES.entidadesdocumentos.getObject(pm, element.getKey());
                if (documento.getMovimentoorigem().isEmpty()) continue;
                this.createPayment(payments, documento);
            }
        }
        pm.close();
        BigDecimal totalDebit = BigDecimal.ZERO;
        BigDecimal totalCredit = BigDecimal.ZERO;
        for (SourceDocumentsDocument.SourceDocuments.Payments.Payment payment : payments.getPaymentList()) {
            if (payment.getDocumentStatus().getPaymentStatus() == PaymentStatusDocument.PaymentStatus.A) continue;
            for (SourceDocumentsDocument.SourceDocuments.Payments.Payment.Line line : payment.getLineList()) {
                totalDebit = totalDebit.add(line.getDebitAmount() == null ? BigDecimal.ZERO : line.getDebitAmount());
                totalCredit = totalCredit.add(line.getCreditAmount() == null ? BigDecimal.ZERO : line.getCreditAmount());
            }
        }
        payments.setNumberOfEntries(BigInteger.valueOf(payments.sizeOfPaymentArray()));
        payments.setTotalDebit(ATMessageFormatter.getGrossTotal(totalDebit));
        payments.setTotalCredit(ATMessageFormatter.getGrossTotal(totalCredit));
    }

    private void createPayment(SourceDocumentsDocument.SourceDocuments.Payments payments, Entidadesdocumentos documento) {
        Debug.out((Object)documento);
        SourceDocumentsDocument.SourceDocuments.Payments.Payment payment = payments.addNewPayment();
        payment.setPaymentRefNo(this.parseText(documento.toString(), 60));
        payment.setATCUD(documento.getATCUD());
        payment.setPeriod(TimeDateUtils.getMonth((Date)documento.getDatacriacao()) + 1);
        payment.setTransactionDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatacriacao()));
        payment.setPaymentType(this.tables.getPaymentType(documento.getTipodocumento()));
        payment.setDocumentStatus(this.createPaymentDocumentStatus(documento));
        payment.setPaymentMethodArray(this.createPaymentMethodArray(documento));
        payment.setSourceID(documento.getAutor().getUser());
        payment.setSystemEntryDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatasistemaWithTime()));
        payment.setCustomerID(this.parseText(this.addEntidade(documento).getKey(), 30));
        this.createPaymentLines(payment, documento);
        payment.setDocumentTotals(this.createPaymentDocumentTotals(documento));
        if (documento.getTotalretencoes().signum() != 0) {
            payment.setWithholdingTaxArray(this.createWithholdingTaxArray(documento));
        }
    }

    private SourceDocumentsDocument.SourceDocuments.Payments.Payment.DocumentStatus createPaymentDocumentStatus(Entidadesdocumentos documento) {
        SourceDocumentsDocument.SourceDocuments.Payments.Payment.DocumentStatus documentStatus = SourceDocumentsDocument.SourceDocuments.Payments.Payment.DocumentStatus.Factory.newInstance();
        documentStatus.setPaymentStatus(this.tables.getPaymentStatus(documento));
        documentStatus.setPaymentStatusDate(TimeDateUtils.getCalendarWithoutTimezone((Date)documento.getDatasistemaWithTime()));
        documentStatus.setSourceID(documento.getEditor().getUser());
        documentStatus.setSourcePayment(this.tables.getSourcePayment(documento));
        return documentStatus;
    }

    private void createPaymentLines(SourceDocumentsDocument.SourceDocuments.Payments.Payment payment, Entidadesdocumentos documento) {
        for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento()) {
            if (linha.getMovimentoorigem() == null) continue;
            if (payment.getPaymentType() == SAFTPTPaymentType.RC) {
                for (Entidadesdocumentosivas iva : documento.getTabelaiva()) {
                    this.createPaymentLine(payment, linha, iva);
                }
                continue;
            }
            this.createPaymentLine(payment, linha, null);
        }
    }

    private void createPaymentLine(SourceDocumentsDocument.SourceDocuments.Payments.Payment payment, Entidadesdocumentoslinhas linha, Entidadesdocumentosivas iva) {
        SourceDocumentsDocument.SourceDocuments.Payments.Payment.Line line = payment.addNewLine();
        line.setLineNumber(BigInteger.valueOf(linha.getNumerolinha().intValue()));
        line.setSourceDocumentIDArray(this.createSourceDocumentIDArray(linha));
        line.setSettlementAmount(linha.getValordesconto());
        BigDecimal valorliquido = iva == null ? linha.getValorliquido() : iva.getValorbase();
        switch (linha.getMovimentoorigem().getTipodocumento().getSAFTMovementClass()) {
            case NONE: {
                break;
            }
            case DEBIT: {
                if (valorliquido.signum() >= 0) {
                    line.setDebitAmount(valorliquido);
                    break;
                }
                line.setCreditAmount(valorliquido.abs());
                break;
            }
            case CREDIT: {
                if (valorliquido.signum() >= 0) {
                    line.setCreditAmount(valorliquido);
                    break;
                }
                line.setDebitAmount(valorliquido.abs());
            }
        }
        if (iva != null) {
            line.setTax(this.createPaymentTax(iva));
        }
    }

    private SourceDocumentsDocument.SourceDocuments.Payments.Payment.Line.SourceDocumentID[] createSourceDocumentIDArray(Entidadesdocumentoslinhas linha) {
        SourceDocumentsDocument.SourceDocuments.Payments.Payment.Line.SourceDocumentID sourceDocuments = SourceDocumentsDocument.SourceDocuments.Payments.Payment.Line.SourceDocumentID.Factory.newInstance();
        sourceDocuments.setOriginatingON(this.parseText(linha.getMovimentoorigem().toString(), 60));
        sourceDocuments.setInvoiceDate(TimeDateUtils.getCalendarWithoutTimezone((Date)linha.getMovimentoorigem().getDatacriacao()));
        sourceDocuments.setDescription(this.isEmpty(linha.getDescricaoToText()) ? "Desconhecido" : this.parseText(linha.getDescricaoToText(), 200));
        return new SourceDocumentsDocument.SourceDocuments.Payments.Payment.Line.SourceDocumentID[]{sourceDocuments};
    }

    private PaymentTax createPaymentTax(Entidadesdocumentosivas iva) {
        PaymentTax tax = PaymentTax.Factory.newInstance();
        tax.setTaxType(this.tables.getTaxType(this.addTaxTableEntry(iva.getCodigoiva(), iva.getDocumento().getPais())));
        tax.setTaxCountryRegion(this.tables.getTaxCountryRegion(iva.getCodigoiva(), iva.getDocumento().getPais()));
        tax.setTaxCode(this.tables.getTaxCode(iva.getCodigoiva()));
        tax.setTaxPercentage(iva.hasTaxa() ? iva.getTaxa() : BigDecimal.ZERO);
        return tax;
    }

    private SourceDocumentsDocument.SourceDocuments.Payments.Payment.DocumentTotals createPaymentDocumentTotals(Entidadesdocumentos documento) {
        SourceDocumentsDocument.SourceDocuments.Payments.Payment.DocumentTotals documentTotals = SourceDocumentsDocument.SourceDocuments.Payments.Payment.DocumentTotals.Factory.newInstance();
        documentTotals.setTaxPayable(ATMessageFormatter.getGrossTotal(documento.getTotaliva().abs()));
        documentTotals.setNetTotal(ATMessageFormatter.getGrossTotal(documento.getTotalliquido().abs()));
        documentTotals.setGrossTotal(ATMessageFormatter.getGrossTotal(documento.getTotalbruto().abs()));
        return documentTotals;
    }

    private SourceDocumentsDocument.SourceDocuments.Payments.Payment.DocumentTotals.Settlement createSettlement(Entidadesdocumentos documento) {
        SourceDocumentsDocument.SourceDocuments.Payments.Payment.DocumentTotals.Settlement settlement = SourceDocumentsDocument.SourceDocuments.Payments.Payment.DocumentTotals.Settlement.Factory.newInstance();
        return settlement;
    }

    private Collection<Entidadesdocumentos> getEntidadesdocumentosCollection(Documentostipos tipodocumento, ISAFTExport.SAFT_TYPE type) {
        QueryDefinition query = new QueryDefinition(TABLES.entidadesdocumentos, new QueryOrdering(QueryOrdering.DIRECTION.ASCENDING, new TableFieldKey(FIELDS.entidadesdocumentos_seriedocumento, FIELDS.documentosseries_numero), new TableFieldKey(FIELDS.entidadesdocumentos_numerodocumento)));
        query.addRule(new FilterMapRule(FIELDS.entidadesdocumentos_tipodocumento, FIELDS.documentostipos_codigo).equal(tipodocumento.getCodigo()));
        switch (type) {
            case TRANSPORTES: {
                query.addRule(new FilterMapRule(FIELDS.entidadesdocumentos_documentcode).equal(""));
            }
            case FACTURAS: 
            case CONFERENCIA: 
            case GLOBAL: {
                query.addRule(new FilterMapRule(FIELDS.entidadesdocumentos_datacriacao).biggerEqual(this.period.getStartDate()).and().smallerEqual(this.period.getEndDate()));
            }
        }
        return this.manager.getEntidadesdocumentosCollection(query);
    }
}

