/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.saft.x0101;

import java.io.File;
import java.math.BigDecimal;
import org.dma.java.util.Debug;
import org.dma.java.util.StringUtils;
import org.dma.services.vies.CheckVatHandler;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.mapper.CustomFieldFormat;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Codigospostais;
import org.projectocolibri.api.database.model.Empresa;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.xml.beans.saft.ISAFTImport;
import x0101.oecdStandardAuditFileTaxPT1.AddressStructure;
import x0101.oecdStandardAuditFileTaxPT1.AddressStructurePT;
import x0101.oecdStandardAuditFileTaxPT1.AuditFileDocument;
import x0101.oecdStandardAuditFileTaxPT1.CustomerDocument;
import x0101.oecdStandardAuditFileTaxPT1.HeaderDocument;
import x0101.oecdStandardAuditFileTaxPT1.ProductDocument;
import x0101.oecdStandardAuditFileTaxPT1.ProductTypeDocument;
import x0101.oecdStandardAuditFileTaxPT1.TaxTableDocument;
import x0101.oecdStandardAuditFileTaxPT1.TaxTableEntryDocument;

public abstract class SAFTx0101Import
implements ISAFTImport {
    private final DatabaseManager manager;
    private final boolean importHeader;
    private final boolean importTaxes;
    private final boolean importArticles;
    private final boolean importCustomers;
    private final Entidadestipos tipoentidade;
    private AuditFileDocument.AuditFile auditFile;

    public abstract void consoleOut(String var1);

    public SAFTx0101Import(DatabaseManager manager, boolean importHeader, boolean importTaxes, boolean importArticles, boolean importCustomers, String tipoentidade) {
        this.manager = manager;
        this.importHeader = importHeader;
        this.importTaxes = importTaxes;
        this.importArticles = importArticles;
        this.importCustomers = importCustomers;
        this.tipoentidade = manager.loadEntidadestipos(tipoentidade);
    }

    @Override
    public void process(File file) throws Exception {
        AuditFileDocument auditFileDocument = AuditFileDocument.Factory.parse((File)file);
        this.auditFile = auditFileDocument.getAuditFile();
        HeaderDocument.Header header = this.auditFile.getHeader();
        AuditFileDocument.AuditFile.MasterFiles masterFiles = this.auditFile.getMasterFiles();
        if (this.importHeader) {
            this.populateEmpresa(header);
        }
        if (this.importTaxes) {
            this.populateIVA(masterFiles);
        }
        if (this.importArticles) {
            this.populateArtigos(masterFiles);
        }
        if (this.importCustomers) {
            this.populateClientes(masterFiles);
        }
    }

    @Override
    public boolean isValid() {
        return this.auditFile != null && this.auditFile.validate();
    }

    private void populateEmpresa(HeaderDocument.Header header) throws Exception {
        Empresa empresa = this.manager.getEmpresa();
        if (!header.getCompanyID().isEmpty() && header.getCompanyID().contains(" ")) {
            String[] companyId = header.getCompanyID().split(" ");
            empresa.setConservatoria(this.parse(companyId[0]));
            empresa.setRegistocomercial(this.parse(companyId[1]));
        }
        empresa.setNif(String.valueOf(header.getTaxRegistrationNumber()));
        empresa.setNome(this.parse(header.getCompanyName()));
        AddressStructurePT companyAddress = header.getCompanyAddress();
        empresa.setMorada(this.parse(companyAddress.getAddressDetail()));
        empresa.setLocalidade(this.parse(companyAddress.getCity()));
        empresa.setCodigopostal(this.storeCodigospostais(companyAddress.getPostalCode(), companyAddress.getCity()));
        empresa.setTelefone(this.parse(header.getTelephone()));
        empresa.setFax(this.parse(header.getFax()));
        empresa.setEmail(this.parse(header.getEmail()));
        empresa.setUrl(this.parse(header.getWebsite()));
        Debug.out((Object)empresa);
        this.manager.storeEmpresa(empresa);
        this.consoleOut("Empresa: " + empresa.getNome() + " criada");
    }

    private void populateIVA(AuditFileDocument.AuditFile.MasterFiles masterFiles) throws Exception {
        for (TaxTableDocument.TaxTable taxTable : masterFiles.getTaxTableList()) {
            for (TaxTableEntryDocument.TaxTableEntry taxTableEntry : taxTable.getTaxTableEntryList()) {
                this.storeCodigosiva(this.parse(taxTableEntry.getTaxCode()), this.parse(taxTableEntry.getDescription()), taxTableEntry.getTaxPercentage(), this.getTipotaxa(taxTableEntry.getTaxCode()), this.getEspacofiscal(taxTableEntry.getTaxCountryRegion()));
            }
        }
    }

    private int getTipotaxa(String codigo) throws Exception {
        if (codigo.equals("NOR")) {
            return 0;
        }
        if (codigo.equals("RED")) {
            return 1;
        }
        if (codigo.equals("INT")) {
            return 2;
        }
        if (codigo.equals("ISE")) {
            return 3;
        }
        return 4;
    }

    private int getEspacofiscal(String codigo) throws Exception {
        if (codigo.equals(CheckVatHandler.COUNTRIES.PT.code)) {
            return 0;
        }
        if (codigo.equals("PT-MA")) {
            return 1;
        }
        if (codigo.equals("PT-AC")) {
            return 2;
        }
        return 3;
    }

    private void populateArtigos(AuditFileDocument.AuditFile.MasterFiles masterFiles) throws Exception {
        for (ProductDocument.Product product : masterFiles.getProductList()) {
            if (this.manager.existsArtigos(product.getProductCode())) continue;
            Artigos artigo = new Artigos(this.manager, this.parse(product.getProductCode()), this.parse(product.getProductDescription()));
            artigo.addUnidades();
            artigo.addPrecos();
            artigo.setTipo(this.getTipoartigo(product.getProductType()));
            artigo.setFamilia(this.storeFamilias(product.getProductGroup(), product.getProductGroup()));
            if (!product.getProductNumberCode().equals(product.getProductCode())) {
                artigo.getUnidades(0).setCodigobarras(this.parse(product.getProductNumberCode()));
            }
            Debug.out((Object)artigo);
            this.manager.storeArtigos(artigo, new MethodCallback[0]);
            this.consoleOut("Artigo: " + artigo.getDescricao() + " criado");
        }
    }

    private int getTipoartigo(ProductTypeDocument.ProductType.Enum productType) throws Exception {
        switch (productType.intValue()) {
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    private void populateClientes(AuditFileDocument.AuditFile.MasterFiles masterFiles) throws Exception {
        for (CustomerDocument.Customer customer : masterFiles.getCustomerList()) {
            Entidades entidade = new Entidades(this.manager, this.tipoentidade.getCodigo());
            entidade.setNif(this.parse(customer.getCustomerTaxID()));
            entidade.setNome(this.parse(customer.getCompanyName()));
            entidade.setResponsavel(this.parse(customer.getContact()));
            AddressStructure addressStructure = customer.getBillingAddress();
            entidade.setMorada(this.parse(addressStructure.getAddressDetail()));
            entidade.setCodigopostal(this.storeCodigospostais(addressStructure.getPostalCode(), addressStructure.getCity()));
            entidade.setLocalidade(this.parse(addressStructure.getCity()));
            entidade.setPais(this.storePaises(addressStructure.getCountry(), addressStructure.getCountry()));
            entidade.setTelefone(this.parse(customer.getTelephone()));
            entidade.setFax(this.parse(customer.getFax()));
            entidade.setEmail(this.parse(customer.getEmail()));
            entidade.setUrl(this.parse(customer.getWebsite()));
            Debug.out((Object)entidade);
            this.manager.storeEntidades(entidade, new MethodCallback[0]);
            this.consoleOut("Cliente: " + entidade.getNome() + " criado");
        }
    }

    private Codigospostais storeCodigospostais(String codigo, String descricao) throws Exception {
        if (!this.manager.existsCodigospostais(codigo)) {
            Codigospostais codigopostal = new Codigospostais(this.manager, this.parse(codigo), this.parse(descricao));
            Debug.out((Object)codigopostal);
            this.manager.storeCodigospostais(codigopostal);
        }
        return this.manager.loadCodigospostais(codigo);
    }

    private Paises storePaises(String codigo, String descricao) throws Exception {
        if (!this.manager.existsPaises(codigo)) {
            Paises pais = new Paises(this.manager, this.parse(codigo), this.parse(descricao));
            Debug.out((Object)pais);
            this.manager.storePaises(pais);
        }
        return this.manager.loadPaises(codigo);
    }

    private Familias storeFamilias(String codigo, String descricao) throws Exception {
        if (!this.manager.existsFamilias(codigo)) {
            Familias familia = new Familias(this.manager, 0, this.parse(codigo), this.parse(descricao));
            Debug.out((Object)familia);
            this.manager.storeFamilias(familia);
        }
        return this.manager.loadFamilias(codigo);
    }

    private Codigosiva storeCodigosiva(String codigo, String descricao, BigDecimal taxa, int tipotaxa, int espacofiscal) throws Exception {
        if (!this.manager.existsCodigosiva(codigo)) {
            Codigosiva codigoiva = new Codigosiva(this.manager, this.parse(codigo), this.parse(descricao), tipotaxa, espacofiscal, taxa);
            Debug.out((Object)codigoiva);
            this.manager.storeCodigosiva(codigoiva);
        }
        return this.manager.loadCodigosiva(codigo);
    }

    private String parse(String string) throws Exception {
        return string == null ? "" : StringUtils.removeAll((String)string, (char[])CustomFieldFormat.EXCLUDE_CHARS);
    }
}

