/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.saft;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import org.dma.java.io.CustomFile;
import org.dma.java.io.FileParameters;
import org.dma.java.time.CalendarPeriod;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.xml.beans.XMLTextParser;
import org.projectocolibri.xml.beans.saft.ISAFTExport;

public abstract class AbstractSAFTExport
extends XMLTextParser
implements ISAFTExport {
    protected final ISAFTExport.SAFT_VERSIONS version;
    protected final DatabaseManager manager;
    protected final CalendarPeriod period;

    public AbstractSAFTExport(ISAFTExport.SAFT_VERSIONS version, DatabaseManager manager, CalendarPeriod period) {
        this.version = version;
        this.manager = manager;
        this.period = period;
    }

    @Override
    public FileParameters getFileParameters(File folder) {
        return this.version.getFileParameters(folder, this.manager.getEmpresa().getNifToInteger(), this.period);
    }

    public MessageList export(ISAFTExport.SAFT_TYPE type, OutputStream stream) {
        MessageList error = new MessageList();
        if (stream != null) {
            try {
                this.process(type);
            }
            catch (Exception e) {
                error.add((Throwable)e);
            }
        }
        if (!this.save(stream)) {
            error.add((Object)new MessageLine((Object)LABELS.erro_ficheiro_gravar));
        } else if (this.isEmpty()) {
            error.add((Object)new MessageLine((Object)LABELS.erro_ficheiro_vazio));
        } else if (!this.isValid()) {
            error.add((Object)new MessageLine((Object)LABELS.erro_ficheiro_invalido));
        }
        return error;
    }

    @Override
    public MessageList export(ISAFTExport.SAFT_TYPE type, File file) {
        if (!file.isDirectory()) {
            try {
                return this.export(type, new CustomFile(file).asOutputStream());
            }
            catch (FileNotFoundException e) {
                return new MessageList((Throwable)e);
            }
        }
        return this.export(type, (File)this.getFileParameters(file).toFile());
    }

    public boolean save(File file) {
        if (!file.isDirectory()) {
            try {
                return this.save(new CustomFile(file).asOutputStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }
        return this.save((File)this.getFileParameters(file).toFile());
    }
}

