/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.licencas;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import org.dma.java.math.NumericUtils;
import org.dma.java.util.TimeDateUtils;

public class LimiteFacturacao {
    private final BigDecimal valor;
    private final Calendar data;

    public LimiteFacturacao(BigDecimal valor) {
        this(valor, null);
    }

    public LimiteFacturacao(BigDecimal valor, Calendar data) {
        this.valor = valor;
        this.data = data;
    }

    public boolean isValid(BigDecimal valor) {
        boolean valid;
        boolean bl = valid = this.valor.signum() == 0 || NumericUtils.isLesserOrEqual((BigDecimal)valor, (BigDecimal)this.valor);
        return this.data == null ? valid : valid || TimeDateUtils.getCalendarWithoutTime().before(this.data);
    }

    public String toString() {
        return String.valueOf(new DecimalFormat("#,###").format(this.valor)) + " Euros";
    }
}

