/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.empresas;

import java.io.File;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseParameters;
import org.projectocolibri.xml.beans.XmlDatabase;
import org.projectocolibri.xml.beans.empresas.EmpresaContainer;
import org.projectocolibri.xml.beans.empresas.EmpresasXmlDatabase;
import org.projectocolibri.xml.empresas.EmpresaDocument;

public final class ColibriEmpresa
extends EmpresaContainer {
    private static XmlDatabase<EmpresaDocument.Empresa> database;

    public static XmlDatabase<EmpresaDocument.Empresa> getDatabase() {
        if (database == null) {
            database = new EmpresasXmlDatabase((File)Colibri.FILES.DATABASES.EMPRESAS.parameters.toFile());
        }
        if (database.getCollection().size() == 0) {
            database.save((Object)new ColibriEmpresa().xml);
        }
        return database;
    }

    public static boolean isH2Embedded() {
        for (EmpresaDocument.Empresa empresa : ColibriEmpresa.getDatabase().getCollection()) {
            DatabaseParameters parameters = new DatabaseParameters(empresa);
            if (parameters.isH2Embedded()) continue;
            return false;
        }
        return true;
    }

    private static EmpresaDocument.Empresa create(String nome, DatabaseParameters params) {
        EmpresaDocument.Empresa.Dbcolibri dbcolibri = EmpresaDocument.Empresa.Dbcolibri.Factory.newInstance();
        try {
            dbcolibri.setDriver(params.driver.name());
            dbcolibri.setHost(params.host);
            dbcolibri.setDatabase(params.database);
            dbcolibri.setProperties(params.properties);
            dbcolibri.setUtilizador(params.username);
            dbcolibri.setPassword(Colibri.PASSWORD_CIPHER.encode(params.password));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ColibriEmpresa.create(nome, dbcolibri);
    }

    private static EmpresaDocument.Empresa create(String nome, EmpresaDocument.Empresa.Dbcolibri dbcolibri) {
        EmpresaDocument.Empresa empresa = EmpresaDocument.Empresa.Factory.newInstance();
        try {
            empresa.setNome(nome);
            empresa.setObs("");
            empresa.setData(TimeDateUtils.getCalendarWithoutTimezone());
            empresa.setDbcolibri(dbcolibri);
            return empresa;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ColibriEmpresa() {
        super(ColibriEmpresa.create("H2 Integrado", new DatabaseParameters()));
    }
}

