/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.ciuspt;

import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Metodospagamento;
import org.projectocolibri.xml.beans.XMLTextParser;
import org.projectocolibri.xml.beans.saft.ISAFTExport;

public class UBL21Tables
extends XMLTextParser {
    public static String getTaxCategory(Codigosiva codigoiva) {
        switch (codigoiva.getTipotaxa()) {
            case 0: {
                return "NOR";
            }
            case 1: {
                return "RED";
            }
            case 2: {
                return "INT";
            }
            case 3: {
                return "ISE";
            }
            case 4: {
                return "OUT";
            }
            case 5: {
                return "NA";
            }
        }
        return null;
    }

    public static String getPaymentMeansCode(Metodospagamento metodopagamento) {
        return ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getPaymentMechanism(metodopagamento).toString();
    }

    public static enum UNECERec20 {
        PIECE("H87"),
        UNIT("XUN"),
        BULK_PACK("AB"),
        TEN_PACK("TP"),
        DOZEN("DZN"),
        KILOGRAM("KGM"),
        MILLIMETRE("MMT"),
        CENTIMETRE("CMT"),
        DECIMETRE("DMT"),
        METRE("MTR"),
        SQUARE_METRE("MTK"),
        CUBIC_METRE("MTQ"),
        LITRE("LTR"),
        HOUR("HUR"),
        DAY("DAY");

        public String code;

        private UNECERec20(String code) {
            this.code = code;
        }
    }
}

