/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.xml.beans.ciuspt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.LinkedHashMap;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.AllowanceChargeType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.DocumentReferenceType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.InvoiceLineType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.ItemIdentificationType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.ItemPropertyType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.ItemType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.OrderReferenceType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.PriceType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.ProjectReferenceType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.TaxCategoryType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.AccountingCostType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.AllowanceChargeReasonCodeType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.AllowanceChargeReasonType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.AmountType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.ChargeIndicatorType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.DocumentDescriptionType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.DocumentStatusCodeType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.DueDateType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.IDType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.InvoiceTypeCodeType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.InvoicedQuantityType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.LineExtensionAmountType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.NameType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.NoteType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.PercentType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.PriceAmountType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.ValueType;
import oasisNamesSpecificationUblSchemaXsdInvoice2.InvoiceDocument;
import oasisNamesSpecificationUblSchemaXsdInvoice2.InvoiceType;
import org.apache.xmlbeans.XmlOptions;
import org.dma.java.io.CustomFile;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentosivas;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.TabelaivaMap;
import org.projectocolibri.xml.beans.ciuspt.AdditionalFieldMap;
import org.projectocolibri.xml.beans.ciuspt.AdditionalProperty;
import org.projectocolibri.xml.beans.ciuspt.CIUS21Export;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;

public class InvoiceExport
extends CIUS21Export {
    private final InvoiceDocument invoiceDocument = InvoiceDocument.Factory.newInstance();
    private final InvoiceType invoice = this.invoiceDocument.addNewInvoice();

    public InvoiceExport(Entidadesdocumentos documento) {
        super(documento);
    }

    @Override
    public void process() throws Exception {
        this.createCustomizationID();
        this.createAdditionalProperties();
        CIUS21Export.ADDITIONAL_DOCUMENT_REFERENCE_TYPE[] aDDITIONAL_DOCUMENT_REFERENCE_TYPEArray = CIUS21Export.ADDITIONAL_DOCUMENT_REFERENCE_TYPE.values();
        int n = aDDITIONAL_DOCUMENT_REFERENCE_TYPEArray.length;
        int n2 = 0;
        while (n2 < n) {
            CIUS21Export.ADDITIONAL_DOCUMENT_REFERENCE_TYPE type = aDDITIONAL_DOCUMENT_REFERENCE_TYPEArray[n2];
            this.createAdditionalDocumentReference(type);
            ++n2;
        }
        this.createAccountingSupplierParty(this.invoice.addNewAccountingSupplierParty());
        this.createAccountingCustomerParty(this.invoice.addNewAccountingCustomerParty());
        this.createDelivery(this.invoice.addNewDelivery());
        this.createPaymentMeans(this.invoice.addNewPaymentMeans());
        this.createPaymentTerms(this.invoice.addNewPaymentTerms());
        if (this.documento.getPercdesconto().signum() > 0) {
            this.createAllowanceCharge();
        }
        this.createTaxTotal(this.invoice.addNewTaxTotal());
        this.createLegalMonetaryTotal(this.invoice.addNewLegalMonetaryTotal());
        this.createInvoiceLines();
    }

    public boolean save(OutputStream stream) {
        if (this.manager.getLicenca().allows(Colibri.FUNCIONALIDADES.FACTURACAO_ELECTRONICA)) {
            try {
                XmlOptions options = new XmlOptions();
                options.setSavePrettyPrint();
                options.setUseDefaultNamespace();
                options.setSaveAggressiveNamespaces();
                options.setCharacterEncoding(CustomFile.UTF8_CHARSET.name());
                LinkedHashMap<String, String> prefixes = new LinkedHashMap<String, String>();
                prefixes.put("urn:oasis:names:specification:ubl:schema:xsd:Invoice-2", "");
                prefixes.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
                prefixes.put("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "cbc");
                prefixes.put("urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2", "cac");
                options.setSaveSuggestedPrefixes(prefixes);
                this.invoiceDocument.save(stream, options);
                stream.close();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean save(File file) {
        if (!file.isDirectory()) {
            try {
                return this.save(new CustomFile(file).asOutputStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }
        return this.save((File)this.getFileParameters(file).toFile());
    }

    public boolean isEmpty() {
        return this.invoice.getInvoiceLineList().isEmpty();
    }

    public boolean isValid() {
        return this.invoice.validate();
    }

    private void createCustomizationID() {
        this.createCustomizationID(this.invoice.addNewCustomizationID(), this.invoice.addNewID(), this.invoice.addNewIssueDate(), this.invoice.addNewDocumentCurrencyCode());
        InvoiceTypeCodeType invoiceTypeCodeType = this.invoice.addNewInvoiceTypeCode();
        invoiceTypeCodeType.setListID("UNCL1001");
        invoiceTypeCodeType.setStringValue("380");
        DueDateType dueDateType = this.invoice.addNewDueDate();
        dueDateType.setCalendarValue(TimeDateUtils.getCalendarWithoutTimezone((Date)this.documento.getDatavencimento()));
    }

    private void createAdditionalProperties() {
        DocumentReferenceType documentReferenceType;
        IDType idType;
        AdditionalProperty property2;
        AdditionalFieldMap additionalFieldMap = new AdditionalFieldMap(this.documento);
        if (additionalFieldMap.containsKey(5)) {
            property2 = additionalFieldMap.get(5).get(0);
            ProjectReferenceType projectReferenceType = this.invoice.addNewProjectReference();
            idType = projectReferenceType.addNewID();
            idType.setStringValue(property2.getValue());
        }
        if (additionalFieldMap.containsKey(4)) {
            property2 = additionalFieldMap.get(4).get(0);
            documentReferenceType = this.invoice.addNewContractDocumentReference();
            idType = documentReferenceType.addNewID();
            idType.setStringValue(property2.getValue());
        }
        if (additionalFieldMap.containsKey(6)) {
            property2 = additionalFieldMap.get(6).get(0);
            OrderReferenceType orderReferenceType = this.invoice.addNewOrderReference();
            idType = orderReferenceType.addNewID();
            idType.setStringValue(property2.getValue());
        }
        if (additionalFieldMap.containsKey(3)) {
            property2 = additionalFieldMap.get(3).get(0);
            documentReferenceType = this.invoice.addNewOriginatorDocumentReference();
            idType = documentReferenceType.addNewID();
            idType.setStringValue(property2.getValue());
        }
        if (additionalFieldMap.containsKey(2)) {
            property2 = additionalFieldMap.get(2).get(0);
            AccountingCostType accountingCostType = this.invoice.addNewAccountingCost();
            accountingCostType.setStringValue(property2.getValue());
        }
        for (AdditionalProperty property2 : additionalFieldMap.get(1)) {
            NoteType noteType = this.invoice.addNewNote();
            noteType.setStringValue(property2.toString());
        }
    }

    private void createAdditionalDocumentReference(CIUS21Export.ADDITIONAL_DOCUMENT_REFERENCE_TYPE type) throws Exception {
        DocumentReferenceType documentReferenceType = this.invoice.addNewAdditionalDocumentReference();
        IDType IDType2 = documentReferenceType.addNewID();
        IDType2.setSchemeID(type.schemeID);
        switch (type) {
            case PDF: {
                IDType2.setStringValue(this.parseText(this.documento.toString(), 50));
                break;
            }
            case QRCODE: {
                IDType2.setStringValue(this.parseText(this.documento.getATCUD(), 50));
            }
        }
        switch (type) {
            case PDF: {
                DocumentStatusCodeType documentStatusCodeType = documentReferenceType.addNewDocumentStatusCode();
                documentStatusCodeType.setListID("UNCL1001");
                documentStatusCodeType.setStringValue("130");
                break;
            }
        }
        DocumentDescriptionType documentDescriptionType = documentReferenceType.addNewDocumentDescription();
        switch (type) {
            case PDF: {
                documentDescriptionType.setStringValue("INVOICE_REPRESENTATION");
                break;
            }
            case QRCODE: {
                documentDescriptionType.setStringValue("QR_CODE");
            }
        }
        this.createEmbeddedAttachment(type, documentReferenceType);
    }

    private void createAllowanceCharge() {
        for (Entidadesdocumentosivas iva : new TabelaivaMap(this.documento).values()) {
            this.createAllowanceCharge(this.invoice.addNewAllowanceCharge(), iva);
        }
    }

    private void createInvoiceLines() {
        for (Entidadesdocumentoslinhas linha : this.documento.getLinhasdocumento$Tipo(1)) {
            InvoiceLineType invoiceLineType = this.invoice.addNewInvoiceLine();
            IDType IDType2 = invoiceLineType.addNewID();
            IDType2.setStringValue(this.parseText(linha.getNumerolinhaToText(), 50));
            InvoicedQuantityType invoicedQuantityType = invoiceLineType.addNewInvoicedQuantity();
            BigDecimal quantidade = linha.getPreco().signum() < 0 ? linha.getQuantidade().negate() : linha.getQuantidade();
            invoicedQuantityType.setBigDecimalValue(quantidade.setScale(3, RoundingMode.HALF_EVEN));
            invoicedQuantityType.setUnitCode(linha.getUnidademedida().getUnecerec20());
            LineExtensionAmountType lineExtensionAmountType = invoiceLineType.addNewLineExtensionAmount();
            lineExtensionAmountType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(linha.getValorliquido()));
            lineExtensionAmountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
            this.createAllowanceChargeLine(invoiceLineType, linha);
            this.createItem(invoiceLineType, linha);
            this.createPrice(invoiceLineType, linha);
        }
    }

    private void createAllowanceChargeLine(InvoiceLineType invoiceLineType, Entidadesdocumentoslinhas linha) {
        if (linha.getValordesconto().signum() != 0) {
            AllowanceChargeType allowanceChargeType = invoiceLineType.addNewAllowanceCharge();
            ChargeIndicatorType chargeIndicatorType = allowanceChargeType.addNewChargeIndicator();
            chargeIndicatorType.setBooleanValue(false);
            AllowanceChargeReasonCodeType allowanceChargeReasonCodeType = allowanceChargeType.addNewAllowanceChargeReasonCode();
            allowanceChargeReasonCodeType.setListID("UNCL5189");
            allowanceChargeReasonCodeType.setStringValue("104");
            AllowanceChargeReasonType allowanceChargeReasonType = allowanceChargeType.addNewAllowanceChargeReason();
            allowanceChargeReasonType.setStringValue("Standart Discount");
            AmountType amountType = allowanceChargeType.addNewAmount();
            amountType.setBigDecimalValue(ATMessageFormatter.getGrossTotal(linha.getValordesconto()));
            amountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
        }
    }

    private void createItem(InvoiceLineType invoiceLineType, Entidadesdocumentoslinhas linha) {
        ItemType itemType = invoiceLineType.addNewItem();
        NameType nameType = itemType.addNewName();
        nameType.setStringValue(this.isEmpty(linha.getDescricaoToText()) ? "Desconhecido" : this.parseText(linha.getDescricaoToText(), 2, 200));
        if (linha.hasArtigo()) {
            ItemIdentificationType itemSellersIdentificationType = itemType.addNewSellersItemIdentification();
            IDType IDType2 = itemSellersIdentificationType.addNewID();
            IDType2.setStringValue(this.parseCode(linha.getArtigo().getCodigo(), 50));
            for (AdditionalProperty property : new AdditionalFieldMap(linha.getArtigo()).get(1)) {
                this.createAdditionalItemProperty(itemType, property);
            }
        }
        this.createTaxCategory(itemType, linha);
        for (AdditionalProperty property : new AdditionalFieldMap(linha).get(1)) {
            this.createAdditionalItemProperty(itemType, property);
        }
    }

    private void createTaxCategory(ItemType itemType, Entidadesdocumentoslinhas linha) {
        TaxCategoryType taxCategoryType = itemType.addNewClassifiedTaxCategory();
        IDType IDType2 = taxCategoryType.addNewID();
        IDType2.setStringValue(InvoiceExport.getTaxCategory(linha.getCodigoiva()));
        PercentType percentType = taxCategoryType.addNewPercent();
        percentType.setBigDecimalValue(linha.getCodigoiva().getTaxa());
        this.createTaxScheme(taxCategoryType.addNewTaxScheme());
    }

    private void createAdditionalItemProperty(ItemType itemType, AdditionalProperty property) {
        ItemPropertyType itemPropertyType = itemType.addNewAdditionalItemProperty();
        NameType nameType = itemPropertyType.addNewName();
        nameType.setStringValue(property.getName());
        ValueType valueType = itemPropertyType.addNewValue();
        valueType.setStringValue(property.getValue());
    }

    private void createPrice(InvoiceLineType invoiceLineType, Entidadesdocumentoslinhas linha) {
        PriceType priceType = invoiceLineType.addNewPrice();
        PriceAmountType priceAmountType = priceType.addNewPriceAmount();
        priceAmountType.setBigDecimalValue(FIELDS.entidadesdocumentoslinhas_preco.format.setScale(linha.getPreco().abs(), RoundingMode.HALF_EVEN));
        priceAmountType.setCurrencyID(this.manager.getParametros().getMoeda().getCodigo());
    }
}

