/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.support.printer;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.dma.java.io.UTF8INIConfiguration;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.Colibri;

public class PrinterList
extends ArrayList<PrinterConfig> {
    private static final long serialVersionUID = 1L;
    private static PrinterList instance;

    public static PrinterList getInstance() {
        if (instance == null) {
            instance = new PrinterList(Colibri.FILES.CONFIG.PRINTERS.pathname);
        }
        return instance;
    }

    private PrinterList(String url) {
        try {
            UTF8INIConfiguration reader = new UTF8INIConfiguration();
            reader.load(url);
            for (String name : reader.getSections()) {
                if (name == null) continue;
                SubnodeConfiguration node = reader.getSection(name);
                String[] drawer = node.getStringArray("drawer");
                PrinterConfig config = new PrinterConfig(name, drawer);
                System.out.println(config);
                this.add(config);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] names() {
        String[] names = new String[this.size()];
        int index = 0;
        for (PrinterConfig config : this) {
            names[index++] = config.name;
        }
        return names;
    }

    public static class PrinterConfig {
        public final String name;
        public final byte[] drawer;

        private static byte[] val(String ... sequence) {
            byte[] val = new byte[sequence.length];
            int index = 0;
            String[] stringArray = sequence;
            int n = sequence.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                val[index++] = (byte)StringUtils.val((String)code);
                ++n2;
            }
            return val;
        }

        public PrinterConfig(String name, String ... sequence) {
            this(name, PrinterConfig.val(sequence));
        }

        public PrinterConfig(String name, byte[] drawer) {
            this.name = name;
            this.drawer = drawer;
        }

        public String toString() {
            return String.valueOf(this.name) + " " + Arrays.toString(this.drawer);
        }
    }
}

