/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.support;

import io.nayuki.qrcodegen.QrCode;
import io.nayuki.qrcodegen.QrSegment;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class QRCodeEncoder {
    public static final int AUTOMATIC_MASK = -1;

    public static QrCode encodeText(String text, int minVersion, QrCode.Ecc ecl) {
        return QRCodeEncoder.encodeText(text, minVersion, -1, ecl);
    }

    public static QrCode encodeText(String text, int minVersion, int mask, QrCode.Ecc ecl) {
        List segs = QrSegment.makeSegments((String)text);
        return QRCodeEncoder.encodeSegments(segs, minVersion, mask, ecl);
    }

    public static QrCode encodeBinary(String text, int minVersion, QrCode.Ecc ecl) {
        return QRCodeEncoder.encodeBinary(text, minVersion, -1, ecl);
    }

    public static QrCode encodeBinary(String text, int minVersion, int mask, QrCode.Ecc ecl) {
        QrSegment seg = QrSegment.makeBytes((byte[])text.getBytes(StandardCharsets.UTF_8));
        return QRCodeEncoder.encodeSegments(Arrays.asList(seg), minVersion, mask, ecl);
    }

    public static QrCode encodeBinary(byte[] data, int minVersion, QrCode.Ecc ecl) {
        return QRCodeEncoder.encodeBinary(data, minVersion, -1, ecl);
    }

    public static QrCode encodeBinary(byte[] data, int minVersion, int mask, QrCode.Ecc ecl) {
        QrSegment seg = QrSegment.makeBytes((byte[])data);
        return QRCodeEncoder.encodeSegments(Arrays.asList(seg), minVersion, mask, ecl);
    }

    public static QrCode encodeSegments(List<QrSegment> segs, int minVersion, int mask, QrCode.Ecc ecl) {
        return QrCode.encodeSegments(segs, (QrCode.Ecc)ecl, (int)minVersion, (int)40, (int)mask, (boolean)false);
    }
}

