/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.support;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import org.dma.java.util.RandomValue;
import org.projectocolibri.api.Colibri;

public final class AccessPassword {
    private static final Collection<String> PASSWORDS = new HashSet<String>();
    private static AccessPassword instance;
    private final String password;

    public static AccessPassword getInstance(int length) {
        if (instance == null) {
            instance = new AccessPassword(length);
        }
        return instance;
    }

    private AccessPassword(int length) {
        Calendar calendar = Calendar.getInstance();
        long seed = calendar.get(1) * calendar.get(6);
        this.password = new RandomValue(seed).numbers(length);
    }

    public String toString() {
        switch (Colibri.VERSION_TYPE) {
            case INTERNAL: 
            case SERVER: {
                return this.password;
            }
        }
        return "";
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccessPassword) {
            return this.equals((AccessPassword)obj);
        }
        return this.equals(obj.toString());
    }

    public boolean equals(AccessPassword other) {
        return this.equals(other.password);
    }

    public boolean equals(String password) {
        if (!password.isEmpty() && Colibri.VERSION_TYPE != Colibri.VERSIONS.SERVER) {
            PASSWORDS.add(password);
        }
        return PASSWORDS.size() <= 3 && this.password.equals(password);
    }
}

