/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.remote.updates;

import java.util.Arrays;
import org.dma.java.io.UTF8URLTextFile;
import org.dma.java.util.Debug;
import org.dma.java.util.MatchList;
import org.dma.java.util.VersionNumber;
import org.projectocolibri.api.Colibri;

public class UpdateFileHeader
extends MatchList {
    private static final long serialVersionUID = 1L;
    public final VersionNumber version;
    public final UTF8URLTextFile readme;

    public UpdateFileHeader(VersionNumber version, UTF8URLTextFile readme, String ... array) {
        super(Arrays.asList(array));
        this.version = version;
        this.readme = readme;
    }

    public boolean contains(String nif) {
        Debug.err((String)"nif", (Object)nif);
        return this.isEmpty() || super.contains((Object)nif);
    }

    @Deprecated
    boolean needsUpdate() {
        return Colibri.VERSION_NUMBER.smallerThan(this.version);
    }

    public String getReadme() {
        String text = this.readme == null ? "" : this.readme.read();
        return text.isEmpty() ? Colibri.FILES.MESSAGES.REMOTE_UPDATES.text : text;
    }

    public String toString() {
        return "version = " + this.version + "\nreadme = " + this.readme + "\nnif = " + super.toString();
    }
}

