/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.remote.control;

import org.dma.java.io.URLFile;
import org.dma.java.io.UTF8URLTextFile;
import org.dma.java.util.SystemUtils;
import org.projectocolibri.api.Colibri;

public class RemoteAssistanceSection {
    public final UTF8URLTextFile readme;
    public final URLFile windows;
    public final URLFile linux;
    public final URLFile mac;

    public RemoteAssistanceSection(UTF8URLTextFile readme, URLFile windows, URLFile linux, URLFile mac) {
        this.readme = readme;
        this.windows = windows;
        this.linux = linux;
        this.mac = mac;
    }

    public URLFile getDownloadURL() {
        if (SystemUtils.IS_OS_LINUX) {
            return this.linux;
        }
        if (SystemUtils.IS_OS_MAC) {
            return this.mac;
        }
        return this.windows;
    }

    public String getReadme() {
        String text = this.readme == null ? "" : this.readme.read();
        return text.isEmpty() ? Colibri.FILES.MESSAGES.REMOTE_ASSISTANCE.text : text;
    }
}

