/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.remote;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.dma.java.io.UTF8INIConfiguration;
import org.dma.java.util.Debug;

public abstract class RemoteFileHandler
extends UTF8INIConfiguration {
    public abstract void reset();

    public abstract void loadSections();

    public abstract void saveSections();

    public RemoteFileHandler(File file) {
        try {
            this.setFile(file);
        }
        catch (Exception exception) {}
    }

    public void load() {
        File file = this.getFile();
        if (file != null) {
            try {
                Debug.out((Object)file);
                this.clear();
                this.setDelimiterParsingDisabled(false);
                super.load();
                this.loadSections();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public void load(InputStream in) {
        if (in != null) {
            try {
                this.clear();
                this.setDelimiterParsingDisabled(false);
                super.load(in);
                this.loadSections();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public void save() {
        File file = this.getFile();
        if (file != null) {
            try {
                Debug.out((Object)file);
                this.setDelimiterParsingDisabled(true);
                this.saveSections();
                super.save();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public void save(OutputStream out) {
        if (out != null) {
            try {
                this.setDelimiterParsingDisabled(true);
                this.saveSections();
                super.save(out);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public String toText() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.save(out);
            return out.toString(this.charset().name());
        }
        catch (Exception e) {
            System.err.println(e);
            return "";
        }
    }
}

