/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core.remote;

import java.io.File;
import org.dma.eclipse.core.jobs.CustomJob;
import org.dma.eclipse.core.jobs.MutexRule;
import org.dma.eclipse.core.jobs.UIAction;
import org.dma.java.io.AbstractURLFileCopy;
import org.dma.java.io.URLFile;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.projectocolibri.api.language.LABELS;

public abstract class RemoteDownloadJob
extends CustomJob {
    private static final MutexRule RULE = new MutexRule();
    private boolean result;

    public abstract void error();

    public abstract void done();

    public RemoteDownloadJob(final URLFile src, final File dst) {
        super(LABELS.operacao_remota_download.toString());
        this.addTask((IAction)new Action(src.getName()){

            private boolean download() {
                try {
                    new AbstractURLFileCopy(src){

                        public boolean cancel() {
                            return RemoteDownloadJob.this.isCanceled();
                        }
                    }.to(dst);
                    return true;
                }
                catch (Exception e) {
                    System.err.println(e);
                    return false;
                }
            }

            public void run() {
                RemoteDownloadJob.this.result = this.download();
            }
        }).addTask((IAction)new UIAction(){

            public void run() {
                if (RemoteDownloadJob.this.result) {
                    RemoteDownloadJob.this.done();
                } else {
                    RemoteDownloadJob.this.error();
                }
            }
        }).setRule((ISchedulingRule)RULE);
    }
}

