/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.core;

import java.io.File;
import java.nio.file.CopyOption;
import java.util.Iterator;
import org.dma.java.io.CustomFile;
import org.dma.java.io.Folder;
import org.dma.java.io.URLFile;
import org.dma.java.security.JKSCertificate;
import org.dma.services.at.ServiceCertificates;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.services.remote.RemoteUpdateFileJob;
import org.projectocolibri.core.remote.RemoteDownloadJob;
import org.projectocolibri.core.remote.updates.URLSectionKey;
import org.projectocolibri.core.remote.updates.UpdateFileHandler;

public enum CERTIFICATES {
    DGITA_SA_GLOBAL("Autoridade Tributaria", JKSCertificate.KEYSTORE_TYPE.JKS, "ChavePublicaAT.jks", "123456", "sapubkey"),
    DGITA_SW_PROD("Software Developer", JKSCertificate.KEYSTORE_TYPE.PKCS12, String.valueOf(String.valueOf(Colibri.AUTOR_LEGAL.nif)) + ".pfx", Colibri.PASSWORD_CIPHER.decode("LoXOUhet0VhHGVRn2+XegQ=="), new String[0]),
    DGITA_SW_TEST("TESTE Webservices", JKSCertificate.KEYSTORE_TYPE.PKCS12, "TesteWebservices.pfx", "TESTEwebservice", new String[0]);

    private static final int DAYS_TO_EXPIRE = 30;
    public final JKSCertificate cert;
    public final String description;
    public final JKSCertificate.KEYSTORE_TYPE type;
    public final String password;
    public final String[] alias;
    public final URLFile file;

    private CERTIFICATES(String description, JKSCertificate.KEYSTORE_TYPE type, String filename, String password, String ... alias) {
        this.cert = new JKSCertificate(type, new CustomFile((File)Colibri.FOLDERS.CERTIFICATES.folder, new String[]{filename}).toString(), password, alias);
        this.description = description;
        this.type = type;
        this.password = password;
        this.alias = alias;
        this.file = new URLFile(Colibri.REMOTE_SERVER.handler.folders.certificates, new String[]{filename});
        System.out.println(String.valueOf(filename) + " (" + this.cert.daysToExpire() + " days)");
        if (this.isExpired(30)) {
            String message = this.cert.toString();
            System.err.println(message);
        }
    }

    public boolean isExpired(int daysToExpire) {
        return this.cert.isExpired(daysToExpire);
    }

    public void update(URLSectionKey key, final File folder) {
        System.err.println("UPDATING: " + (Object)((Object)this));
        final CustomFile dst = new CustomFile((File)Folder.temporary((String[])new String[0]), new String[]{this.file.getName()});
        new RemoteDownloadJob(key.file, (File)dst){

            @Override
            public void error() {
            }

            @Override
            public void done() {
                System.out.println("DOWNLOADED: " + dst);
                JKSCertificate cert = new JKSCertificate(CERTIFICATES.this.type, dst.toString(), CERTIFICATES.this.password, CERTIFICATES.this.alias);
                if (cert.isValid() && !cert.equals(CERTIFICATES.this.cert) && dst.moveTo(folder, new CopyOption[0])) {
                    System.err.println("UPDATED: " + (Object)((Object)CERTIFICATES.this));
                    Colibri.markDirty();
                }
            }
        }.schedule();
    }

    public static CERTIFICATES get(String name) {
        try {
            return CERTIFICATES.valueOf(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void update(final File folder) {
        new RemoteUpdateFileJob(){

            @Override
            public void error() {
            }

            @Override
            public void done(UpdateFileHandler handler) {
                Iterator iterator = handler.getCertificates().iterator();
                while (iterator.hasNext()) {
                    URLSectionKey element = (URLSectionKey)iterator.next();
                    CERTIFICATES cert = CERTIFICATES.get(element.name);
                    System.out.println("CHECKING: " + (Object)((Object)cert));
                    if (cert == null || !cert.isExpired(30)) continue;
                    cert.update(element, folder);
                }
            }
        }.schedule();
    }

    public static enum WEBSERVICE {
        PROD(new ServiceCertificates(CERTIFICATES.DGITA_SA_GLOBAL.cert, CERTIFICATES.DGITA_SW_PROD.cert)),
        TEST(new ServiceCertificates(CERTIFICATES.DGITA_SA_GLOBAL.cert, CERTIFICATES.DGITA_SW_TEST.cert));

        public ServiceCertificates cert;

        private WEBSERVICE(ServiceCertificates cert) {
            this.cert = cert;
        }
    }
}

