/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.services.payment;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import org.dma.java.util.TimeDateUtils;
import org.dma.services.mb.ifthenpay.IfThenPayServiceResponseType;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.model.Entidadesmovimentos;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;

public class PaymentServiceResponseType
extends ArrayList<Entidadesmovimentos> {
    private static final long serialVersionUID = 1L;
    private final String entidade;
    private final String referencia;
    private final BigDecimal valor;
    private final Integer id;
    private final Date dataPagamento;
    private final Time horaPagamento;
    private final Date dataProcessamento;
    private final String terminal;
    private final BigDecimal valorTarifa;
    private final BigDecimal valorLiquido;

    public String getEntidade() {
        return this.entidade;
    }

    public String getReferencia() {
        return this.referencia;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public Integer getId() {
        return this.id;
    }

    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public Time getHoraPagamento() {
        return this.horaPagamento;
    }

    public Date getDataProcessamento() {
        return this.dataProcessamento;
    }

    public String getTerminal() {
        return this.terminal;
    }

    public BigDecimal getValorTarifa() {
        return this.valorTarifa;
    }

    public BigDecimal getValorLiquido() {
        return this.valorLiquido;
    }

    public String getDocumentoKey() {
        return this.isEmpty() ? null : ((Entidadesmovimentos)this.get(0)).getKey();
    }

    public PaymentServiceResponseType(IfThenPayServiceResponseType response) {
        this.entidade = response.entidade;
        this.referencia = response.referencia;
        this.valor = response.valor;
        this.id = response.id;
        this.dataPagamento = TimeDateUtils.getDateWithoutTime((Date)response.dtHrPagamento);
        this.horaPagamento = TimeDateUtils.getTime((Date)response.dtHrPagamento);
        this.dataProcessamento = response.processamento;
        this.terminal = response.terminal;
        this.valorTarifa = response.tarifa;
        this.valorLiquido = response.valorLiquido;
    }

    public PaymentServiceResponseType process(DatabaseManager manager) {
        this.clear();
        QueryDefinition query = new QueryDefinition(TABLES.entidadesmovimentos, new QueryOrdering(QueryOrdering.DIRECTION.DESCENDING, new TableFieldKey(FIELDS.entidadesmovimentos_datacriacao)));
        query.addRule(new FilterMapRule(FIELDS.entidadesmovimentos_tipodocumento, FIELDS.documentostipos_tipoentidade, FIELDS.entidadestipos_codigo).equal(Entidadestipos.RECORDS.cliente.codigo)).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_tipodocumento, FIELDS.documentostipos_tipodocumento).equal(1)).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_tiposaldo).equal(0)).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_datacriacao).smallerEqual(this.dataPagamento)).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_total).equal(this.valor.toPlainString()));
        switch (manager.getParametros().getMbidpagamento()) {
            case 0: {
                query.addRule(new FilterMapRule(FIELDS.entidadesmovimentos_entidade, FIELDS.entidades_numero).equal(this.id));
                break;
            }
            case 1: {
                query.addRule(new FilterMapRule(FIELDS.entidadesmovimentos_numerodocumento).equal(this.id));
                break;
            }
            case 2: {
                query.addRule(new FilterMapRule(FIELDS.entidadesmovimentos_numeroauxiliar).equal(this.id));
            }
        }
        this.addAll(manager.getEntidadesmovimentosCollection(query));
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [entidade=" + this.entidade + ", referencia=" + this.referencia + ", valor=" + this.valor + ", id=" + this.id + "]";
    }
}

