/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.services.at.transportes;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import org.dma.java.math.BusinessRules;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;
import pt.gov.portaldasfinancas.servicos.documentosTransporte.AddressStructurePT;
import pt.gov.portaldasfinancas.servicos.documentosTransporte.Line;
import pt.gov.portaldasfinancas.servicos.documentosTransporte.MovementStatus;
import pt.gov.portaldasfinancas.servicos.documentosTransporte.MovementType;
import pt.gov.portaldasfinancas.servicos.documentosTransporte.OrderReferences;
import pt.gov.portaldasfinancas.servicos.documentosTransporte.StockMovement;

public class StockMovementType
extends StockMovement {
    public StockMovementType(Entidadesdocumentos documento) {
        this.setTaxRegistrationNumber(documento.getManager().getEmpresa().getNifToInteger());
        this.setCompanyName(documento.getManager().getEmpresa().getNomeToText());
        this.setCompanyAddress(this.createAdressStructure(documento.getManager().getEmpresa().getMoradaToText(), documento.getManager().getEmpresa().getLocalidadeToText(), documento.getManager().getEmpresa().getCodigopostal().getCodigo(), documento.getManager().getEmpresa().getPais().getCodigoToText()));
        this.setDocumentNumber(documento.toString());
        if (documento.hasCodigovalidacao()) {
            this.setATCUD(documento.getATCUD());
        }
        if (documento.hasDocumentcode()) {
            this.setATDocCodeID(documento.getDocumentcode());
        }
        this.setMovementStatus(this.getMovementStatus(documento));
        this.setMovementDate(TimeDateUtils.getXMLGregorianCalendar((String)ATMessageFormatter.getInvoiceDate(documento.getDatacriacao())));
        this.setMovementType(this.getMovementType(documento));
        switch (documento.getTipoentidade().getTipoentidade()) {
            case 0: {
                this.setCustomerTaxID(documento.getNifToNumbers());
                break;
            }
            case 1: {
                this.setSupplierTaxID(documento.getNifToNumbers());
            }
        }
        this.setCustomerName(documento.getNomeToText());
        if (!documento.getMoradaToText().isEmpty()) {
            this.setCustomerAddress(this.createAdressStructure(documento.getMoradaToText(), documento.getLocalidadeToText(), documento.getCodigopostal().getCodigo(), documento.getPais().getCodigoToText()));
        }
        if (!documento.getLocaldescargaToText().isEmpty()) {
            this.setAddressTo(this.createAdressStructure(documento.getLocaldescargaToText(), documento.getLocalidadedescargaToText(), documento.getCodigopostaldescarga().getCodigo(), documento.getPais().getCodigoToText()));
        }
        this.setAddressFrom(this.createAdressStructure(documento.getLocalcargaToText(), documento.getLocalidadecargaToText(), documento.getCodigopostalcarga().getCodigo(), documento.getPais().getCodigoToText()));
        this.setMovementEndTime(TimeDateUtils.getXMLGregorianCalendar((String)ATMessageFormatter.getSystemEntryDate(documento.getDatadescargaWithTime())));
        this.setMovementStartTime(TimeDateUtils.getXMLGregorianCalendar((String)ATMessageFormatter.getSystemEntryDate(documento.getDatacargaWithTime())));
        if (!documento.getMatriculaToText().isEmpty()) {
            this.setVehicleID(documento.getMatriculaToText());
        }
        this.getLine().addAll(this.createLines(documento));
    }

    private MovementStatus getMovementStatus(Entidadesdocumentos documento) {
        switch (documento.getEstado()) {
            case 0: 
            case 2: {
                return MovementStatus.N;
            }
            case 1: {
                return MovementStatus.A;
            }
        }
        return null;
    }

    private MovementType getMovementType(Entidadesdocumentos documento) {
        switch (documento.getTipodocumento().getTipodocumentosaft()) {
            case 11: {
                return MovementType.GR;
            }
            case 12: {
                return MovementType.GT;
            }
            case 13: {
                return MovementType.GA;
            }
            case 14: {
                return MovementType.GC;
            }
            case 15: {
                return MovementType.GD;
            }
        }
        return null;
    }

    private AddressStructurePT createAdressStructure(String addressdetail, String city, String postalCode, String country) {
        AddressStructurePT addressStructure = new AddressStructurePT();
        if (addressdetail != null) {
            addressStructure.setAddressdetail(addressdetail);
        }
        if (city != null) {
            addressStructure.setCity(city);
        }
        if (postalCode != null) {
            addressStructure.setPostalCode(StringUtils.compact((String)postalCode));
        }
        if (country != null) {
            addressStructure.setCountry(country);
        }
        return addressStructure;
    }

    private Collection<Line> createLines(Entidadesdocumentos documento) {
        ArrayList<Line> col = new ArrayList<Line>();
        for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento$Tipo(1)) {
            Line line = new Line();
            col.add(line);
            if (linha.getLinhaorigem() != null) {
                OrderReferences order = new OrderReferences();
                order.setOriginatingON(linha.getLinhaorigem().getDocumento().toString());
                line.getOrderReferences().add(order);
            }
            line.setProductDescription(linha.getDescricao());
            line.setQuantity(linha.getQuantidade());
            line.setUnitOfMeasure(linha.getUnidademedida().getCodigoToText());
            BigDecimal valorliquido = BusinessRules.netValue((BigDecimal)linha.getValorliquido(), (BigDecimal)documento.getPercdesconto());
            line.setUnitPrice(valorliquido.divide(linha.getQuantidade(), FIELDS.entidadesdocumentoslinhas_preco.format.getSize().scale, RoundingMode.HALF_EVEN).abs());
        }
        return col;
    }
}

