/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.services.at.transportes;

import javax.xml.ws.WebServiceException;
import org.dma.java.util.Debug;
import org.dma.services.at.proxy.StockMovementServiceHandler;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.services.at.ATWebserviceResponseType;
import org.projectocolibri.api.services.at.IATDocumentosService;
import org.projectocolibri.api.services.at.transportes.StockMovementType;
import pt.gov.portaldasfinancas.servicos.documentosTransporte.ResponseStatus;
import pt.gov.portaldasfinancas.servicos.documentosTransporte.StockMovement;
import pt.gov.portaldasfinancas.servicos.documentosTransporte.StockMovementResponse;

public class StockMovementService
implements IATDocumentosService {
    public static final int DOCUMENTO_REGISTADO = 0;
    public static final int DOCUMENTO_DUPLICADO = -3;
    public static final int DOCUMENTO_COMUNICADO = -100;
    private final StockMovementServiceHandler handler;
    private final Entidadesdocumentos documento;

    public StockMovementService(StockMovementServiceHandler handler, Entidadesdocumentos documento) {
        this.handler = handler;
        this.documento = documento;
    }

    @Override
    public void checkService() throws WebServiceException {
        if (!this.documento.getManager().getLicenca().allows(Colibri.FUNCIONALIDADES.WEBSERVICE_DOCUMENTOS)) {
            throw new WebServiceException("Servi\u00e7o n\u00e3o suportado!");
        }
        if (this.documento.getTipodocumento().isTipodocumentosaft(0)) {
            throw new WebServiceException("Documento n\u00e3o suportado!");
        }
    }

    @Override
    public ATWebserviceResponseType register() throws WebServiceException {
        this.checkService();
        ATWebserviceResponseType response = this.getResponse(this.handler.register((StockMovement)new StockMovementType(this.documento)));
        switch (response.getReturnCode()) {
            case 0: {
                this.documento.setDocumentcode(response.getDocumentCode());
            }
            case -100: 
            case -3: {
                this.documento.setEstadoenvio(2);
            }
        }
        return response;
    }

    private ATWebserviceResponseType getResponse(StockMovementResponse response) {
        for (ResponseStatus status : response.getResponseStatus()) {
            Debug.out((String)status.getReturnMessage());
        }
        return this.getResponse((ResponseStatus)response.getResponseStatus().get(0), response.getATDocCodeID());
    }

    private ATWebserviceResponseType getResponse(ResponseStatus response, String documentCode) {
        return new ATWebserviceResponseType(response.getReturnCode().intValue(), response.getReturnMessage(), documentCode);
    }
}

