/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.services.at.series;

import javax.xml.ws.WebServiceException;
import org.dma.java.util.Debug;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageLine;
import org.dma.services.at.proxy.SeriesServiceHandler;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.model.Documentosseries;
import org.projectocolibri.api.services.at.IATWebservice;
import pt.gov.portaldasfinancas.servicos.series.ConsultarSeriesResp;
import pt.gov.portaldasfinancas.servicos.series.OperationResultInfo;
import pt.gov.portaldasfinancas.servicos.series.SeriesInfo;
import pt.gov.portaldasfinancas.servicos.series.SeriesResp;
import pt.gov.portaldasfinancas.servicos.series.types.ClasseDocType;
import pt.gov.portaldasfinancas.servicos.series.types.EstadoSerieType;
import pt.gov.portaldasfinancas.servicos.series.types.MeioProcessamentoType;
import pt.gov.portaldasfinancas.servicos.series.types.MotivoAnulacaoType;
import pt.gov.portaldasfinancas.servicos.series.types.TipoDocType;
import pt.gov.portaldasfinancas.servicos.series.types.TipoSerieType;
import pt.gov.portaldasfinancas.servicos.series.types.requests.AnularSerieType;
import pt.gov.portaldasfinancas.servicos.series.types.requests.ConsultarSeriesType;
import pt.gov.portaldasfinancas.servicos.series.types.requests.FinalizarSerieType;
import pt.gov.portaldasfinancas.servicos.series.types.requests.RegistarSeriesType;

public class SeriesService
implements IATWebservice {
    public static final int SERIE_REGISTADA = 2001;
    public static final int SERIE_CONSULTADA = 2002;
    public static final int SERIE_ANULADA = 2003;
    public static final int SERIE_FINALIZADA = 2004;
    public static final int SERIE_JA_REGISTADA = 4001;
    @Deprecated
    private static final int SERIE_JA_ANULADA = 4004;
    @Deprecated
    private static final int SERIE_JA_FINALIZADA = 4005;
    private final SeriesServiceHandler handler;
    private final Documentosseries serie;

    public SeriesService(SeriesServiceHandler handler, Documentosseries serie) {
        this.handler = handler;
        this.serie = serie;
    }

    @Override
    public void checkService() throws WebServiceException {
        if (!this.serie.getManager().getLicenca().allows(Colibri.FUNCIONALIDADES.WEBSERVICE_SERIES)) {
            throw new WebServiceException("Servi\u00e7o n\u00e3o suportado!");
        }
        if (this.serie.getTipoDoc() == null) {
            throw new WebServiceException("Documento n\u00e3o suportado!");
        }
    }

    public String registar() throws WebServiceException {
        this.checkService();
        if (!this.serie.isEstado(1)) {
            throw new WebServiceException("A s\u00e9rie [" + this.serie + "] n\u00e3o est\u00e1 activa!");
        }
        if (this.serie.hasCodigovalidacao()) {
            throw new WebServiceException("A s\u00e9rie [" + this.serie + "] j\u00e1 tem c\u00f3digo de valida\u00e7\u00e3o!");
        }
        if (!this.serie.isEdited()) {
            throw new WebServiceException("A s\u00e9rie [" + this.serie + "] n\u00e3o est\u00e1 gravada!");
        }
        SeriesResp response = this.handler.registarSerie(new RegistarSeriesType(this.serie.getSerie(), this.serie.getTipoSerie(), this.serie.getTipoDoc(), this.serie.isEdited() && this.serie.getNumero() > 0 ? this.serie.getNumero() : this.serie.getNumero() + 1, 38, MeioProcessamentoType.PI));
        OperationResultInfo result = response.getInfoResultOper();
        if (result.getCodResultOper().intValue() != 2001) {
            throw new WebServiceException(result.getCodResultOper() + "-" + result.getMsgResultOper());
        }
        Debug.out((String)"REGISTOU", (Object)this);
        return response.getInfoSerie().getCodValidacaoSerie();
    }

    public void anular() throws WebServiceException {
        this.checkService();
        SeriesResp response = this.handler.anularSerie(new AnularSerieType(this.serie.getSerie(), this.serie.getTipoDoc(), this.serie.getCodigovalidacao(), MotivoAnulacaoType.ER, this.serie.getNumero() == 0));
        OperationResultInfo result = response.getInfoResultOper();
        if (result.getCodResultOper().intValue() != 2003) {
            throw new WebServiceException(result.getCodResultOper() + "-" + result.getMsgResultOper());
        }
        Debug.out((String)"ANULOU", (Object)this);
    }

    public void finalizar() throws WebServiceException {
        this.checkService();
        SeriesResp response = this.handler.finalizarSerie(new FinalizarSerieType(this.serie.getSerie(), this.serie.getTipoDoc(), this.serie.getCodigovalidacao(), this.serie.getNumero().intValue()));
        OperationResultInfo result = response.getInfoResultOper();
        if (result.getCodResultOper().intValue() != 2004) {
            throw new WebServiceException(result.getCodResultOper() + "-" + result.getMsgResultOper());
        }
        Debug.out((String)"FINALIZOU", (Object)this);
    }

    public ConsultarSeriesResp consultar() throws WebServiceException {
        this.checkService();
        return this.handler.consultarSeries(new ConsultarSeriesType(this.serie.getSerie(), this.serie.getTipoSerie(), this.serie.getTipoDoc()));
    }

    public ErrorList debug() {
        ErrorList error = new ErrorList();
        try {
            ConsultarSeriesResp response = this.consultar();
            OperationResultInfo result = response.getInfoResultOper();
            if (response.getInfoSerie().size() == 0) {
                error.warnings().add((Object)new MessageLine((Object)result.getMsgResultOper()).brackets((Object)result.getCodResultOper().intValue()));
            } else {
                SeriesInfo info = (SeriesInfo)response.getInfoSerie().get(0);
                error.warnings().add("S\u00e9rie: " + info.getSerie());
                error.warnings().add("Estado: " + EstadoSerieType.get((SeriesInfo)info));
                error.warnings().add("Tipo S\u00e9rie: " + TipoSerieType.get((SeriesInfo)info));
                error.warnings().add("Tipo Documento: " + TipoDocType.get((SeriesInfo)info));
                error.warnings().add("Classe Documento: " + ClasseDocType.get((SeriesInfo)info));
                error.warnings().add("Data Registo: " + info.getDataRegisto());
                error.warnings().add("Data Utiliza\u00e7\u00e3o: " + info.getDataInicioPrevUtiliz());
                error.warnings().add("N\u00famero Inicial Sequ\u00eancia: " + info.getNumInicialSeq());
                error.warnings().add("\u00daltimo Documento Emitido: " + info.getSeqUltimoDocEmitido());
                error.warnings().add("Justifica\u00e7\u00e3o Finaliza\u00e7\u00e3o: " + info.getJustificacao());
                error.warnings().add("Data Estado (Altera\u00e7\u00e3o): " + info.getDataEstado());
                error.warnings().add("Motivo Estado (Anula\u00e7\u00e3o): " + MotivoAnulacaoType.get((SeriesInfo)info));
                error.warnings().add("N\u00famero Final Sequ\u00eancia: " + info.getNumFinalSeq());
                error.warnings().add("C\u00f3digo Valida\u00e7\u00e3o: " + info.getCodValidacaoSerie());
                error.warnings().add("NIF Comunicou: " + info.getNifComunicou());
                error.warnings().add("Meio Processamento: " + MeioProcessamentoType.get((SeriesInfo)info));
                error.warnings().add("N\u00famero Certificado Software: " + info.getNumCertSWFatur());
            }
        }
        catch (Exception e) {
            error.errors().add((Throwable)e);
        }
        return error;
    }
}

