/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.services.at.facturas.v2023;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.dma.java.math.BusinessRules;
import org.dma.java.util.Debug;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;
import org.projectocolibri.xml.beans.saft.ISAFTExport;
import pt.gov.portaldasfinancas.servicos.documentos.DebitCreditIndicator;
import pt.gov.portaldasfinancas.servicos.documentos.DocumentTotals;
import pt.gov.portaldasfinancas.servicos.documentos.InvoiceDataType;
import pt.gov.portaldasfinancas.servicos.documentos.InvoiceStatus;
import pt.gov.portaldasfinancas.servicos.documentos.InvoiceTypeType;
import pt.gov.portaldasfinancas.servicos.documentos.OrderReferences;
import pt.gov.portaldasfinancas.servicos.documentos.RegisterInvoiceRequest;
import pt.gov.portaldasfinancas.servicos.documentos.Tax;
import pt.gov.portaldasfinancas.servicos.documentos.TaxType;
import pt.gov.portaldasfinancas.servicos.documentos.WithholdingTax;
import pt.gov.portaldasfinancas.servicos.documentos.types.InvoiceStatusType;

public class RegisterInvoiceType
extends RegisterInvoiceRequest {
    public RegisterInvoiceType(Entidadesdocumentos documento) {
        this.setEFaturaMDVersion("0.0.1");
        this.setAuditFileVersion(ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getFileVersion());
        this.setTaxRegistrationNumber(documento.getManager().getEmpresa().getNifToInteger());
        this.setTaxEntity("Global");
        this.setSoftwareCertificateNumber(BigInteger.valueOf(38L));
        this.setInvoiceData(this.createInvoiceData(documento));
    }

    private InvoiceDataType createInvoiceData(Entidadesdocumentos documento) {
        InvoiceDataType invoice = new InvoiceDataType();
        invoice.setInvoiceNo(documento.toString());
        invoice.setATCUD(documento.getATCUD());
        invoice.setInvoiceDate(TimeDateUtils.getXMLGregorianCalendar((String)ATMessageFormatter.getInvoiceDate(documento.getDatacriacao())));
        invoice.setInvoiceType(this.getInvoiceType(documento));
        invoice.setSelfBillingIndicator(BigInteger.ZERO);
        invoice.setCustomerTaxID(documento.getNifParsed());
        invoice.setCustomerTaxIDCountry(documento.getEntidade().getPais().getCodigo());
        invoice.setDocumentStatus(this.createInvoiceStatus(documento));
        invoice.setHashCharacters(documento.getHashCheckdigits());
        invoice.setCashVATSchemeIndicator(documento.getSeriedocumento().isRegimeiva(1) ? 1 : 0);
        invoice.setPaperLessIndicator(0);
        invoice.setSystemEntryDate(TimeDateUtils.getXMLGregorianCalendar((String)ATMessageFormatter.getSystemEntryDate(documento.getDatasistemaWithTime())));
        invoice.getLineSummary().addAll(this.createLineSummary(documento));
        invoice.setDocumentTotals(this.createDocumentTotals(documento));
        if (documento.getTotalretencoes().signum() != 0) {
            invoice.getWithholdingTax().addAll(this.createWithholdingTaxList(documento));
        }
        return invoice;
    }

    private InvoiceStatus createInvoiceStatus(Entidadesdocumentos documento) {
        InvoiceStatus status = new InvoiceStatus();
        status.setInvoiceStatus(this.getInvoiceStatus(documento).value());
        status.setInvoiceStatusDate(TimeDateUtils.getXMLGregorianCalendar((String)ATMessageFormatter.getSystemEntryDate(documento.getDatasistemaWithTime())));
        return status;
    }

    private InvoiceStatusType getInvoiceStatus(Entidadesdocumentos documento) {
        switch (documento.getEstado()) {
            case 0: 
            case 2: {
                return InvoiceStatusType.N;
            }
            case 1: {
                return InvoiceStatusType.A;
            }
        }
        return null;
    }

    private InvoiceTypeType getInvoiceType(Entidadesdocumentos documento) {
        switch (documento.getTipodocumento().getTipodocumentosaft()) {
            case 1: {
                return InvoiceTypeType.FT;
            }
            case 2: {
                return InvoiceTypeType.FS;
            }
            case 3: {
                return InvoiceTypeType.FR;
            }
            case 4: {
                return InvoiceTypeType.ND;
            }
            case 5: {
                return InvoiceTypeType.NC;
            }
        }
        return null;
    }

    private DocumentTotals createDocumentTotals(Entidadesdocumentos documento) {
        DocumentTotals documentTotals = new DocumentTotals();
        documentTotals.setTaxPayable(ATMessageFormatter.getGrossTotal(documento.getTotaliva().abs()));
        documentTotals.setNetTotal(ATMessageFormatter.getGrossTotal(documento.getTotalliquido().abs()));
        documentTotals.setGrossTotal(ATMessageFormatter.getGrossTotal(documento.getTotalbruto().abs()));
        return documentTotals;
    }

    private List<WithholdingTax> createWithholdingTaxList(Entidadesdocumentos documento) {
        WithholdingTax withholdingTax = new WithholdingTax();
        withholdingTax.setWithholdingTaxType("IRS");
        withholdingTax.setWithholdingTaxAmount(documento.getTotalretencoes().abs());
        return Arrays.asList(withholdingTax);
    }

    private Collection<InvoiceDataType.LineSummary> createLineSummary(Entidadesdocumentos documento) {
        TreeMap<String, InvoiceDataType.LineSummary> map = new TreeMap<String, InvoiceDataType.LineSummary>();
        for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento$Tipo(1)) {
            InvoiceDataType.LineSummary line = this.createLineSummary(linha);
            String key = String.valueOf(linha.getCodigoiva().getCodigo()) + (line.getTaxExemptionCode() == null ? "" : line.getTaxExemptionCode()) + (line.getTaxPointDate() == null ? "" : line.getTaxPointDate()) + (line.getReference().isEmpty() ? "" : (String)line.getReference().get(0)) + (line.getOrderReferences().isEmpty() ? "" : ((OrderReferences)line.getOrderReferences().get(0)).getOriginatingON()) + (line.getDebitCreditIndicator() == null ? "" : line.getDebitCreditIndicator());
            Debug.out((String)"key", (Object)key);
            InvoiceDataType.LineSummary value = map.put(key, line);
            if (value == null) continue;
            line.setAmount(line.getAmount().add(value.getAmount()));
        }
        for (InvoiceDataType.LineSummary line : map.values()) {
            BigDecimal amount = BusinessRules.netValue((BigDecimal)line.getAmount(), (BigDecimal)documento.getPercdesconto());
            line.setAmount(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(amount, RoundingMode.HALF_EVEN));
        }
        return map.values();
    }

    private InvoiceDataType.LineSummary createLineSummary(Entidadesdocumentoslinhas linha) {
        InvoiceDataType.LineSummary line = new InvoiceDataType.LineSummary();
        if (linha.getLinhaorigem() != null && !linha.getDocumento().getTipodocumento().isTipodocumento(4)) {
            line.getOrderReferences().add(this.createOrderReferences(linha.getLinhaorigem()));
        }
        line.setTaxPointDate(TimeDateUtils.getXMLGregorianCalendar((String)ATMessageFormatter.getInvoiceDate(linha.getDatadocumento())));
        if (linha.getLinhaorigem() != null && linha.getDocumento().getTipodocumento().isTipodocumento(4)) {
            line.getReference().add(linha.getLinhaorigem().getDocumento().toString());
        }
        line.setDebitCreditIndicator(this.getDebitCreditIndicator(linha));
        line.setAmount(linha.getValorliquido().abs());
        line.setTax(this.createTax(linha));
        if (!linha.getCodigoiva().hasTaxa()) {
            line.setTaxExemptionCode(linha.getIsencaoiva().getMotivoAT().name());
        }
        return line;
    }

    private OrderReferences createOrderReferences(Entidadesdocumentoslinhas linha) {
        OrderReferences orderReferences = new OrderReferences();
        orderReferences.setOriginatingON(linha.getDocumento().toString());
        orderReferences.setOrderDate(TimeDateUtils.getXMLGregorianCalendar((String)ATMessageFormatter.getInvoiceDate(linha.getDatadocumento())));
        return orderReferences;
    }

    private DebitCreditIndicator getDebitCreditIndicator(Entidadesdocumentoslinhas linha) {
        switch (linha.getDocumento().getTipodocumento().getSAFTMovementClass()) {
            case NONE: {
                break;
            }
            case DEBIT: {
                return linha.getValorliquido().signum() >= 0 ? DebitCreditIndicator.D : DebitCreditIndicator.C;
            }
            case CREDIT: {
                return linha.getValorliquido().signum() >= 0 ? DebitCreditIndicator.C : DebitCreditIndicator.D;
            }
        }
        return null;
    }

    private Tax createTax(Entidadesdocumentoslinhas linha) {
        Tax tax = new Tax();
        tax.setTaxType(this.getTaxType(linha.getCodigoiva()));
        tax.setTaxCountryRegion(this.getTaxCountryRegion(linha.getCodigoiva(), linha.getDocumento().getPais()));
        tax.setTaxCode(this.getTaxCode(linha.getCodigoiva()));
        tax.setTaxPercentage(linha.getCodigoiva().hasTaxa() ? linha.getCodigoiva().getTaxa() : BigDecimal.ZERO);
        return tax;
    }

    private TaxType getTaxType(Codigosiva codigoiva) {
        switch (codigoiva.getTipotaxa()) {
            case 5: {
                return TaxType.NS;
            }
        }
        return TaxType.IVA;
    }

    private String getTaxCountryRegion(Codigosiva codigoiva, Paises pais) {
        switch (codigoiva.getEspacofiscal()) {
            case 0: {
                return "PT";
            }
            case 1: {
                return "PT-MA";
            }
            case 2: {
                return "PT-AC";
            }
            case 3: {
                return pais.getCodigo();
            }
        }
        return null;
    }

    private String getTaxCode(Codigosiva codigoiva) {
        switch (codigoiva.getTipotaxa()) {
            case 0: {
                return "NOR";
            }
            case 1: {
                return "RED";
            }
            case 2: {
                return "INT";
            }
            case 3: {
                return "ISE";
            }
            case 4: {
                return "OUT";
            }
            case 5: {
                return "NS";
            }
        }
        return null;
    }
}

