/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.services.at.facturas.v2023;

import javax.xml.ws.WebServiceException;
import org.dma.services.at.proxy.DocumentosServiceHandler;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.services.at.ATWebserviceResponseType;
import org.projectocolibri.api.services.at.IATDocumentosService;
import org.projectocolibri.api.services.at.facturas.v2023.RegisterInvoiceType;
import pt.gov.portaldasfinancas.servicos.documentos.InvoiceStatus;
import pt.gov.portaldasfinancas.servicos.documentos.RegisterInvoiceRequest;
import pt.gov.portaldasfinancas.servicos.documentos.ResponseType;
import pt.gov.portaldasfinancas.servicos.documentos.types.InvoiceStatusType;

public class FaturasService
implements IATDocumentosService {
    public static final int DOCUMENTO_REGISTADO = 0;
    public static final int DOCUMENTO_DUPLICADO = -10;
    private final DocumentosServiceHandler handler;
    private final Entidadesdocumentos documento;

    public FaturasService(DocumentosServiceHandler handler, Entidadesdocumentos documento) {
        this.handler = handler;
        this.documento = documento;
    }

    @Override
    public void checkService() throws WebServiceException {
        if (!this.documento.getManager().getLicenca().allows(Colibri.FUNCIONALIDADES.WEBSERVICE_DOCUMENTOS)) {
            throw new WebServiceException("Servi\u00e7o n\u00e3o suportado!");
        }
        if (this.documento.getTipodocumento().isTipodocumentosaft(0)) {
            throw new WebServiceException("Documento n\u00e3o suportado!");
        }
    }

    @Override
    public ATWebserviceResponseType register() throws WebServiceException {
        this.checkService();
        ATWebserviceResponseType response = this.getResponse(this.register(new RegisterInvoiceType(this.documento)));
        switch (response.getReturnCode()) {
            case -10: 
            case 0: {
                this.documento.setEstadoenvio(2);
            }
        }
        return response;
    }

    private ResponseType register(RegisterInvoiceType request) throws WebServiceException {
        InvoiceStatusType status = InvoiceStatusType.get((InvoiceStatus)request.getInvoiceData().getDocumentStatus());
        switch (this.documento.getEstadoenvio()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.handler.changeInvoiceStatus((RegisterInvoiceRequest)request, status);
                break;
            }
        }
        return this.handler.registerInvoice((RegisterInvoiceRequest)request);
    }

    private ATWebserviceResponseType getResponse(ResponseType response) {
        return new ATWebserviceResponseType(response.getCodigoResposta(), response.getMensagem());
    }
}

