/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.language;

import java.io.File;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.dma.eclipse.jface.dialogs.message.CustomMessageDialog;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.language.LanguageBundle;
import org.projectocolibri.api.language.LanguageBundleMap;

public class Language
extends LanguageBundleMap {
    private static final long serialVersionUID = 1L;
    public static final String VIRTUAL_FIELD = "(*)";
    public static final String RESOURCE_NAME = "language";
    public static final String LANGUAGE_CODE = Colibri.PREFERENCES.LANGUAGE_CODE.value.getString();
    public static final Locale LOCALE = new Locale(LANGUAGE_CODE);
    public static final DecimalFormatSymbols FORMAT_SYMBOLS = new DecimalFormatSymbols(LOCALE);
    public static final List<LanguageBundle> AVAILABLE_BUNDLES = Language.getAvailableBundles();

    private static LanguageBundle getBundle(String code) {
        for (LanguageBundle bundle : AVAILABLE_BUNDLES) {
            if (!bundle.equals(code)) continue;
            return bundle;
        }
        return AVAILABLE_BUNDLES.size() == 0 ? null : AVAILABLE_BUNDLES.get(0);
    }

    private static List<LanguageBundle> getAvailableBundles() {
        ArrayList<LanguageBundle> bundles = new ArrayList<LanguageBundle>();
        File[] fileArray = Colibri.FOLDERS.LANGUAGE.folder.listDirectories();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            try {
                System.out.println("FOUND: " + folder);
                String code = folder.getName();
                String baseName = "language." + code + ".Labels";
                bundles.add(new LanguageBundle(code, baseName, LOCALE, Language.class.getClassLoader()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return Collections.unmodifiableList(bundles);
    }

    public Language() {
        this(LANGUAGE_CODE);
    }

    public Language(String code) {
        super(Language.getBundle(code));
        if (this.bundle.isPortuguese()) {
            CustomMessageDialog.DIALOG_TYPES.ERROR.setTitle("Erro");
            CustomMessageDialog.DIALOG_TYPES.WARNING.setTitle("Aviso");
            CustomMessageDialog.DIALOG_TYPES.INFORMATION.setTitle("Informa\u00e7\u00e3o");
            CustomMessageDialog.DIALOG_TYPES.QUESTION.setTitle("Aten\u00e7\u00e3o");
            CustomMessageDialog.DIALOG_TYPES.CONFIRM.setTitle("Confirma\u00e7\u00e3o");
            CustomMessageDialog.DIALOG_BUTTONS.OK.setLabel("OK");
            CustomMessageDialog.DIALOG_BUTTONS.CANCEL.setLabel("Cancelar");
            CustomMessageDialog.DIALOG_BUTTONS.YES.setLabel("Sim");
            CustomMessageDialog.DIALOG_BUTTONS.NO.setLabel("N\u00e3o");
        }
    }
}

