/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.templates;

import org.dma.java.util.TimeDateUtils;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.projectocolibri.api.birt.design.BIRTDesign;
import org.projectocolibri.api.birt.design.BIRTDesignHelper;
import org.projectocolibri.api.birt.design.BIRTParametersMap;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.update.templates.DesignUpdate;
import org.projectocolibri.api.database.update.templates.TemplatesUpdate;

public class Version70to71
extends TemplatesUpdate {
    public Version70to71(DatabaseManager manager) {
        super(manager);
    }

    @Override
    public void run(DesignUpdate update) throws Exception {
        this.updateDesignStyles(update.getDesign());
        this.updateFooterMessage(update.getDesign(), update.getTemplate().getTipo());
    }

    private void updateDesignStyles(ReportDesignHandle design) throws Exception {
        StyleHandle style = BIRTDesign.STYLES.TIME_FORMAT.newStyle(design);
        style.setDateTimeFormatCategory("Custom");
        style.setDateTimeFormat(TimeDateUtils.DEFAULT_TIME_PATTERN);
        design.getStyles().add((DesignElementHandle)style);
    }

    private void updateFooterMessage(ReportDesignHandle design, int reportType) throws Exception {
        DataItemHandle dataItem = BIRTDesignHelper.findSlotColumn(design.getMasterPages().get(0).getSlot(1), "Nome do Projecto");
        if (dataItem != null) {
            CellHandle cellHandle = (CellHandle)dataItem.getContainer();
            cellHandle.clearContents(0);
            cellHandle.getContent().add((DesignElementHandle)BIRTDesignHelper.createDataItemColumn(design, reportType, BIRTParametersMap.PARAMETERS_TYPES.legal_statement));
        }
    }
}

