/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.templates;

import java.io.File;
import org.dma.java.io.UTF8TextFile;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.projectocolibri.api.birt.design.BIRTColumnProperties;
import org.projectocolibri.api.birt.design.BIRTDesignHelper;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.update.templates.DesignUpdate;
import org.projectocolibri.api.database.update.templates.TemplatesUpdate;

public class Version52to60
extends TemplatesUpdate {
    public Version52to60(DatabaseManager manager) {
        super(manager);
    }

    @Override
    public void run(DesignUpdate update) throws Exception {
        this.updateDataset(update.getDesign(), update.getTemplate().getTabela());
        this.replaceText(update.getDesignFile());
    }

    private void replaceText(File designFile) throws Exception {
        UTF8TextFile file = new UTF8TextFile(designFile);
        String text = file.read();
        text = text.replace("<property name=\"fontSize\">smaller</property>", "<property name=\"fontSize\">5pt</property>");
        text = text.replace("<property name=\"fontSize\">small</property>", "<property name=\"fontSize\">7pt</property>");
        text = text.replace("<property name=\"fontSize\">large</property>", "<property name=\"fontSize\">12pt</property>");
        file.write(text);
    }

    private void updateDataset(ReportDesignHandle design, int tabela) throws Exception {
        if (tabela == 5) {
            TABLES dataSet = TABLES.entidadesdocumentoslinhas;
            TableFieldKey[] fields = new TableFieldKey[]{TableFieldKey.valueOf("isencaoiva.codigo"), TableFieldKey.valueOf("isencaoiva.descricao"), TableFieldKey.valueOf("isencaoiva.artigolegal")};
            ScriptDataSetHandle dataSetHandle = BIRTDesignHelper.findDataset(design, "d2-" + dataSet.name());
            if (dataSetHandle != null && !BIRTDesignHelper.existsDatasetColumn(dataSetHandle, dataSet, fields[0], 0)) {
                int rowNumber = BIRTDesignHelper.countDatasetColumns(dataSetHandle) + 1;
                int i = 0;
                while (i < fields.length) {
                    BIRTColumnProperties columnProperties = BIRTDesignHelper.createColumnProperties(dataSet, this.manager.getCampos(), fields[i], 1, rowNumber + i, 0);
                    BIRTDesignHelper.setColumnProperties(dataSetHandle, columnProperties);
                    ++i;
                }
                dataSetHandle.setFetch(dataSetHandle.getFetch().replace("return true", "//TABLE: isencaoiva\nif( entidadesdocumentoslinhas.getIsencaoiva() != null ){\nrow[\"d2-" + String.valueOf(rowNumber) + "\"] = entidadesdocumentoslinhas.getIsencaoiva().getCodigo();\n" + "row[\"d2-" + String.valueOf(rowNumber + 1) + "\"] = entidadesdocumentoslinhas.getIsencaoiva().getArtigolegal();\n" + "row[\"d2-" + String.valueOf(rowNumber + 2) + "\"] = entidadesdocumentoslinhas.getIsencaoiva().getDescricao();\n" + "}\n" + "return true"));
                CachedMetaData cachedMetaData = StructureFactory.createCachedMetaData();
                dataSetHandle.setCachedMetaData(cachedMetaData);
            }
        }
    }
}

