/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.templates;

import org.dma.eclipse.jface.dialogs.progress.IProgressAction;
import org.dma.java.util.Debug;
import org.dma.java.util.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.birt.design.BIRTParametersMap;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableLayout;
import org.projectocolibri.api.database.mapper.TableLayoutArray;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.update.templates.DesignUpdate;

public abstract class TemplatesUpdate
implements IProgressAction {
    protected final DatabaseManager manager;

    public abstract void run(DesignUpdate var1) throws Exception;

    public TemplatesUpdate(DatabaseManager manager) {
        this.manager = manager;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        for (Templates template : this.manager.getTemplatesCollection()) {
            Debug.out((Object)template);
            DesignUpdate update = new DesignUpdate(this.manager, template.getCodigo());
            if (!update.openDesign()) continue;
            try {
                this.updateLayout(update.getTemplate());
                update.updateDesign();
                this.run(update);
                update.saveDesign();
            }
            finally {
                update.closeDesign();
            }
        }
    }

    private void updateLayout(Templates template) throws Exception {
        if (template.table() == TABLES.artigosdocumentos || template.table() == TABLES.entidadesdocumentos) {
            template.setLayout(new TableLayoutArray());
        } else if (template.getLayoutToText().isEmpty()) {
            template.setLayout(template.createLayout().exclude(FIELDS.TYPES.BINARY));
        } else {
            template.setLayout(new TableLayout(template));
        }
    }

    public String safeReplace(String text, String search, BIRTParametersMap.PARAMETERS_TYPES replacement) throws Exception {
        return this.safeReplace(text, search, replacement.name, new char[0]);
    }

    public String safeReplace(String text, String search, String replacement, char ... quote) throws Exception {
        return text.replace(StringUtils.quote((String)search, (char[])quote), StringUtils.quote((String)replacement, (char[])quote));
    }
}

