/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.templates;

import java.io.File;
import org.projectocolibri.api.birt.design.BIRTDesignHandler;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.model.Templates;

public class DesignUpdate
extends BIRTDesignHandler {
    private final Templates template;

    public Templates getTemplate() {
        return this.template;
    }

    public DesignUpdate(DatabaseManager manager, String codigo) {
        this(manager.loadTemplates(codigo));
    }

    public DesignUpdate(Templates template) {
        super((File)template.createDesignFile(), template.getTipo());
        this.template = template;
    }

    public File getDesignFile() throws Exception {
        return super.saveDesign();
    }

    @Override
    public File saveDesign() throws Exception {
        File designFile = this.getDesignFile();
        this.template.setTemplate(designFile);
        if (this.template.validate(IDatabaseModel.ACTION.STORE).isEmpty()) {
            this.template.update();
        }
        return designFile;
    }

    @Override
    public void closeDesign() {
        super.closeDesign();
        this.designFile.delete();
    }
}

