/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Armazens;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigosexistencias;
import org.projectocolibri.api.database.model.Artigosprecos;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.model.Unidadesmedida;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;
import org.projectocolibri.core.support.PermissionsMap;

public final class Version94to100
extends AbstractUpdate {
    public Version94to100(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Utilizadores>(TABLES.utilizadores, this.manager){

            @Override
            public void process(Utilizadores model) throws Exception {
                PermissionsMap map = new PermissionsMap(model.getPermissoes());
                map.get(TABLES.artigosdocumentos).add(Utilizadores.COMMANDS.EmitirRelatorio);
                map.get(TABLES.entidadesdocumentos).add(Utilizadores.COMMANDS.EmitirRelatorio);
                model.setPermissoes(map);
                model.setChecksum();
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Codigosiva>(TABLES.codigosiva, this.manager){

            @Override
            public void process(Codigosiva model) throws Exception {
                if (model.getTaxa().signum() == 0 && model.getTipotaxa() != 3 && model.getTipotaxa() != 5) {
                    model.setTipotaxa(3);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Unidadesmedida>(TABLES.unidadesmedida, this.manager){

            @Override
            public void process(Unidadesmedida model) throws Exception {
                if (model.getGrandeza() == null) {
                    if (model.equals("KG")) {
                        model.setGrandeza(1);
                    } else if (model.equals("MT")) {
                        model.setGrandeza(2);
                    } else if (model.equals("LT")) {
                        model.setGrandeza(3);
                    } else if (model.equals("M2")) {
                        model.setGrandeza(4);
                    } else if (model.equals("M3")) {
                        model.setGrandeza(5);
                    } else if (model.equals("HR")) {
                        model.setGrandeza(6);
                    } else {
                        model.setGrandeza(0);
                    }
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Armazens>(TABLES.armazens, this.manager){
            Armazens armazem;
            {
                this.armazem = this.manager.loadArmazens();
            }

            @Override
            public void process(Armazens model) throws Exception {
                if (model.equals(this.armazem)) {
                    if (model.getMorada().isEmpty()) {
                        model.setMorada(this.manager.getEmpresa().getMorada());
                        model.setCodigopostal(this.manager.getEmpresa().getCodigopostal());
                    }
                    this.store(model);
                }
            }
        }.execute();
        new TransactionalQuery<Documentostipos>(TABLES.documentostipos, this.manager){

            @Override
            public void process(Documentostipos model) throws Exception {
                if (model.getCopias() == null) {
                    model.setCopias(model.getVias());
                    model.setCopiasemail(model.getViasemail() == null ? 0 : model.getViasemail());
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Parametros>(TABLES.parametros, this.manager){
            Armazens armazem;
            {
                this.armazem = this.manager.loadArmazens();
            }

            @Override
            public void process(Parametros model) throws Exception {
                model.setArmazem(this.armazem);
                model.setSugestaoprecos(1);
                model.setAvisacomposicao(0);
                model.setAvisataxaiva(0);
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigos>(TABLES.artigos, this.manager){

            @Override
            public void process(Artigos model) throws Exception {
                if (model.getCategoria() == null) {
                    model.setCategoria(0);
                }
                if (model.getUnidades().size() == 0) {
                    model.addUnidades();
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigosprecos>(TABLES.artigosprecos, this.manager){

            @Override
            public void process(Artigosprecos model) throws Exception {
                Artigosprecos clone = model.cloneCopy();
                this.delete(model);
                clone.setCascade(false);
                if (clone.getUnidademedida() == null) {
                    clone.setUnidademedida(clone.getArtigo().getUnidades(0).getUnidademedida());
                }
                clone.setKey(String.valueOf(clone.getArtigo().getCodigo()) + ":" + clone.getPrecario().getCodigo() + ":" + clone.getUnidademedida().getCodigo() + ":" + clone.getTamanho().getCodigo() + ":" + clone.getCor().getCodigo());
                this.store(clone);
            }
        }.execute();
        new TransactionalQuery<Artigosexistencias>(TABLES.artigosexistencias, this.manager){

            @Override
            public void process(Artigosexistencias model) throws Exception {
                Artigosexistencias clone = model.cloneCopy();
                this.delete(model);
                clone.setCascade(false);
                if (clone.getArtigo() == null && clone.getKey() != null) {
                    Artigos artigo = (Artigos)TABLES.artigos.getObject(this.pm, clone.getKey().split(":")[0]);
                    clone.setArtigo(artigo);
                }
                clone.setKey(String.valueOf(clone.getArtigo().getCodigo()) + ":" + clone.getArmazem().getCodigo() + ":" + clone.getNumeroserie() + ":" + clone.getTamanho().getCodigo() + ":" + clone.getCor().getCodigo());
                this.store(clone);
            }
        }.execute();
        new TransactionalQuery<Entidades>(TABLES.entidades, this.manager){

            @Override
            public void process(Entidades model) throws Exception {
                if (model.getRegimeiva() == null) {
                    model.setRegimeiva(0);
                }
                this.store(model);
            }
        }.execute();
    }
}

