/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import java.math.BigDecimal;
import org.dma.java.awt.PrinterHandler;
import org.dma.java.math.SIGNUM;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Metodospagamento;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;

public final class Version70to71
extends AbstractUpdate {
    public Version70to71(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Metodospagamento>(TABLES.metodospagamento, this.manager){

            @Override
            public void process(Metodospagamento model) throws Exception {
                model.setTipo(0);
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Documentostipos>(TABLES.documentostipos, this.manager){

            @Override
            public void process(Documentostipos model) throws Exception {
                model.setImpressora(PrinterHandler.lookupDefaultPrinterName());
                if (model.getTipocarregamento() >= 1) {
                    model.setTipocarregamento(1);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigosmovimentos>(TABLES.artigosmovimentos, this.manager){

            @Override
            public void process(Artigosmovimentos model) throws Exception {
                BigDecimal sinalstock = BigDecimal.ZERO;
                switch (model.getTipodocumento().getMovimentaartigos()) {
                    case 1: {
                        sinalstock = SIGNUM.MINUS_ONE.value;
                        break;
                    }
                    case 2: {
                        sinalstock = SIGNUM.ONE.value;
                    }
                }
                model.setSinalstock(sinalstock);
                this.store(model);
            }
        }.execute();
    }
}

