/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;

public final class Version63to70
extends AbstractUpdate {
    public Version63to70(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Pesquisas>(TABLES.pesquisas, this.manager){
            final Collection<String> list;
            {
                this.list = Arrays.asList("101", "201", "301", "501", "601", "701");
            }

            @Override
            public void process(Pesquisas model) throws Exception {
                if (this.list.contains(model.getCodigo())) {
                    model.setFiltro("");
                    this.store(model);
                }
            }
        }.execute();
        new TransactionalQuery<Parametros>(TABLES.parametros, this.manager){

            @Override
            public void process(Parametros model) throws Exception {
                model.setDataregisto(1);
                model.setSendmail(0);
                model.setSmtpsecurity(0);
                model.setAvisastocknegativo(0);
                model.setAvisastockminimo(0);
                model.setAvisacomposicao(0);
                model.setAvisataxaiva(0);
                if (model.getSmtpserverToText().isEmpty()) {
                    model.setSmtpserver(Colibri.CONTROL_SERVER.getHostName());
                }
                this.store(model);
            }
        }.execute();
    }
}

