/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidadesartigos;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;

public final class Version62to63
extends AbstractUpdate {
    public Version62to63(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Documentostipos>(TABLES.documentostipos, this.manager){

            @Override
            public void process(Documentostipos model) throws Exception {
                Documentostipos.RECORDS record = Documentostipos.RECORDS.get(model.getCodigo());
                if (record != null) {
                    model.setTipodocumentosaft(record.tipodocumentosaft);
                    model.setMovimentaartigos(record.movimentaartigos);
                }
                if (model.isTabela(1) && model.isTipodocumento(1) && (model.getTipoentidade().isTipoentidade(0) && model.isMovimentaartigos(2) || model.getTipoentidade().isTipoentidade(1) && model.isMovimentaartigos(1))) {
                    model.setTipodocumento(4);
                }
                if (!model.isMovimentaartigos(2) || model.isTipodocumento(4)) {
                    model.setActualizaprecoscusto(0);
                    model.setActualizaprecosvenda(0);
                }
                if (model.getTipocarregamento() >= 1) {
                    model.setTipocarregamento(2);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigos>(TABLES.artigos, this.manager){

            @Override
            public void process(Artigos model) throws Exception {
                model.setTipocusto(model.getComposicao().isEmpty() ? 0 : 1);
                if (model.hasImagem()) {
                    model.setBotao(1);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesartigos>(TABLES.entidadesartigos, this.manager){

            @Override
            public void process(Entidadesartigos model) throws Exception {
                Entidadesartigos clone = model.cloneCopy();
                this.delete(model);
                clone.setCascade(false);
                if (clone.getEntidade() != null) {
                    clone.setKey(String.valueOf(clone.getEntidade().getKey()) + ":" + clone.getArtigo().getCodigo() + ":" + clone.getUnidademedida().getCodigo());
                    this.store(clone);
                }
            }
        }.execute();
    }
}

