/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import org.datanucleus.util.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Isencoesiva;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;

public final class Version52to60
extends AbstractUpdate {
    public Version52to60(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Codigosiva>(TABLES.codigosiva, this.manager){

            @Override
            public void process(Codigosiva model) throws Exception {
                if (model.getEspacofiscal() == null) {
                    model.setEspacofiscal(0);
                }
                if (model.getTipotaxa() == null) {
                    model.setTipotaxa(0);
                }
                this.store(model);
            }
        }.execute();
        this.populate(TABLES.isencoesiva);
        new TransactionalQuery<Pesquisas>(TABLES.pesquisas, this.manager){

            @Override
            public void process(Pesquisas model) throws Exception {
                String filtro = model.getFiltro();
                String[][] stringArrayArray = new String[][]{{"#7days1", "#week1"}, {"#7days2", "#week2"}};
                int n = stringArrayArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] var = stringArrayArray[n2];
                    filtro = StringUtils.replaceAll((String)filtro, (String)var[0], (String)var[1]);
                    ++n2;
                }
                model.setFiltro(filtro);
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Documentostipos>(TABLES.documentostipos, this.manager){

            @Override
            public void process(Documentostipos model) throws Exception {
                if (model.isTabela(0) || model.isTipodocumento(1) || model.isTipodocumento(3)) {
                    model.setArredondatotais(1);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Parametros>(TABLES.parametros, this.manager){

            @Override
            public void process(Parametros model) throws Exception {
                if (model.isActualizaprecos(3)) {
                    model.setActualizaprecos(2);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigosmovimentos>(TABLES.artigosmovimentos, this.manager){
            Isencoesiva isencaoiva;
            {
                this.isencaoiva = this.manager.loadIsencoesiva();
            }

            @Override
            public void process(Artigosmovimentos model) throws Exception {
                model.setIsencaoiva(this.isencaoiva);
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidades>(TABLES.entidades, this.manager){

            @Override
            public void process(Entidades model) throws Exception {
                Paises pais = this.manager.loadPaises(model.getPais().getCodigo());
                if (pais.isEstrangeiro() && model.isTipoiva(1) && model.getCodigoiva().isTipotaxa(3)) {
                    model.setIsencaoiva(this.manager.loadIsencoesiva("EXP"));
                } else {
                    model.setIsencaoiva(this.manager.loadIsencoesiva());
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesdocumentos>(TABLES.entidadesdocumentos, this.manager){

            @Override
            public void process(Entidadesdocumentos model) throws Exception {
                model.setHash("");
                model.setEstado(0);
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesdocumentoslinhas>(TABLES.entidadesdocumentoslinhas, this.manager){
            Isencoesiva isencaoiva;
            {
                this.isencaoiva = this.manager.loadIsencoesiva();
            }

            @Override
            public void process(Entidadesdocumentoslinhas model) throws Exception {
                model.setIsencaoiva(this.isencaoiva);
                this.store(model);
            }
        }.execute();
    }
}

